/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OutputEditor
extends ParameterEditor {
    private JTextField field;
    private String paramobject;

    public OutputEditor(MiningMartApplication app, Step step, OpParam opParam) {
        super(app, step, opParam);
        this.editorComponent = new JPanel(new BorderLayout());
        this.field = new JTextField();
        ((JPanel)this.editorComponent).add((Component)this.field, "Center");
        this.init();
        this.setEditable();
    }

    public void init() {
        try {
            this.field.setText("");
            Collection coll = this.getParameterCollection();
            if (coll != null && !coll.isEmpty()) {
                Iterator iter = coll.iterator();
                if (iter.hasNext()) {
                    this.paramobject = (String)iter.next();
                }
                if (this.paramobject != null) {
                    if (this.opParam.isBaseAttribParameter()) {
                        this.field.setText(this.paramobject);
                    } else if (this.opParam.isConceptParameter()) {
                        this.field.setText(this.paramobject);
                    } else if (this.opParam.isFeatureParameter()) {
                        this.field.setText(this.paramobject);
                    } else if (this.opParam.isMcfParameter()) {
                        this.field.setText(this.paramobject);
                    } else if (this.opParam.isRelationParameter()) {
                        this.field.setText(this.paramobject);
                    } else if (this.opParam.isValueParameter()) {
                        this.field.setText(this.paramobject);
                    }
                }
            } else {
                this.field.setText("");
                this.setParameterCollection(new LinkedList());
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public boolean stopCellEditing() {
        Collection coll = this.getParameterCollection();
        boolean changed = true;
        if (coll != null) {
            Iterator iter = coll.iterator();
            String name = null;
            if (iter.hasNext()) {
                name = (String)iter.next();
                changed = !name.equals(this.field.getText());
            }
        } else {
            changed = true;
        }
        if (changed) {
            LinkedList<String> list = new LinkedList<String>();
            list.add(this.field.getText());
            this.setParameterCollection(list);
            this.fireStateChanged();
        }
        return super.stopCellEditing();
    }

    public boolean existsOutput() {
        try {
            if (this.opParam.isConceptParameter()) {
                for (int loop = 1; loop <= this.numberofloops; ++loop) {
                    Collection coll = (Collection)this.oldparamcollections.get(loop - 1);
                    LinkedList actual = (LinkedList)this.paramcollections.get(loop - 1);
                    if (coll == null) {
                        return false;
                    }
                    if (coll.isEmpty()) {
                        return false;
                    }
                    if (actual == null) {
                        actual = new LinkedList();
                    }
                    if (coll.size() == actual.size()) continue;
                    return false;
                }
                return true;
            }
        }
        catch (M4Exception e) {
            M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
        }
        return false;
    }

    public void setEditable() {
        super.setEditable();
        this.field.setEditable(this.editable);
    }
}

