/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.ListSelectDialog;
import edu.udo.cs.miningmart.gui.stepsettings.SelectEditor;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class ListSelectEditor
extends SelectEditor
implements ActionListener,
ItemListener {
    protected JComboBox box;
    protected String[] data = new String[0];
    protected String[] selected_data = new String[0];

    public ListSelectEditor(MiningMartApplication app, Step step, OpParam opParam) {
        super(app, step, opParam);
        this.initComponents();
        this.init();
        this.setEditable();
    }

    private void initComponents() {
        JPanel panel = new JPanel(new BorderLayout());
        this.editorComponent = panel;
        this.setClickCountToStart(1);
        this.box = new JComboBox();
        this.box.setBackground(Color.WHITE);
        this.box.setForeground(Color.BLACK);
        this.box.addItemListener(this);
        panel.add((Component)this.box, "Center");
        this.button = new JButton("...");
        this.button.addActionListener(this);
        panel.add((Component)this.button, "East");
    }

    public void init() {
        this.selected_data = new String[0];
        this.box.removeAllItems();
    }

    public Object getCellEditorValue() {
        String back = "";
        for (int i = 0; i < this.data.length; ++i) {
            back = i == 0 ? back + this.data[i] : back + " " + this.data[i];
        }
        return back;
    }

    public void actionPerformed(ActionEvent e) {
        String[] data = new String[]{"x", "y", "z", "u", "v", "w", "s", "d", "a", "n", "m", "k", "l"};
        ListSelectDialog dialog = new ListSelectDialog(this.app, "title", "selecttitle", data, this.selected_data, true, 4, 10);
        if (dialog.getExitAction() == 1) {
            this.selected_data = dialog.getSelectedDataItems();
            this.setDataItems(this.selected_data);
        }
    }

    public Collection getSelectedValues() {
        LinkedList<String> list = new LinkedList<String>();
        for (int d = 0; d < this.selected_data.length; ++d) {
            list.add(this.selected_data[d]);
        }
        return list;
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.box.getSelectedIndex() != 0 && this.box.getItemCount() > 0) {
            this.box.setSelectedIndex(0);
        }
    }

    public void setDataItems(String[] items) {
        this.box.removeAllItems();
        for (int i = 0; i < items.length; ++i) {
            this.box.addItem(items[i]);
        }
    }

    public String[] getDataItems() {
        return this.selected_data;
    }

    public void setEditable() {
        super.setEditable();
        this.box.setEditable(this.editable);
        this.button.setEnabled(this.editable);
    }
}

