/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.ListSelectDialog;
import edu.udo.cs.miningmart.gui.stepsettings.ListSelectEditor;
import edu.udo.cs.miningmart.gui.stepsettings.StepParameterTable;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.musoft.limo.application.Resource;

public class ListBaseAttributeEditor
extends ListSelectEditor {
    private StepParameterTable table;
    private Vector features;

    public ListBaseAttributeEditor(MiningMartApplication app, StepParameterTable table, OpParam opParam) {
        super(app, table.getTheStep(), opParam);
        this.table = table;
    }

    public void init() {
        super.init();
        try {
            this.selected_data = new String[0];
            Collection coll = this.getFeatureCollection();
            if (coll != null) {
                this.selected_data = new String[coll.size()];
                Iterator iter = coll.iterator();
                int index = 0;
                while (iter.hasNext()) {
                    BaseAttribute baseatt = (BaseAttribute)iter.next();
                    String name = new String("");
                    if (baseatt.getConcept() != null) {
                        name = baseatt.getConcept().getName();
                    }
                    this.selected_data[index] = baseatt.getName() + " [" + name + "]";
                    ++index;
                }
            }
            this.setDataItems(this.selected_data);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String name;
            Collection conceptparams = this.step.getPossibleConceptsForParam(this.opParam);
            this.data = new String[conceptparams.size()];
            Iterator iter = conceptparams.iterator();
            int d = 0;
            while (iter.hasNext()) {
                this.data[d] = (String)iter.next();
                ++d;
            }
            LinkedList concepts = new LinkedList();
            for (int i = 0; i < this.data.length; ++i) {
                concepts.addAll(this.table.getConceptEditorValues(this.data[i]));
            }
            LinkedList<BaseAttribute> battribs = new LinkedList<BaseAttribute>();
            iter = concepts.iterator();
            while (iter.hasNext()) {
                Concept concept = M4Interface.getCurrentCase().getConcept((String)iter.next());
                if (concept == null) continue;
                Collection c = concept.getAllBaseAttributes();
                Iterator iter2 = c.iterator();
                while (iter2.hasNext()) {
                    BaseAttribute ba = (BaseAttribute)iter2.next();
                    if (!this.step.isVisible(ba)) continue;
                    battribs.add(ba);
                }
            }
            this.data = new String[battribs.size()];
            iter = battribs.iterator();
            int c = 0;
            while (iter.hasNext()) {
                BaseAttribute baseatt = (BaseAttribute)iter.next();
                name = new String("");
                if (baseatt.getConcept() != null) {
                    name = baseatt.getConcept().getName();
                }
                this.data[c] = baseatt.getName() + " [" + name + "]";
                ++c;
            }
            ListSelectDialog dialog = new ListSelectDialog(this.app, Resource.getString("STEPSETTINGS_TITLE_BASEATTRIBUTE"), Resource.getString("STEPSETTINGS_TITLE_SELECT_BASEATTRIBUTE"), this.data, this.selected_data, true, this.opParam.getMinArg(), this.opParam.getMaxArg());
            if (dialog.getExitAction() == 1) {
                this.selected_data = dialog.getSelectedDataItems();
                this.setDataItems(this.selected_data);
                LinkedList<BaseAttribute> list = new LinkedList<BaseAttribute>();
                for (int s = 0; s < this.selected_data.length; ++s) {
                    iter = battribs.iterator();
                    BaseAttribute selectedBA = null;
                    boolean found = false;
                    while (iter.hasNext() && !found) {
                        selectedBA = (BaseAttribute)iter.next();
                        name = new String("");
                        if (selectedBA.getConcept() != null) {
                            name = selectedBA.getConcept().getName();
                        }
                        if (!(selectedBA.getName() + " [" + name + "]").equals(this.selected_data[s])) continue;
                        found = true;
                    }
                    if (!found) continue;
                    list.add(selectedBA);
                }
                this.setParameterCollection(list);
                this.fireStateChanged();
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    private void initFeatures() {
        this.features = new Vector();
        this.numberofloops = this.step.getLoopCount();
        if (this.numberofloops == 0) {
            this.numberofloops = 1;
        }
        try {
            for (int i = 0; i < this.numberofloops; ++i) {
                Collection coll;
                if (this.opParam.isCoordinated()) {
                    coll = this.step.getParameter(this.opParam, 0);
                    if (coll == null) {
                        coll = new LinkedList();
                    }
                    this.features.add(coll);
                    continue;
                }
                if (this.opParam.isLoopable() && this.numberofloops == 1) {
                    coll = this.step.getParameter(this.opParam, 0);
                    if (coll == null) {
                        coll = new LinkedList();
                    }
                    this.features.add(coll);
                    continue;
                }
                if (this.opParam.isLoopable() && this.numberofloops > 1) {
                    coll = this.step.getParameter(this.opParam, i + 1);
                    if (coll == null) {
                        coll = new LinkedList();
                    }
                    this.features.add(coll);
                    continue;
                }
                coll = this.step.getParameter(this.opParam, 0);
                if (coll == null) {
                    coll = new LinkedList();
                }
                this.features.add(coll);
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public void setParameterCollection(Collection collection, int loopnumber) {
        super.setParameterCollection(collection, loopnumber);
        boolean loopable = true;
        try {
            loopable = this.opParam.isLoopable();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            loopable = true;
        }
        if (this.features == null) {
            this.initFeatures();
        }
        if (loopable) {
            this.features.set(loopnumber - 1, collection);
        } else {
            for (int i = 0; i < this.paramcollections.size(); ++i) {
                this.features.set(i, collection);
            }
        }
    }

    private Collection getFeatureCollection(int loopnumber) {
        boolean loopable = true;
        try {
            loopable = this.opParam.isLoopable();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            loopable = true;
        }
        if (this.features == null) {
            this.initFeatures();
        }
        if (loopable) {
            return (Collection)this.features.get(loopnumber - 1);
        }
        return (Collection)this.features.get(0);
    }

    private Collection getFeatureCollection() {
        return this.getFeatureCollection(this.loopnumber);
    }

    public void makeOutput(boolean inputchanged, boolean outputchanged, boolean loopcountlower, boolean loopcounthigher) throws M4Exception {
        super.makeOutput(inputchanged, outputchanged, loopcountlower, loopcounthigher);
        this.initFeatures();
    }

    public boolean existsOutput() {
        if (this.opParam.isInput()) {
            return false;
        }
        for (int loop = 1; loop <= this.numberofloops; ++loop) {
            Collection coll = (Collection)this.oldparamcollections.get(loop - 1);
            LinkedList actual = (LinkedList)this.paramcollections.get(loop - 1);
            if (coll == null) {
                return false;
            }
            if (coll.isEmpty()) {
                return false;
            }
            if (actual == null) {
                actual = new LinkedList();
            }
            if (coll.size() != actual.size()) {
                return false;
            }
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                if (actual.contains(iter.next())) continue;
                return false;
            }
        }
        return true;
    }

    public void setNumberOfLoops(int numberofloops) {
        if (numberofloops == 0) {
            numberofloops = 1;
        }
        if (this.features == null) {
            this.initFeatures();
        }
        if (this.features.size() < numberofloops) {
            while (this.features.size() != numberofloops) {
                this.features.add(new LinkedList());
            }
        } else if (this.features.size() > numberofloops) {
            while (this.features.size() != numberofloops) {
                this.features.remove(this.paramcollections.size() - 1);
            }
        }
        super.setNumberOfLoops(numberofloops);
    }
}

