/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.model;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.CreateTransitionDialog;
import edu.udo.cs.miningmart.gui.application.DeleteTransitionDialog;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.model.MiningMartCase;
import edu.udo.cs.miningmart.gui.model.MiningMartChain;
import edu.udo.cs.miningmart.gui.model.MiningMartStep;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.Chain;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.util.Collection;
import java.util.Iterator;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public class StepTransition
extends ModelConnectionElement {
    private Case thecase;
    private MiningMartApplication app;
    private String name;
    private boolean deleteInDatabase = true;
    static /* synthetic */ Class class$org$musoft$limo$model$ModelFigureElement;

    public StepTransition() {
    }

    public void setDeleteInDatabase(boolean bool) {
        this.deleteInDatabase = bool;
    }

    public boolean canDeleteInDatabase() {
        return this.deleteInDatabase;
    }

    public StepTransition(MiningMartApplication app, Case thecase, String name, Model model, ModelFigureElement start, ModelFigureElement end) {
        super(name, model);
        this.name = name;
        this.thecase = thecase;
        this.setStart(start);
        this.setEnd(end);
        this.app = app;
        this.refreshName();
    }

    public void refreshName() {
        try {
            ModelFigureElement start = this.getStart();
            if (start instanceof MiningMartStep) {
                Step step = ((MiningMartStep)start).getStep();
                OpParam input = null;
                OpParam output = null;
                Iterator iter = step.getTheOperator().getOpParamsIterator();
                while (iter.hasNext()) {
                    OpParam opparam = (OpParam)iter.next();
                    if (opparam.getName().equals("TheInputConcept")) {
                        input = opparam;
                        continue;
                    }
                    if (!opparam.getName().equals("TheOutputConcept")) continue;
                    output = opparam;
                }
                if (output != null) {
                    Collection params = step.getParameter(output, 0);
                    if (params != null && params.size() > 0) {
                        iter = params.iterator();
                        if (iter.hasNext()) {
                            Concept concept = (Concept)iter.next();
                            this.setName(concept.getName());
                        } else {
                            this.setName(this.name);
                        }
                    }
                } else if (input != null) {
                    Collection params = step.getParameter(input, 0);
                    if (params != null && params.size() > 0) {
                        iter = params.iterator();
                        if (iter.hasNext()) {
                            Concept concept = (Concept)iter.next();
                            this.setName(concept.getName());
                        } else {
                            this.setName(this.name);
                        }
                    }
                } else {
                    this.setName(this.name);
                }
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            this.setName(this.name);
        }
    }

    public void setMMartApplication(MiningMartApplication app) {
        if (this.app == null) {
            this.app = app;
        }
    }

    public MiningMartApplication getMMartApplication() {
        return this.app;
    }

    public boolean addTransitionToCase() {
        try {
            if (this.getStart() instanceof MiningMartChain && this.getEnd() instanceof MiningMartChain) {
                Chain chainend;
                MiningMartChain mchainstart = (MiningMartChain)this.getStart();
                MiningMartChain mchainend = (MiningMartChain)this.getEnd();
                Chain chainstart = mchainstart.getChain();
                CreateTransitionDialog dialog = new CreateTransitionDialog(null, chainstart, chainend = mchainend.getChain());
                if (dialog.getExitAction() != 1) {
                    return false;
                }
                Step[] steps = new Step[]{dialog.getFromStep(), dialog.getToStep()};
                this.thecase.addStepDependency(steps[0], steps[1]);
                ModelFigureElement p = mchainstart.getParent();
                if (p instanceof MiningMartCase ? ((MiningMartCase)p).existsTransition(mchainstart, mchainend) : p instanceof MiningMartChain && ((MiningMartChain)p).existsTransition(mchainstart, mchainend)) {
                    return false;
                }
            } else if (this.getStart() instanceof MiningMartStep && this.getEnd() instanceof MiningMartChain) {
                Chain chainend;
                MiningMartStep mstepstart = (MiningMartStep)this.getStart();
                MiningMartChain mchainend = (MiningMartChain)this.getEnd();
                Step stepstart = mstepstart.getStep();
                CreateTransitionDialog dialog = new CreateTransitionDialog(null, stepstart, chainend = mchainend.getChain());
                if (dialog.getExitAction() != 1) {
                    return false;
                }
                Step[] steps = new Step[]{dialog.getFromStep(), dialog.getToStep()};
                this.thecase.addStepDependency(stepstart, steps[1]);
                if (((MiningMartChain)mchainend.getParent()).existsTransition(mstepstart, mchainend)) {
                    return false;
                }
            } else if (this.getStart() instanceof MiningMartChain && this.getEnd() instanceof MiningMartStep) {
                Step stepend;
                MiningMartChain mchainstart = (MiningMartChain)this.getStart();
                MiningMartStep mstepend = (MiningMartStep)this.getEnd();
                Chain chainstart = mchainstart.getChain();
                CreateTransitionDialog dialog = new CreateTransitionDialog(null, chainstart, stepend = mstepend.getStep());
                if (dialog.getExitAction() != 1) {
                    return false;
                }
                Step[] steps = new Step[]{dialog.getFromStep(), dialog.getToStep()};
                this.thecase.addStepDependency(steps[0], stepend);
                if (((MiningMartChain)mchainstart.getParent()).existsTransition(mchainstart, mstepend)) {
                    return false;
                }
            } else if (this.getStart() instanceof MiningMartStep && this.getEnd() instanceof MiningMartStep) {
                MiningMartStep mstepstart = (MiningMartStep)this.getStart();
                MiningMartStep mstepend = (MiningMartStep)this.getEnd();
                Step stepstart = mstepstart.getStep();
                Step stepend = mstepend.getStep();
                if (stepstart.getTheCase().containsDependency(stepstart, stepend)) {
                    return false;
                }
                this.thecase.addStepDependency(stepstart, stepend);
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return false;
        }
        return true;
    }

    public boolean canConnect(ModelFigureElement start, ModelFigureElement end) {
        return true;
    }

    protected Class getStartClass() {
        return class$org$musoft$limo$model$ModelFigureElement == null ? (class$org$musoft$limo$model$ModelFigureElement = StepTransition.class$("org.musoft.limo.model.ModelFigureElement")) : class$org$musoft$limo$model$ModelFigureElement;
    }

    protected String getStartName() {
        return "outgoing";
    }

    protected Class getEndClass() {
        return class$org$musoft$limo$model$ModelFigureElement == null ? (class$org$musoft$limo$model$ModelFigureElement = StepTransition.class$("org.musoft.limo.model.ModelFigureElement")) : class$org$musoft$limo$model$ModelFigureElement;
    }

    protected String getEndName() {
        return "incoming";
    }

    public String getLabel() {
        String t = ((ModelPrimitiveAttribute)this.getAttribute("trigger")).getString();
        String e = ((ModelPrimitiveAttribute)this.getAttribute("effect")).getString();
        String g = ((ModelPrimitiveAttribute)this.getAttribute("guard")).getString();
        if ("".equals(t)) {
            t = null;
        }
        if ("".equals(e)) {
            e = null;
        }
        if ("".equals(g)) {
            g = null;
        }
        String s = (t == null ? "" : t) + (g == null ? "" : "[" + g + "]") + (e == null ? "" : "/" + e);
        return "".equals(s) ? null : s;
    }

    public String toString() {
        return this.getName() + ": " + this.getType();
    }

    public boolean canDestroy() {
        return this.app.getViewMode() != 1;
    }

    public String getType() {
        return Resource.getString("TRANSITION");
    }

    public void destroy() {
        if (this.app.getViewMode() == 1) {
            return;
        }
        if (this.canDeleteInDatabase()) {
            try {
                if (this.getStart() instanceof MiningMartChain && this.getEnd() instanceof MiningMartChain) {
                    Chain chainend;
                    MiningMartChain mchainstart = (MiningMartChain)this.getStart();
                    MiningMartChain mchainend = (MiningMartChain)this.getEnd();
                    Chain chainstart = mchainstart.getChain();
                    DeleteTransitionDialog dialog = new DeleteTransitionDialog(null, chainstart, chainend = mchainend.getChain());
                    if (dialog.getExitAction() != 1) {
                        return;
                    }
                    this.thecase.removeStepDependency(dialog.getFromStep(), dialog.getToStep());
                    if (!chainstart.dependencyExists(chainend)) {
                        super.destroy();
                    }
                } else if (this.getStart() instanceof MiningMartStep && this.getEnd() instanceof MiningMartChain) {
                    Chain chainend;
                    MiningMartStep mstepstart = (MiningMartStep)this.getStart();
                    MiningMartChain mchainend = (MiningMartChain)this.getEnd();
                    Step stepstart = mstepstart.getStep();
                    DeleteTransitionDialog dialog = new DeleteTransitionDialog(null, stepstart, chainend = mchainend.getChain());
                    if (dialog.getExitAction() != 1) {
                        return;
                    }
                    this.thecase.removeStepDependency(dialog.getFromStep(), dialog.getToStep());
                    if (!stepstart.dependencyExists(chainend)) {
                        super.destroy();
                    }
                } else if (this.getStart() instanceof MiningMartChain && this.getEnd() instanceof MiningMartStep) {
                    Step stepend;
                    MiningMartChain mchainstart = (MiningMartChain)this.getStart();
                    MiningMartStep mstepend = (MiningMartStep)this.getEnd();
                    Chain chainstart = mchainstart.getChain();
                    DeleteTransitionDialog dialog = new DeleteTransitionDialog(null, chainstart, stepend = mstepend.getStep());
                    if (dialog.getExitAction() != 1) {
                        return;
                    }
                    this.thecase.removeStepDependency(dialog.getFromStep(), dialog.getToStep());
                    if (!chainstart.dependencyExists(stepend)) {
                        super.destroy();
                    }
                } else if (this.getStart() instanceof MiningMartStep && this.getEnd() instanceof MiningMartStep) {
                    MiningMartStep mstepstart = (MiningMartStep)this.getStart();
                    MiningMartStep mstepend = (MiningMartStep)this.getEnd();
                    Step stepstart = mstepstart.getStep();
                    Step stepend = mstepend.getStep();
                    this.thecase.removeStepDependency(stepstart, stepend);
                    super.destroy();
                }
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
        } else {
            super.destroy();
        }
    }

    public boolean canSetName(String name) {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

