/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.model;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.model.MiningMartChain;
import edu.udo.cs.miningmart.gui.model.MiningMartModelFigureElement;
import edu.udo.cs.miningmart.gui.model.StepTransition;
import edu.udo.cs.miningmart.m4.M4Data;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public class MiningMartStep
extends MiningMartModelFigureElement {
    private MiningMartChain parentchain;
    private Step step;
    private MiningMartApplication app;
    private boolean deleteInDatabase = true;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$gui$model$StepTransition;

    public MiningMartStep(MiningMartApplication app, Step step, ModelFigureElement parent, Point position, Rectangle bounds) {
        super(step.getName(), bounds, parent);
        this.parentchain = (MiningMartChain)parent;
        this.step = step;
        this.app = app;
        String opName = step.getTheOperator().getName();
        this.setPosition(position);
        this.addAttribute(new ModelPrimitiveAttribute(this, "Operator", 1, ModelPrimitiveAttribute.TYPE_STRING));
        this.addAttribute(new ModelAssociationEnd(this, "incoming", 3, true, class$edu$udo$cs$miningmart$gui$model$StepTransition == null ? (class$edu$udo$cs$miningmart$gui$model$StepTransition = MiningMartStep.class$("edu.udo.cs.miningmart.gui.model.StepTransition")) : class$edu$udo$cs$miningmart$gui$model$StepTransition, "end"));
        this.addAttribute(new ModelAssociationEnd(this, "outgoing", 3, true, class$edu$udo$cs$miningmart$gui$model$StepTransition == null ? (class$edu$udo$cs$miningmart$gui$model$StepTransition = MiningMartStep.class$("edu.udo.cs.miningmart.gui.model.StepTransition")) : class$edu$udo$cs$miningmart$gui$model$StepTransition, "start"));
        try {
            ((ModelPrimitiveAttribute)this.getAttribute("notes")).setString(step.getDocumentation());
        }
        catch (M4Exception error) {
            // empty catch block
        }
        ((ModelPrimitiveAttribute)this.getAttribute("Operator")).setString(opName);
        ((ModelPrimitiveAttribute)this.getAttribute(Resource.getString("ATTR_COLOR"))).setColor(Color.WHITE);
    }

    public void setDeleteInDatabase(boolean bool) {
        this.deleteInDatabase = bool;
    }

    public boolean canDeleteInDatabase() {
        return this.deleteInDatabase;
    }

    public MiningMartApplication getMMartApplication() {
        return this.app;
    }

    public boolean canSetParent(ModelFigureElement parent) {
        return true;
    }

    public String getType() {
        return Resource.getString("STEP");
    }

    public String getName() {
        if (this.step != null) {
            return this.step.getName();
        }
        return "";
    }

    public void setName(String name) {
        if (this.step != null) {
            this.step.setName(name);
        }
        super.setName(name);
        if (this.app != null && this.app.isShowingSettings(this)) {
            this.app.getStepSettings().setStepName(name);
        }
    }

    public Step getStep() {
        return this.step;
    }

    M4Data getAttachedM4Object() {
        return this.getStep();
    }

    public void primitiveAttributeChanged(ModelPrimitiveAttribute mpa) {
        super.primitiveAttributeChanged(mpa);
        if (mpa.getName().equals(Resource.getString("ATTR_NAME")) && this.step != null) {
            this.setName(mpa.getString());
        }
    }

    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        if (bounds == null) {
            return;
        }
        if (this.step == null) {
            return;
        }
        try {
            this.step.setPoint(bounds.getLocation());
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public void setPosition(Point p) {
        super.setPosition(p);
        try {
            this.step.setPoint(p);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public boolean canDestroy() {
        return this.app.getViewMode() != 1;
    }

    public void destroy() {
        int i;
        if (this.app.getViewMode() == 1) {
            return;
        }
        for (i = this.parentchain.getConnectionCount() - 1; i >= 0; --i) {
            StepTransition trans = (StepTransition)this.parentchain.getConnection(i);
            if (!trans.getStart().getName().equals(this.getName()) && !trans.getEnd().getName().equals(this.getName())) continue;
            trans.destroy();
        }
        super.destroy();
        for (i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onDestroy(this);
        }
        if (this.canDeleteInDatabase()) {
            try {
                String stepname = this.step.getName();
                this.step.deleteSoon();
                M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("DELETED_STEP") + " " + stepname);
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
        }
        if (this.app.isShowingSettings(this)) {
            this.app.removeStepSettingsPanel();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

