/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.model;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Projection;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.util.Collection;
import java.util.Iterator;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public class MiningMartProjection
extends ModelConnectionElement {
    private Projection projection;
    private MiningMartApplication app;
    private boolean deleteInDatabase = true;
    static /* synthetic */ Class class$org$musoft$limo$model$ModelFigureElement;

    public MiningMartProjection() {
    }

    public MiningMartProjection(MiningMartApplication app, Projection projection, String name, Model model, ModelFigureElement start, ModelFigureElement end) {
        super(name, model);
        this.projection = projection;
        this.setStart(start);
        this.setEnd(end);
        this.app = app;
    }

    public void setMMartApplication(MiningMartApplication app) {
        if (this.app == null) {
            this.app = app;
        }
    }

    public MiningMartApplication getMMartApplication() {
        return this.app;
    }

    public void setDeleteInDatabase(boolean bool) {
        this.deleteInDatabase = bool;
    }

    public boolean canDeleteInDatabase() {
        return this.deleteInDatabase;
    }

    public boolean canConnect(ModelFigureElement start, ModelFigureElement end) {
        Concept from = ((MiningMartConcept)start).getConcept();
        Concept to = ((MiningMartConcept)end).getConcept();
        try {
            Collection fromproj = from.getProjectionsAsFromConcept();
            Iterator iter = fromproj.iterator();
            while (iter.hasNext()) {
                Projection proj = (Projection)iter.next();
                if (!proj.getToConcept().equals(to)) continue;
                return false;
            }
        }
        catch (M4Exception error) {
            return false;
        }
        return true;
    }

    protected Class getStartClass() {
        return class$org$musoft$limo$model$ModelFigureElement == null ? (class$org$musoft$limo$model$ModelFigureElement = MiningMartProjection.class$("org.musoft.limo.model.ModelFigureElement")) : class$org$musoft$limo$model$ModelFigureElement;
    }

    protected String getStartName() {
        return "outgoing";
    }

    protected Class getEndClass() {
        return class$org$musoft$limo$model$ModelFigureElement == null ? (class$org$musoft$limo$model$ModelFigureElement = MiningMartProjection.class$("org.musoft.limo.model.ModelFigureElement")) : class$org$musoft$limo$model$ModelFigureElement;
    }

    protected String getEndName() {
        return "incoming";
    }

    public String toString() {
        return this.getName() + ": " + this.getType();
    }

    public boolean canDestroy() {
        return this.app.getViewMode() != 1;
    }

    public String getType() {
        return Resource.getString("PROJECTION");
    }

    public void destroy() {
        if (this.app.getViewMode() == 1) {
            return;
        }
        super.destroy();
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onDestroy(this);
        }
        if (this.canDeleteInDatabase()) {
            try {
                String relationname = this.projection.getName();
                this.projection.deleteSoon();
                M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("DELETED_RELATION") + " " + relationname);
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
        }
    }

    public boolean canSetName(String name) {
        return false;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void primitiveAttributeChanged(ModelPrimitiveAttribute mpa) {
        super.primitiveAttributeChanged(mpa);
        try {
            if (mpa.getName().equals("notes") && this.projection != null) {
                this.projection.setDocumentation(mpa.getString());
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

