/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.model;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.MiningMartMenuBar;
import edu.udo.cs.miningmart.gui.application.MiningMartToolBar;
import edu.udo.cs.miningmart.gui.model.MiningMartChain;
import edu.udo.cs.miningmart.gui.model.MiningMartModel;
import edu.udo.cs.miningmart.gui.model.MiningMartStep;
import edu.udo.cs.miningmart.gui.model.StepTransition;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.Chain;
import edu.udo.cs.miningmart.m4.GraphicalM4Object;
import edu.udo.cs.miningmart.m4.M4Data;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public class MiningMartCase
extends MiningMartModel {
    private LinkedList namelist;
    private Case thecase;
    private MiningMartApplication app;
    private int transcounter;
    private boolean deleteInDatabase = true;
    private boolean cansetdirty = true;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$Chain;

    public MiningMartCase(MiningMartApplication app, Case thecase) {
        super(thecase.getName());
        this.app = app;
        this.thecase = thecase;
        this.transcounter = 0;
        this.namelist = new LinkedList();
        this.deleteInDatabase = true;
        this.cansetdirty = true;
        ((ModelPrimitiveAttribute)this.getAttribute(Resource.getString("ATTR_COLOR"))).setColor(Color.white);
        try {
            ((ModelPrimitiveAttribute)this.getAttribute("notes")).setString(thecase.getDocumentation());
        }
        catch (M4Exception m4Exception) {
            // empty catch block
        }
    }

    public void setDeleteInDatabase(boolean bool, boolean propagate) {
        this.deleteInDatabase = bool;
        if (propagate) {
            int i;
            for (i = 0; i < this.getConnectionCount(); ++i) {
                ((StepTransition)this.getConnection(i)).setDeleteInDatabase(bool);
            }
            for (i = 0; i < this.getChildCount(); ++i) {
                ModelFigureElement child = this.getChild(i);
                if (!(child instanceof MiningMartChain)) continue;
                ((MiningMartChain)child).setDeleteInDatabase(bool, true);
            }
        }
    }

    public boolean canDeleteInDatabase() {
        return this.deleteInDatabase;
    }

    public int getTransitionCounter() {
        return this.transcounter;
    }

    public int incrementTransitionCounter() {
        ++this.transcounter;
        return this.transcounter;
    }

    public int decrementTransitionCounter() {
        if (this.transcounter > 0) {
            --this.transcounter;
        }
        return this.transcounter;
    }

    public MiningMartApplication getMMartApplication() {
        return this.app;
    }

    public void initTheCase() {
        this.cansetdirty = false;
        try {
            Collection c = this.thecase.getTopLevelChains();
            Iterator iter = c.iterator();
            int i = 10;
            while (iter.hasNext()) {
                Chain chain = (Chain)iter.next();
                Point p = chain.getPoint();
                if (p == null) {
                    p = new Point(i, i);
                    chain.setPoint(p);
                }
                MiningMartChain mchain = new MiningMartChain(this.app, this.thecase, chain, this.thecase.getName(), p, new Rectangle(p.x, p.y, 35, 35), this);
                mchain.initTheChain();
                this.addMiningMartChain(this, mchain);
                i += 40;
            }
            this.organizeTransitions(false);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        this.cansetdirty = true;
    }

    public void organizeTransitions(boolean check) throws M4Exception {
        int childs = this.getChildCount();
        MiningMartChain mchain1 = null;
        MiningMartChain mchain2 = null;
        Chain chain1 = null;
        Chain chain2 = null;
        for (int a = 0; a < childs; ++a) {
            ModelFigureElement elem1 = this.getChild(a);
            if (!(elem1 instanceof MiningMartChain)) continue;
            mchain1 = (MiningMartChain)elem1;
            chain1 = mchain1.getChain();
            for (int j = 0; j < childs; ++j) {
                ModelFigureElement elem2 = this.getChild(j);
                if (!(elem2 instanceof MiningMartChain)) continue;
                mchain2 = (MiningMartChain)elem2;
                chain2 = mchain2.getChain();
                if (mchain1.getName().equals(mchain2.getName())) continue;
                boolean create = true;
                if (check) {
                    boolean bl = create = !this.existsTransition(mchain1, mchain2);
                }
                if (!chain1.dependencyExists(chain2) || !create) continue;
                this.incrementTransitionCounter();
                StepTransition transition = new StepTransition(this.app, this.thecase, Resource.getString("DEPENDENCY") + "(" + this.getTransitionCounter() + ")", this, mchain1, mchain2);
                this.addStepTransition(transition);
            }
        }
    }

    public boolean existsTransition(ModelFigureElement start, ModelFigureElement end) {
        StepTransition trans = null;
        for (int c = 0; c < this.getConnectionCount(); ++c) {
            trans = (StepTransition)this.getConnection(c);
            if (!trans.getStartName().equals(start.getName()) || !trans.getEndName().equals(end.getName())) continue;
            return true;
        }
        return false;
    }

    public MiningMartChain addMiningMartChain(ModelFigureElement parent, MiningMartChain chain) {
        if (!(parent instanceof Model)) {
            return null;
        }
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onCreateChild(this, chain);
        }
        if (chain.canSetParent(this) && this.canAddChild(chain)) {
            chain.setParent(this);
        } else {
            chain.destroy();
            chain = null;
        }
        return chain;
    }

    public MiningMartChain createMiningMartChain(ModelFigureElement parent, String name, Point point, Rectangle bounds) {
        Chain chain;
        try {
            name = this.thecase.getValidName(name, class$edu$udo$cs$miningmart$m4$Chain == null ? (class$edu$udo$cs$miningmart$m4$Chain = MiningMartCase.class$("edu.udo.cs.miningmart.m4.Chain")) : class$edu$udo$cs$miningmart$m4$Chain);
            chain = this.thecase.createChain(name);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return null;
        }
        MiningMartChain result = new MiningMartChain(this.app, this.thecase, chain, this.getName(), point, bounds, parent);
        result.initTheChain();
        return this.addMiningMartChain(parent, result);
    }

    public MiningMartChain createMiningMartChain(ModelFigureElement parent, Chain chain, Point point, Rectangle bounds) {
        MiningMartChain result = new MiningMartChain(this.app, this.thecase, chain, this.getName(), point, bounds, parent);
        result.initTheChain();
        return this.addMiningMartChain(parent, result);
    }

    public StepTransition addStepTransition(StepTransition transition) {
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onCreateConnection(this, transition);
        }
        return transition;
    }

    public StepTransition createTransition(String name, ModelFigureElement start, ModelFigureElement end, boolean existsTransition) {
        StepTransition result;
        boolean adding;
        if (name == null) {
            this.incrementTransitionCounter();
            name = Resource.getString("DEPENDENCY") + "(" + this.getTransitionCounter() + ")";
        }
        if ((adding = (result = new StepTransition(this.app, this.thecase, name, this, start, end)).addTransitionToCase()) && !existsTransition) {
            return this.addStepTransition(result);
        }
        return null;
    }

    public boolean canAddChild(ModelFigureElement child) {
        return true;
    }

    public boolean canRemoveChild(ModelFigureElement child) {
        return true;
    }

    public boolean canSetParent(ModelFigureElement parent) {
        return true;
    }

    public String getType() {
        return Resource.getString("CASE");
    }

    public String getName() {
        return this.thecase.getName();
    }

    public void setName(String name) {
        if (this.thecase != null && name != null) {
            this.thecase.setName(name);
            super.setName(name);
        }
    }

    public Case getTheCase() {
        return this.thecase;
    }

    M4Data getAttachedM4Object() {
        return this.getTheCase();
    }

    public boolean canDestroy() {
        return this.app.getViewMode() != 1;
    }

    public void primitiveAttributeChanged(ModelPrimitiveAttribute mpa) {
        super.primitiveAttributeChanged(mpa);
    }

    public void setDirty(boolean dirty) {
        if (!this.cansetdirty) {
            return;
        }
        if (this.app != null && this.app.getViewMode() == 1) {
            return;
        }
        super.setDirty(dirty);
        if (dirty && this.app != null) {
            ((MiningMartMenuBar)this.app.getJMenuBar()).setItemState(Resource.getString("MENU_CASE") + "." + Resource.getString("MENU_CASE_SAVE"), true);
            ((MiningMartToolBar)this.app.getToolbar()).enableTool(Resource.getString("TOOL_SAVECASE"), true);
        }
        if (this.app != null) {
            this.app.updateToolsAndMenus();
        }
    }

    public void dissolveMiningMartChain(MiningMartChain mchain) throws M4Exception {
        int i;
        LinkedList<GraphicalM4Object> subelements = new LinkedList<GraphicalM4Object>();
        for (i = 0; i < mchain.getChildCount(); ++i) {
            ModelFigureElement child = mchain.getChild(i);
            if (child instanceof MiningMartChain) {
                subelements.add(((MiningMartChain)child).getChain());
            }
            if (!(child instanceof MiningMartStep)) continue;
            subelements.add(((MiningMartStep)child).getStep());
        }
        this.app.getMiningMartCase().setDeleteInDatabase(false, true);
        mchain.destroy();
        for (i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onRemoveChild(this, mchain);
        }
        this.app.getMiningMartCase().setDeleteInDatabase(true, true);
        Iterator iter = subelements.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (!(next instanceof Chain)) continue;
            Chain subchain = (Chain)next;
            MiningMartChain submchain = this.createMiningMartChain((ModelFigureElement)this, subchain, subchain.getPoint(), new Rectangle(35, 35));
            for (int i2 = 0; i2 < this.getListenerCount(); ++i2) {
                this.getListener(i2).onAddChild(submchain, this);
            }
        }
        this.organizeTransitions(true);
    }

    public void destroy() {
        this.cansetdirty = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            MiningMartChain mchain = (MiningMartChain)this.getChild(i);
            mchain.setDeleteInDatabase(false, true);
        }
        for (int i = 0; i < this.getConnectionCount(); ++i) {
            StepTransition trans = (StepTransition)this.getConnection(i);
            trans.setDeleteInDatabase(false);
        }
        super.destroy();
        this.cansetdirty = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

