/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.util.M4ObjectComparator;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.ColumnStatistics2;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.musoft.limo.application.Resource;

public class StatisticsDialog
extends JDialog
implements ActionListener {
    private MiningMartApplication app;
    private Columnset columnset;
    private Vector columns;
    private JButton closeButton;
    private JButton updateButton;
    private JTable statalltable;
    private JTable stat1table;
    private JTable stat2table;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;

    public StatisticsDialog(MiningMartApplication app, Columnset columnset) {
        super((Frame)app, true);
        this.app = app;
        this.columnset = columnset;
        try {
            this.columnset.updateStatistics();
            this.columns = new Vector();
            this.columns.addAll(columnset.getColumns());
            Collections.sort(this.columns, new M4ObjectComparator());
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(750, 600);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout(5, 5));
        toppanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(toppanel);
        JPanel infopanel = new JPanel();
        infopanel.setLayout(new GridLayout(2, 1, 5, 5));
        infopanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        toppanel.add((Component)infopanel, "North");
        JLabel label = new JLabel();
        label.setText(Resource.getString("COLUMNSET") + " - " + Resource.getString("STATISTICS"));
        Font font = new Font("SansSerif", 1, 15);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        infopanel.add(label);
        label = new JLabel();
        label.setText(this.columnset.getName());
        font = new Font("SansSerif", 0, 13);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        label.setForeground(Color.BLUE);
        infopanel.add(label);
        this.updateButton = new JButton(Resource.getString("UPDATE"));
        this.updateButton.addActionListener(this);
        if (this.app.getViewMode() != 0) {
            this.updateButton.setEnabled(false);
        }
        this.closeButton = new JButton(Resource.getString("CLOSE"));
        this.closeButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.updateButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPanel.add(this.closeButton);
        toppanel.add((Component)buttonPanel, "South");
        JPanel midpanel = new JPanel();
        midpanel.setLayout(new BorderLayout(5, 5));
        toppanel.add((Component)midpanel, "Center");
        this.statalltable = new JTable();
        this.statalltable.setSelectionMode(2);
        this.statalltable.getTableHeader().setReorderingAllowed(false);
        this.statalltable.setRowHeight(this.statalltable.getRowHeight() + 2);
        this.statalltable.setModel(new StatisticsAllTableModel());
        JScrollPane scrollpane = new JScrollPane(this.statalltable);
        scrollpane.setPreferredSize(new Dimension(scrollpane.getWidth(), 36));
        midpanel.add((Component)scrollpane, "North");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridLayout(2, 1, 5, 5));
        midpanel.add((Component)centerPanel, "Center");
        JPanel stat1panel = new JPanel();
        stat1panel.setLayout(new BorderLayout(5, 5));
        centerPanel.add(stat1panel);
        label = new JLabel();
        label.setText(Resource.getString("STATISTICS_NUMERICAL"));
        font = new Font("SansSerif", 1, 12);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        stat1panel.add((Component)label, "North");
        this.stat1table = new JTable();
        this.stat1table.setSelectionMode(2);
        this.stat1table.getTableHeader().setReorderingAllowed(false);
        this.stat1table.setRowHeight(this.stat1table.getRowHeight() + 2);
        this.stat1table.setModel(new Statistics1TableModel());
        stat1panel.add((Component)new JScrollPane(this.stat1table), "Center");
        JPanel stat2panel = new JPanel();
        stat2panel.setLayout(new BorderLayout(5, 5));
        centerPanel.add(stat2panel);
        label = new JLabel();
        label.setText(Resource.getString("STATISTICS_DISTRIBUTION"));
        font = new Font("SansSerif", 1, 12);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        stat2panel.add((Component)label, "North");
        this.stat2table = new JTable();
        this.stat2table.setSelectionMode(2);
        this.stat2table.getTableHeader().setReorderingAllowed(false);
        this.stat2table.setRowHeight(this.stat2table.getRowHeight() + 2);
        this.stat2table.setModel(new Statistics2TableModel());
        stat2panel.add((Component)new JScrollPane(this.stat2table), "Center");
    }

    private void updateStatistics() {
        try {
            this.columnset.clearStatistics();
            this.columnset.updateStatistics();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        ((Statistics2TableModel)this.stat2table.getModel()).initDistribution();
        ((AbstractTableModel)this.statalltable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)this.stat1table.getModel()).fireTableDataChanged();
        ((AbstractTableModel)this.stat2table.getModel()).fireTableDataChanged();
        this.app.getModel().setDirty(true);
    }

    public void actionPerformed(ActionEvent event) {
        if (!(event.getSource() instanceof JButton)) {
            return;
        }
        JButton source = (JButton)event.getSource();
        if (source.getText().equals(this.closeButton.getText())) {
            this.dispose();
        }
        if (source.getText().equals(this.updateButton.getText())) {
            this.updateStatistics();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Statistics2TableModel
    extends AbstractTableModel {
        private Vector distribution;

        public Statistics2TableModel() {
            this.initDistribution();
        }

        public void initDistribution() {
            this.distribution = new Vector();
            for (int i = 0; i < StatisticsDialog.this.columns.size(); ++i) {
                LinkedList dists;
                Column column = (Column)StatisticsDialog.this.columns.get(i);
                try {
                    dists = column.getDistributionStatistics();
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                    dists = new LinkedList();
                }
                this.distribution.addAll(dists);
            }
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return class$java$lang$String == null ? (class$java$lang$String = StatisticsDialog.class$("java.lang.String")) : class$java$lang$String;
                }
                case 1: {
                    return class$java$lang$String == null ? (class$java$lang$String = StatisticsDialog.class$("java.lang.String")) : class$java$lang$String;
                }
                case 2: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = StatisticsDialog.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
                case 3: {
                    return class$java$lang$Double == null ? (class$java$lang$Double = StatisticsDialog.class$("java.lang.Double")) : class$java$lang$Double;
                }
                case 4: {
                    return class$java$lang$Double == null ? (class$java$lang$Double = StatisticsDialog.class$("java.lang.Double")) : class$java$lang$Double;
                }
            }
            return class$java$lang$String == null ? (class$java$lang$String = StatisticsDialog.class$("java.lang.String")) : class$java$lang$String;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Resource.getString("STATISTICS_COLUMNNAME");
                }
                case 1: {
                    return Resource.getString("STATISTICS_VALUE");
                }
                case 2: {
                    return Resource.getString("STATISTICS_COUNT");
                }
                case 3: {
                    return Resource.getString("STATISTICS_MIN");
                }
                case 4: {
                    return Resource.getString("STATISTICS_MAX");
                }
            }
            return ":-)";
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            return this.distribution.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            ColumnStatistics2 stat2 = (ColumnStatistics2)this.distribution.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return stat2.getTheColumn().getName();
                }
                case 1: {
                    return stat2.getDistributionValue();
                }
                case 2: {
                    return new Integer(stat2.getDistributionCount());
                }
                case 3: {
                    return new Double(stat2.getDistributionMinimum());
                }
                case 4: {
                    return new Double(stat2.getDistributionMaximum());
                }
            }
            return ":-)";
        }
    }

    private class Statistics1TableModel
    extends AbstractTableModel {
        private Statistics1TableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return class$java$lang$String == null ? (class$java$lang$String = StatisticsDialog.class$("java.lang.String")) : class$java$lang$String;
                }
                case 1: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = StatisticsDialog.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
                case 2: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = StatisticsDialog.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
                case 3: {
                    return class$java$lang$String == null ? (class$java$lang$String = StatisticsDialog.class$("java.lang.String")) : class$java$lang$String;
                }
                case 4: {
                    return class$java$lang$String == null ? (class$java$lang$String = StatisticsDialog.class$("java.lang.String")) : class$java$lang$String;
                }
                case 5: {
                    return class$java$lang$Double == null ? (class$java$lang$Double = StatisticsDialog.class$("java.lang.Double")) : class$java$lang$Double;
                }
                case 6: {
                    return class$java$lang$Double == null ? (class$java$lang$Double = StatisticsDialog.class$("java.lang.Double")) : class$java$lang$Double;
                }
                case 7: {
                    return class$java$lang$Double == null ? (class$java$lang$Double = StatisticsDialog.class$("java.lang.Double")) : class$java$lang$Double;
                }
                case 8: {
                    return class$java$lang$Double == null ? (class$java$lang$Double = StatisticsDialog.class$("java.lang.Double")) : class$java$lang$Double;
                }
                case 9: {
                    return class$java$lang$String == null ? (class$java$lang$String = StatisticsDialog.class$("java.lang.String")) : class$java$lang$String;
                }
            }
            return class$java$lang$String == null ? (class$java$lang$String = StatisticsDialog.class$("java.lang.String")) : class$java$lang$String;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Resource.getString("STATISTICS_COLUMNNAME");
                }
                case 1: {
                    return Resource.getString("STATISTICS_UNIQUE");
                }
                case 2: {
                    return Resource.getString("STATISTICS_MISSING");
                }
                case 3: {
                    return Resource.getString("STATISTICS_MIN");
                }
                case 4: {
                    return Resource.getString("STATISTICS_MAX");
                }
                case 5: {
                    return Resource.getString("STATISTICS_AVG");
                }
                case 6: {
                    return Resource.getString("STATISTICS_MEDIAN");
                }
                case 7: {
                    return Resource.getString("STATISTICS_STDEV");
                }
                case 8: {
                    return Resource.getString("STATISTICS_VARIANCE");
                }
                case 9: {
                    return Resource.getString("STATISTICS_MODAL");
                }
            }
            return ":-)";
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColumnCount() {
            return 10;
        }

        public int getRowCount() {
            return StatisticsDialog.this.columns.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                Column column = (Column)StatisticsDialog.this.columns.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return column.getName();
                    }
                    case 1: {
                        return new Integer(column.getNumberOfUniqueValues());
                    }
                    case 2: {
                        return new Integer(column.getNumberOfMissingValues());
                    }
                    case 3: {
                        if (column.getMinValue() == null || column.getMinValue().length() == 0) {
                            return "";
                        }
                        return column.getMinValue();
                    }
                    case 4: {
                        if (column.getMaxValue() == null || column.getMaxValue().length() == 0) {
                            return "";
                        }
                        return column.getMaxValue();
                    }
                    case 5: {
                        if (column.getAverageValue() == null || column.getAverageValue().length() == 0) {
                            return new Double(Double.NaN);
                        }
                        return new Double(column.getAverageValue());
                    }
                    case 6: {
                        if (column.getMedianValue() == null || column.getMedianValue().length() == 0) {
                            return new Double(Double.NaN);
                        }
                        return new Double(column.getMedianValue());
                    }
                    case 7: {
                        if (column.getStandardDeviation() == null || column.getStandardDeviation().length() == 0) {
                            return new Double(Double.NaN);
                        }
                        return new Double(column.getStandardDeviation());
                    }
                    case 8: {
                        if (column.getVariance() == null || column.getVariance().length() == 0) {
                            return new Double(Double.NaN);
                        }
                        return new Double(column.getVariance());
                    }
                    case 9: {
                        if (column.getModalValue() == null) {
                            return "";
                        }
                        return column.getModalValue();
                    }
                }
                return null;
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                return null;
            }
        }
    }

    private class StatisticsAllTableModel
    extends AbstractTableModel {
        private StatisticsAllTableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = StatisticsDialog.class$("java.lang.Integer")) : class$java$lang$Integer;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Resource.getString("STATISTICS_TUPLES");
                }
                case 1: {
                    return Resource.getString("STATISTICS_COLUMNS");
                }
                case 2: {
                    return Resource.getString("STATISTICS_ORDINAL");
                }
                case 3: {
                    return Resource.getString("STATISTICS_NOMINAL");
                }
                case 4: {
                    return Resource.getString("STATISTICS_TIME");
                }
            }
            return ":-)";
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            return 1;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                switch (columnIndex) {
                    case 0: {
                        return new Integer(StatisticsDialog.this.columnset.getStatisticsAll());
                    }
                    case 1: {
                        return new Integer(StatisticsDialog.this.columnset.getColumns().size());
                    }
                    case 2: {
                        return new Integer(StatisticsDialog.this.columnset.getStatisticsOrdinal());
                    }
                    case 3: {
                        return new Integer(StatisticsDialog.this.columnset.getStatisticsNominal());
                    }
                    case 4: {
                        return new Integer(StatisticsDialog.this.columnset.getStatisticsTime());
                    }
                }
                return new Integer(0);
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                return new Integer(0);
            }
        }
    }
}

