/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.concepteditor.SpringUtilities;
import edu.udo.cs.miningmart.m4.ConceptualDatatypes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.musoft.limo.application.Resource;

public class NewBaseAttributesDialog
extends JDialog
implements ActionListener {
    public static final int CANCEL = 0;
    public static final int OK = 1;
    private int exitAction;
    private MiningMartApplication app;
    private JButton ok;
    private JButton cancel;
    private JComboBox att_type_box;
    private JComboBox data_type_box;
    private JTextField numberfield;
    private JTextField namefield;

    public NewBaseAttributesDialog(MiningMartApplication app) {
        super(app, Resource.getString("FEATURE_MULTINEWDIALOG_TITLE"), true);
        this.app = app;
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(400, 220);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout());
        this.getContentPane().add(toppanel);
        JLabel toplabel = new JLabel();
        toplabel.setText(Resource.getString("FEATURE_MULTINEWDIALOG_SUBTITLE"));
        Font opfont = new Font("SansSerif", 0, 15);
        toplabel.setFont(opfont);
        toplabel.setForeground(Color.BLUE);
        toplabel.setHorizontalAlignment(0);
        toplabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        toppanel.add((Component)toplabel, "North");
        JPanel midpanel = new JPanel();
        midpanel.setLayout(new SpringLayout());
        midpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        toppanel.add((Component)midpanel, "Center");
        JLabel label = new JLabel("Number:");
        this.numberfield = new JTextField("1");
        midpanel.add(label);
        midpanel.add(this.numberfield);
        label = new JLabel(Resource.getString("ATTR_NAME") + ":");
        this.namefield = new JTextField(Resource.getString("BASEATTRIBUTE"));
        midpanel.add(label);
        midpanel.add(this.namefield);
        label = new JLabel(Resource.getString("FEATURE_TYPE") + ":");
        Object[] types = new Object[]{"DB", "MINING"};
        this.att_type_box = new JComboBox<Object>(types);
        this.att_type_box.setSelectedIndex(0);
        midpanel.add(label);
        midpanel.add(this.att_type_box);
        label = new JLabel(Resource.getString("FEATURE_DATATYPE") + ":");
        Object[] cdtypes = new Object[ConceptualDatatypes.CDTYPES.length];
        for (int i = 0; i < cdtypes.length; ++i) {
            cdtypes[i] = ConceptualDatatypes.CDTYPES[i];
        }
        this.data_type_box = new JComboBox<Object>(cdtypes);
        this.data_type_box.setSelectedIndex(0);
        midpanel.add(label);
        midpanel.add(this.data_type_box);
        SpringUtilities.makeCompactGrid(midpanel, 4, 2, 6, 6, 6, 6);
        this.cancel = new JButton(Resource.getString("CANCEL"));
        this.ok = new JButton(Resource.getString("OK"));
        this.ok.setEnabled(true);
        this.cancel.addActionListener(this);
        this.ok.addActionListener(this);
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this.ok);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        bottom.add(this.cancel);
        bottom.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        toppanel.add((Component)bottom, "South");
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(Resource.getString("CANCEL"))) {
            this.exitAction = 0;
            this.dispose();
        } else if (cmd.equals(Resource.getString("OK"))) {
            this.exitAction = 1;
            this.dispose();
        }
    }

    public int getExitAction() {
        return this.exitAction;
    }

    public String getName() {
        return this.namefield.getText();
    }

    public int getNumberOfBaseAttributes() {
        try {
            return Integer.parseInt(this.numberfield.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getAttributeType() {
        return (String)this.att_type_box.getSelectedItem();
    }

    public String getConceptualDatatype() {
        return (String)this.data_type_box.getSelectedItem();
    }
}

