/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.ListSelectDialog;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import org.musoft.limo.application.Resource;

public class MCFeatureEditor
extends DefaultCellEditor
implements TableCellRenderer,
ItemListener,
ActionListener {
    private MiningMartApplication app;
    private Concept concept;
    private MultiColumnFeature mcfeature;
    private JComboBox box;
    private JButton button;

    public MCFeatureEditor(MiningMartApplication app, MultiColumnFeature mcfeature) {
        super(new JTextField());
        this.app = app;
        this.mcfeature = mcfeature;
        try {
            this.concept = mcfeature.getConcept();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        this.initComponents();
        this.setDataItems();
    }

    private void initComponents() {
        JPanel panel = new JPanel(new BorderLayout());
        this.editorComponent = panel;
        this.setClickCountToStart(1);
        this.box = new JComboBox();
        this.box.setBackground(Color.WHITE);
        this.box.setForeground(Color.BLACK);
        this.box.addItemListener(this);
        panel.add((Component)this.box, "Center");
        this.button = new JButton("...");
        this.button.addActionListener(this);
        if (this.app.getViewMode() == 0) {
            this.button.setEnabled(true);
        } else {
            this.button.setEnabled(false);
        }
        panel.add((Component)this.button, "East");
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.editorComponent;
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.box.getSelectedIndex() != 0 && this.box.getItemCount() > 0) {
            this.box.setSelectedIndex(0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        BaseAttribute ba;
        Collection bas = null;
        try {
            bas = this.concept.getAllBaseAttributes();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return;
        }
        Iterator iter = bas.iterator();
        String[] data = new String[bas.size()];
        int index = 0;
        while (iter.hasNext()) {
            ba = (BaseAttribute)iter.next();
            data[index] = ba.getName();
            ++index;
        }
        Collection selbas = null;
        try {
            selbas = this.mcfeature.getBaseAttributes();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return;
        }
        iter = selbas.iterator();
        String[] selected_data = new String[selbas.size()];
        index = 0;
        while (iter.hasNext()) {
            ba = (BaseAttribute)iter.next();
            selected_data[index] = ba.getName();
            ++index;
        }
        ListSelectDialog dialog = new ListSelectDialog(this.app, Resource.getString("FEATURE_DIALOG_TITLE"), Resource.getString("FEATURE_DIALOG_SUBTITLE"), data, selected_data, true, 2, Integer.MAX_VALUE);
        if (dialog.getExitAction() == 1) {
            selected_data = dialog.getSelectedDataItems();
            LinkedList<BaseAttribute> ba_list = new LinkedList<BaseAttribute>();
            for (int i = 0; i < selected_data.length; ++i) {
                try {
                    ba = this.concept.getBaseAttribute(selected_data[i]);
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                    continue;
                }
                ba_list.add(ba);
            }
            try {
                this.mcfeature.setBaseAttributes(ba_list);
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
            this.setDataItems();
        }
    }

    public void setDataItems() {
        this.box.removeAllItems();
        Collection bas = null;
        try {
            bas = this.mcfeature.getBaseAttributes();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return;
        }
        Iterator iter = bas.iterator();
        while (iter.hasNext()) {
            BaseAttribute ba = (BaseAttribute)iter.next();
            this.box.addItem(ba.getName());
        }
    }
}

