/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.concepteditor.MCFeatureEditor;
import edu.udo.cs.miningmart.gui.concepteditor.NewBaseAttributesDialog;
import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.gui.util.M4ObjectComparator;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.ConceptualDatatypes;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelDrawingView;

public class FeatureTable
extends JTable {
    public static final int BASEATTRIBUTE_MODE = 0;
    public static final int MCFEATURE_MODE = 1;
    public static final int DEFAULT_MODE = 0;
    private MiningMartApplication app;
    private MiningMartConcept mmartconcept;
    private Concept concept;
    private int feature_mode;
    private Vector features;
    private Vector mcfeateditor;
    private FeatureTableModel tablemodel;
    private Feature selectedFeature;
    private JTextArea descriptionArea;
    private int viewMode;
    private boolean listenDescription;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$BaseAttribute;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$MultiColumnFeature;
    static /* synthetic */ Class class$java$lang$String;

    public FeatureTable(MiningMartApplication app, MiningMartConcept mmartconcept, int feature_mode) {
        this.app = app;
        this.viewMode = app.getViewMode();
        this.mmartconcept = mmartconcept;
        this.concept = mmartconcept.getConcept();
        if (feature_mode < 0 || feature_mode > 1) {
            feature_mode = 0;
        }
        this.feature_mode = feature_mode;
        this.selectedFeature = null;
        this.listenDescription = false;
        this.descriptionArea = new JTextArea();
        this.descriptionArea.setEditable(false);
        this.descriptionArea.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.setDocu();
            }

            public void removeUpdate(DocumentEvent e) {
                this.setDocu();
            }

            private void setDocu() {
                if (!FeatureTable.this.listenDescription) {
                    return;
                }
                int selectedRow = FeatureTable.this.getSelectedRow();
                if (selectedRow == -1) {
                    return;
                }
                try {
                    ((Feature)FeatureTable.this.features.get(selectedRow)).setDocumentation(FeatureTable.this.descriptionArea.getText());
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.features = new Vector();
        try {
            Collection fcoll = this.concept.getFeatures();
            LinkedList flist = new LinkedList();
            flist.addAll(fcoll);
            Collections.sort(flist, new M4ObjectComparator());
            Iterator iter = flist.iterator();
            while (iter.hasNext()) {
                Feature feat = (Feature)iter.next();
                if (feat instanceof BaseAttribute && feature_mode == 0) {
                    this.features.add(feat);
                    continue;
                }
                if (!(feat instanceof MultiColumnFeature) || feature_mode != 1) continue;
                this.features.add(feat);
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        this.setSelectionMode(2);
        ListSelectionModel rowSM = this.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    FeatureTable.this.listenDescription = false;
                    FeatureTable.this.descriptionArea.setText("");
                    FeatureTable.this.descriptionArea.setEditable(false);
                } else {
                    if (FeatureTable.this.viewMode == 0) {
                        FeatureTable.this.descriptionArea.setEditable(true);
                    } else {
                        FeatureTable.this.descriptionArea.setEditable(false);
                    }
                    int selectedRow = lsm.getMinSelectionIndex();
                    Feature feat = (Feature)FeatureTable.this.features.get(selectedRow);
                    String doc = new String("");
                    try {
                        doc = feat.getDocumentation();
                    }
                    catch (M4Exception error) {
                        M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                        doc = "";
                    }
                    FeatureTable.this.listenDescription = false;
                    FeatureTable.this.descriptionArea.setText(doc);
                    FeatureTable.this.listenDescription = true;
                }
            }
        });
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowHeight(this.getRowHeight() + 4);
        this.tablemodel = new FeatureTableModel();
        this.setModel(this.tablemodel);
        this.createEditorAndRenderer();
    }

    public JTextArea getDescriptionArea() {
        return this.descriptionArea;
    }

    public void newFeature() {
        int row = this.getSelectedRow();
        try {
            Feature feat = null;
            if (this.feature_mode == 0) {
                feat = this.concept.createBaseAttribute(this.concept.getValidName(Resource.getString("BASEATTRIBUTE"), class$edu$udo$cs$miningmart$m4$BaseAttribute == null ? (class$edu$udo$cs$miningmart$m4$BaseAttribute = FeatureTable.class$("edu.udo.cs.miningmart.m4.BaseAttribute")) : class$edu$udo$cs$miningmart$m4$BaseAttribute), "DB", ConceptualDatatypes.CDTYPES[0]);
                feat.setType("DB");
                ((BaseAttribute)feat).setConceptualDataTypeName(ConceptualDatatypes.CDTYPES[0]);
            }
            if (this.feature_mode == 1) {
                feat = this.concept.createMultiColumnFeature(this.concept.getValidName(Resource.getString("MCFEATURE"), class$edu$udo$cs$miningmart$m4$MultiColumnFeature == null ? (class$edu$udo$cs$miningmart$m4$MultiColumnFeature = FeatureTable.class$("edu.udo.cs.miningmart.m4.MultiColumnFeature")) : class$edu$udo$cs$miningmart$m4$MultiColumnFeature));
            }
            if (this.feature_mode == 1) {
                MCFeatureEditor editor = new MCFeatureEditor(this.app, (MultiColumnFeature)feat);
                editor.actionPerformed(null);
                if (((MultiColumnFeature)feat).getBaseAttributes().size() < 2) {
                    this.concept.removeFeature(feat);
                    feat.deleteSoon();
                    return;
                }
                this.mcfeateditor.add(editor);
            }
            this.features.add(feat);
            this.app.getModel().setDirty(true);
            this.tablemodel.fireTableDataChanged();
            ((ModelDrawingView)this.app.getDrawingView()).repaint();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public void newBaseAttributes() {
        NewBaseAttributesDialog dialog = new NewBaseAttributesDialog(this.app);
        if (dialog.getExitAction() == 1) {
            try {
                String name = dialog.getName();
                int nr = dialog.getNumberOfBaseAttributes();
                String atttype = dialog.getAttributeType();
                String datatype = dialog.getConceptualDatatype();
                for (int b = 0; b < nr; ++b) {
                    String thename = this.concept.getValidName(name, class$edu$udo$cs$miningmart$m4$BaseAttribute == null ? FeatureTable.class$("edu.udo.cs.miningmart.m4.BaseAttribute") : class$edu$udo$cs$miningmart$m4$BaseAttribute);
                    BaseAttribute newBA = this.concept.createBaseAttribute(thename, atttype, datatype);
                    newBA.setType(atttype);
                    newBA.setConceptualDataTypeName(datatype);
                    this.features.add(newBA);
                }
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
            this.app.getModel().setDirty(true);
            this.tablemodel.fireTableDataChanged();
            ((ModelDrawingView)this.app.getDrawingView()).repaint();
        }
    }

    public void deleteSelectedFeature() {
        int[] row = this.getSelectedRows();
        for (int r = row.length - 1; r >= 0; --r) {
            if (row[r] == -1) continue;
            Feature feat = (Feature)this.features.get(row[r]);
            try {
                this.concept.removeFeature(feat);
                feat.deleteSoon();
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                continue;
            }
            this.features.remove(row[r]);
            if (this.feature_mode != 1) continue;
            this.mcfeateditor.remove(row[r]);
        }
        this.app.getModel().setDirty(true);
        this.tablemodel.fireTableDataChanged();
        ((ModelDrawingView)this.app.getDrawingView()).repaint();
    }

    public void createEditorAndRenderer() {
        this.mcfeateditor = new Vector();
        for (int i = 0; i < this.features.size(); ++i) {
            Feature feat = (Feature)this.features.get(i);
            if (this.feature_mode == 0) {
                // empty if block
            }
            if (this.feature_mode != 1) continue;
            this.mcfeateditor.add(new MCFeatureEditor(this.app, (MultiColumnFeature)feat));
        }
        if (this.feature_mode == 0) {
            TableColumn tablecolumn = this.getColumnModel().getColumn(1);
            String[] types = new String[]{"DB", "MINING"};
            JComboBox<Object> comboBox = new JComboBox<Object>((Object[])types);
            tablecolumn.setCellEditor(new DefaultCellEditor(comboBox));
            tablecolumn = this.getColumnModel().getColumn(2);
            String[] cdtypes = new String[ConceptualDatatypes.CDTYPES.length];
            for (int i = 0; i < cdtypes.length; ++i) {
                cdtypes[i] = ConceptualDatatypes.CDTYPES[i];
            }
            comboBox = new JComboBox<Object>((Object[])cdtypes);
            tablecolumn.setCellEditor(new DefaultCellEditor(comboBox));
        }
    }

    public TableCellEditor getCellEditor(int row, int column) {
        if (row >= this.features.size()) {
            return super.getCellEditor(row, column);
        }
        if (column == 0) {
            return super.getCellEditor(row, column);
        }
        if (column == 1) {
            if (this.feature_mode == 0) {
                return super.getCellEditor(row, column);
            }
            return (TableCellEditor)this.mcfeateditor.get(row);
        }
        if (column == 2) {
            return super.getCellEditor(row, column);
        }
        return null;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (row >= this.features.size()) {
            return super.getCellRenderer(row, column);
        }
        if (column == 0) {
            return super.getCellRenderer(row, column);
        }
        if (column == 1) {
            if (this.feature_mode == 0) {
                return super.getCellRenderer(row, column);
            }
            return (TableCellRenderer)this.mcfeateditor.get(row);
        }
        if (column == 2) {
            return super.getCellRenderer(row, column);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FeatureTableModel
    extends AbstractTableModel {
        public Class getColumnClass(int columnIndex) {
            if (FeatureTable.this.feature_mode == 0) {
                return class$java$lang$String == null ? (class$java$lang$String = FeatureTable.class$("java.lang.String")) : class$java$lang$String;
            }
            if (FeatureTable.this.feature_mode == 1) {
                if (columnIndex == 0) {
                    return class$java$lang$String == null ? (class$java$lang$String = FeatureTable.class$("java.lang.String")) : class$java$lang$String;
                }
                if (columnIndex == 1) {
                    return super.getColumnClass(columnIndex);
                }
            }
            return super.getColumnClass(columnIndex);
        }

        public int getColumnCount() {
            if (FeatureTable.this.feature_mode == 0) {
                return 3;
            }
            if (FeatureTable.this.feature_mode == 1) {
                return 2;
            }
            return 1;
        }

        public int getRowCount() {
            return FeatureTable.this.features.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Feature feat = (Feature)FeatureTable.this.features.get(rowIndex);
            try {
                if (columnIndex == 0) {
                    return feat.getName();
                }
                if (columnIndex == 1) {
                    if (feat instanceof BaseAttribute) {
                        return ((BaseAttribute)feat).getType();
                    }
                    if (feat instanceof MultiColumnFeature) {
                        return ((MultiColumnFeature)feat).getBaseAttributes();
                    }
                }
                if (columnIndex == 2 && feat instanceof BaseAttribute) {
                    return ((BaseAttribute)feat).getConceptualDataTypeName();
                }
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
            return "";
        }

        public String getColumnName(int column) {
            if (FeatureTable.this.feature_mode == 0) {
                if (column == 0) {
                    return Resource.getString("ATTR_NAME");
                }
                if (column == 1) {
                    return Resource.getString("FEATURE_TYPE");
                }
                if (column == 2) {
                    return Resource.getString("FEATURE_DATATYPE");
                }
            }
            if (FeatureTable.this.feature_mode == 1) {
                if (column == 0) {
                    return Resource.getString("ATTR_NAME");
                }
                if (column == 1) {
                    return Resource.getString("BASEATTRIBUTES");
                }
            }
            return ":-)";
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (FeatureTable.this.app.getViewMode() == 0) {
                return true;
            }
            return FeatureTable.this.feature_mode == 1 && columnIndex == 1;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (FeatureTable.this.app.getViewMode() == 0) {
                Feature feat = (Feature)FeatureTable.this.features.get(rowIndex);
                try {
                    if (columnIndex == 0) {
                        feat.setName((String)aValue);
                    }
                    if (columnIndex == 1) {
                        if (feat instanceof BaseAttribute) {
                            ((BaseAttribute)feat).setType((String)aValue);
                        }
                        if (feat instanceof MultiColumnFeature) {
                            // empty if block
                        }
                    }
                    if (columnIndex == 2 && feat instanceof BaseAttribute) {
                        ((BaseAttribute)feat).setConceptualDataTypeName((String)aValue);
                    }
                    FeatureTable.this.app.getModel().setDirty(true);
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
            }
        }
    }
}

