/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.concepteditor.ConceptPanel;
import edu.udo.cs.miningmart.gui.concepteditor.FeatureTable;
import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.m4.Concept;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import org.musoft.limo.application.Resource;

public class FeaturePanel
extends ConceptPanel
implements ActionListener {
    private MiningMartApplication app;
    private MiningMartConcept mmartconcept;
    private JButton multinewBA;
    private JButton newBA;
    private JButton deleteBA;
    private JButton closeButton;
    private FeatureTable featuretable;
    private boolean baseattributes;

    public FeaturePanel(MiningMartApplication app, MiningMartConcept mmartconcept, boolean baseattributes) {
        this.app = app;
        this.mmartconcept = mmartconcept;
        this.baseattributes = baseattributes;
        this.initComponents();
    }

    private void initComponents() {
        Border emptyborder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(emptyborder);
        JPanel buttonpanel = new JPanel();
        buttonpanel.setLayout(new BoxLayout(buttonpanel, 0));
        buttonpanel.add(Box.createHorizontalGlue());
        this.newBA = new JButton(Resource.getString("FEATURE_NEW"));
        this.newBA.addActionListener(this);
        this.multinewBA = new JButton(Resource.getString("FEATURE_MULTINEW"));
        this.multinewBA.addActionListener(this);
        this.deleteBA = new JButton(Resource.getString("DELETE"));
        this.deleteBA.addActionListener(this);
        if (this.app.getViewMode() == 1) {
            this.newBA.setEnabled(false);
            this.multinewBA.setEnabled(false);
            this.deleteBA.setEnabled(false);
        }
        this.closeButton = new JButton(Resource.getString("CLOSE"));
        this.closeButton.addActionListener(this);
        buttonpanel.add(this.newBA);
        buttonpanel.add(Box.createRigidArea(new Dimension(5, 0)));
        if (this.baseattributes) {
            buttonpanel.add(this.multinewBA);
            buttonpanel.add(Box.createRigidArea(new Dimension(5, 0)));
        }
        buttonpanel.add(this.deleteBA);
        buttonpanel.add(Box.createRigidArea(new Dimension(15, 0)));
        buttonpanel.add(this.closeButton);
        this.add((Component)buttonpanel, "South");
        JLabel toplabel = new JLabel();
        if (this.baseattributes) {
            toplabel.setText(this.mmartconcept.getName() + " - " + Resource.getString("BASEATTRIBUTE"));
        } else {
            toplabel.setText(this.mmartconcept.getName() + " - " + Resource.getString("MCFEATURE"));
        }
        Font opfont = new Font("SansSerif", 0, 15);
        toplabel.setFont(opfont);
        toplabel.setForeground(Color.BLUE);
        toplabel.setHorizontalAlignment(0);
        this.add((Component)toplabel, "North");
        toplabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.featuretable = this.baseattributes ? new FeatureTable(this.app, this.mmartconcept, 0) : new FeatureTable(this.app, this.mmartconcept, 1);
        JPanel descpanel = new JPanel();
        descpanel.setLayout(new BorderLayout(5, 5));
        JLabel desclabel = new JLabel(Resource.getString("COMP_NOTEPAD"));
        desclabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        descpanel.add((Component)desclabel, "North");
        descpanel.add((Component)new JScrollPane(this.featuretable.getDescriptionArea()), "Center");
        descpanel.setBorder(emptyborder);
        JSplitPane splitpane = new JSplitPane(0, new JScrollPane(this.featuretable), descpanel);
        splitpane.setOneTouchExpandable(true);
        splitpane.setResizeWeight(0.5);
        splitpane.setDividerLocation(splitpane.getSize().width - splitpane.getInsets().bottom - splitpane.getDividerSize() - 150);
        this.add((Component)splitpane, "Center");
    }

    public Concept getConcept() {
        return this.mmartconcept.getConcept();
    }

    public void actionPerformed(ActionEvent event) {
        if (!(event.getSource() instanceof JButton)) {
            return;
        }
        JButton source = (JButton)event.getSource();
        if (source.getText().equals(this.closeButton.getText())) {
            this.app.removeComponentFromTab(this);
        }
        if (source.getText().equals(this.newBA.getText())) {
            this.featuretable.newFeature();
        }
        if (source.getText().equals(this.multinewBA.getText())) {
            this.featuretable.newBaseAttributes();
        }
        if (source.getText().equals(this.deleteBA.getText())) {
            this.featuretable.deleteSelectedFeature();
        }
    }

    public String toString() {
        if (this.baseattributes) {
            return Resource.getString("BASEATTRIBUTES");
        }
        return Resource.getString("MCFEATURES");
    }
}

