/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.util.M4ObjectComparator;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.EstimatedStatistics;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.musoft.limo.application.Resource;

public class EstimatedStatisticsDialog
extends JDialog
implements ActionListener {
    private Vector baseAttributes;
    private EstimatedStatistics myEstStat;
    private String conceptName;
    private JButton closeButton;
    private JTable statalltable;
    private JTable stat1table;
    private JTable stat2table;
    static /* synthetic */ Class class$java$lang$String;

    public EstimatedStatisticsDialog(MiningMartApplication app, Concept theConcept) {
        super((Frame)app, true);
        try {
            this.conceptName = theConcept.getName();
            this.myEstStat = theConcept.getEstimatedStatistics();
            this.baseAttributes = new Vector();
            this.baseAttributes.addAll(theConcept.getAllBaseAttributes());
            Collections.sort(this.baseAttributes, new M4ObjectComparator());
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(750, 600);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout(5, 5));
        toppanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(toppanel);
        JPanel infopanel = new JPanel();
        infopanel.setLayout(new GridLayout(2, 1, 5, 5));
        infopanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        toppanel.add((Component)infopanel, "North");
        JLabel label = new JLabel();
        label.setText(Resource.getString("ESTIMATES"));
        Font font = new Font("SansSerif", 1, 15);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        infopanel.add(label);
        label = new JLabel();
        label.setText(this.conceptName);
        font = new Font("SansSerif", 0, 13);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        label.setForeground(Color.BLUE);
        infopanel.add(label);
        this.closeButton = new JButton(Resource.getString("CLOSE"));
        this.closeButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPanel.add(this.closeButton);
        toppanel.add((Component)buttonPanel, "South");
        JPanel midpanel = new JPanel();
        midpanel.setLayout(new BorderLayout(5, 5));
        toppanel.add((Component)midpanel, "Center");
        this.statalltable = new JTable();
        this.statalltable.setSelectionMode(2);
        this.statalltable.getTableHeader().setReorderingAllowed(false);
        this.statalltable.setRowHeight(this.statalltable.getRowHeight() + 2);
        this.statalltable.setModel(new StatisticsAllTableModel());
        JScrollPane scrollpane = new JScrollPane(this.statalltable);
        scrollpane.setPreferredSize(new Dimension(scrollpane.getWidth(), 36));
        midpanel.add((Component)scrollpane, "North");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridLayout(2, 1, 5, 5));
        midpanel.add((Component)centerPanel, "Center");
        JPanel stat1panel = new JPanel();
        stat1panel.setLayout(new BorderLayout(5, 5));
        centerPanel.add(stat1panel);
        label = new JLabel();
        label.setText(Resource.getString("ESTIMATED_ATTRIBDATA"));
        font = new Font("SansSerif", 1, 12);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        stat1panel.add((Component)label, "North");
        this.stat1table = new JTable();
        this.stat1table.setSelectionMode(2);
        this.stat1table.getTableHeader().setReorderingAllowed(false);
        this.stat1table.setRowHeight(this.stat1table.getRowHeight() + 2);
        this.stat1table.setModel(new Statistics1TableModel());
        stat1panel.add((Component)new JScrollPane(this.stat1table), "Center");
        JPanel stat2panel = new JPanel();
        stat2panel.setLayout(new BorderLayout(5, 5));
        centerPanel.add(stat2panel);
        label = new JLabel();
        label.setText(Resource.getString("ESTIMATED_DISTRIBUTION"));
        font = new Font("SansSerif", 1, 12);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        stat2panel.add((Component)label, "North");
        this.stat2table = new JTable();
        this.stat2table.setSelectionMode(2);
        this.stat2table.getTableHeader().setReorderingAllowed(false);
        this.stat2table.setRowHeight(this.stat2table.getRowHeight() + 2);
        this.stat2table.setModel(new Statistics2TableModel());
        stat2panel.add((Component)new JScrollPane(this.stat2table), "Center");
    }

    public void actionPerformed(ActionEvent event) {
        if (!(event.getSource() instanceof JButton)) {
            return;
        }
        JButton source = (JButton)event.getSource();
        if (source.getText().equals(this.closeButton.getText())) {
            this.dispose();
        }
    }

    private String getEstimatedValue(int value) {
        if (value == Integer.MIN_VALUE) {
            return Resource.getString("ESTIMATE_UNKNOWN");
        }
        return new Integer(value).toString();
    }

    private String getEstimatedValue(double value) {
        if (new Double(value).equals(new Double(Double.NaN))) {
            return Resource.getString("ESTIMATE_UNKNOWN");
        }
        return new Double(value).toString();
    }

    private String getEstimatedValue(String value) {
        if (value == null || value.equals("<unknown>")) {
            return Resource.getString("ESTIMATE_UNKNOWN");
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Statistics2TableModel
    extends AbstractTableModel {
        private String[] attribNames;
        private String[] values;

        public Statistics2TableModel() {
            this.initNameArrays();
        }

        public void initNameArrays() {
            Vector<String> attrNames = new Vector<String>();
            Vector<String> attrValues = new Vector<String>();
            Iterator attrIt = EstimatedStatisticsDialog.this.baseAttributes.iterator();
            while (attrIt.hasNext()) {
                BaseAttribute myBa = (BaseAttribute)attrIt.next();
                String name = myBa.getName();
                Vector vals = EstimatedStatisticsDialog.this.myEstStat.getValueList(name);
                Iterator valIt = vals.iterator();
                while (valIt.hasNext()) {
                    String value = (String)valIt.next();
                    attrNames.add(name);
                    attrValues.add(value);
                }
            }
            this.attribNames = new String[attrNames.size()];
            this.values = new String[attrValues.size()];
            if (this.attribNames.length != this.values.length) {
                System.err.println("Error reading estimated statistics!");
                return;
            }
            for (int i = 0; i < this.attribNames.length; ++i) {
                this.attribNames[i] = (String)attrNames.get(i);
                this.values[i] = (String)attrValues.get(i);
            }
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$String == null ? (class$java$lang$String = EstimatedStatisticsDialog.class$("java.lang.String")) : class$java$lang$String;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Resource.getString("ESTIMATED_ATTRIBNAME");
                }
                case 1: {
                    return Resource.getString("ESTIMATED_VALUE");
                }
                case 2: {
                    return Resource.getString("ESTIMATED_OCCUR");
                }
            }
            return ":-)";
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return this.attribNames.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.attribNames[rowIndex];
                }
                case 1: {
                    return this.values[rowIndex];
                }
                case 2: {
                    return EstimatedStatisticsDialog.this.getEstimatedValue(EstimatedStatisticsDialog.this.myEstStat.getNumberOfOccurrences(this.attribNames[rowIndex], this.values[rowIndex]));
                }
            }
            return ":-)";
        }
    }

    private class Statistics1TableModel
    extends AbstractTableModel {
        private Statistics1TableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$String == null ? (class$java$lang$String = EstimatedStatisticsDialog.class$("java.lang.String")) : class$java$lang$String;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Resource.getString("ESTIMATED_ATTRIBNAME");
                }
                case 1: {
                    return Resource.getString("ESTIMATED_MIN");
                }
                case 2: {
                    return Resource.getString("ESTIMATED_MAX");
                }
                case 3: {
                    return Resource.getString("ESTIMATED_MISSING");
                }
            }
            return ":-)";
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return EstimatedStatisticsDialog.this.baseAttributes.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            BaseAttribute ba = (BaseAttribute)EstimatedStatisticsDialog.this.baseAttributes.get(rowIndex);
            String attrName = ba.getName();
            switch (columnIndex) {
                case 0: {
                    return attrName;
                }
                case 1: {
                    return EstimatedStatisticsDialog.this.getEstimatedValue(EstimatedStatisticsDialog.this.myEstStat.getLowestValue(attrName));
                }
                case 2: {
                    return EstimatedStatisticsDialog.this.getEstimatedValue(EstimatedStatisticsDialog.this.myEstStat.getBiggestValue(attrName));
                }
                case 3: {
                    return EstimatedStatisticsDialog.this.getEstimatedValue(EstimatedStatisticsDialog.this.myEstStat.getNumberOfMissingValues(attrName));
                }
            }
            return Resource.getString("ESTIMATE_UNKNOWN");
        }
    }

    private class StatisticsAllTableModel
    extends AbstractTableModel {
        private StatisticsAllTableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$String == null ? (class$java$lang$String = EstimatedStatisticsDialog.class$("java.lang.String")) : class$java$lang$String;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Resource.getString("ESTIMATED_ROWCOUNT");
                }
            }
            return ":-)";
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return 1;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return EstimatedStatisticsDialog.this.getEstimatedValue(EstimatedStatisticsDialog.this.myEstStat.getNumberOfRows());
                }
            }
            return Resource.getString("ESTIMATE_UNKNOWN");
        }
    }
}

