/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.concepteditor.SpringUtilities;
import edu.udo.cs.miningmart.gui.stepsettings.ListSelectDialog;
import edu.udo.cs.miningmart.gui.util.M4ObjectComparator;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.musoft.limo.application.Resource;

public class DataDialog
extends JDialog
implements ActionListener,
ItemListener {
    private MiningMartApplication app;
    private Columnset columnset;
    private Vector columns;
    private Vector selectedcolumns;
    private Vector sortcolumns;
    private JButton closeButton;
    private JButton updateButton;
    private JButton selectButton;
    private JButton nextButton;
    private JButton sortButton;
    private JTextField startrowField;
    private JTextField endrowField;
    private JList columnlist;
    private JList sortlist;
    private JTable datatable;
    private int nr_cols;
    private int nr_rows;
    private Object[][] data;
    private ResultSetMetaData metadata;
    private int startRow;
    private JComboBox sortBox;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;

    public DataDialog(MiningMartApplication app, Columnset columnset) {
        super((Frame)app, true);
        this.app = app;
        this.columnset = columnset;
        try {
            this.columns = new Vector();
            this.selectedcolumns = new Vector();
            this.sortcolumns = new Vector();
            this.columns.addAll(columnset.getColumns());
            this.selectedcolumns.addAll(columnset.getColumns());
            Collections.sort(this.columns, new M4ObjectComparator());
            Collections.sort(this.selectedcolumns, new M4ObjectComparator());
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(800, 600);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout(5, 5));
        toppanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(toppanel);
        JPanel infopanel = new JPanel();
        infopanel.setLayout(new GridLayout(2, 1, 5, 5));
        infopanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        toppanel.add((Component)infopanel, "North");
        JLabel label = new JLabel();
        label.setText(Resource.getString("COLUMNSET") + " - " + Resource.getString("DATA"));
        Font font = new Font("SansSerif", 1, 15);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        infopanel.add(label);
        label = new JLabel();
        label.setText(this.columnset.getName());
        font = new Font("SansSerif", 0, 13);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        label.setForeground(Color.BLUE);
        infopanel.add(label);
        this.sortButton = new JButton(Resource.getString("DATA_SORT"));
        this.sortButton.addActionListener(this);
        this.nextButton = new JButton(Resource.getString("NEXT"));
        this.nextButton.addActionListener(this);
        this.updateButton = new JButton(Resource.getString("UPDATE"));
        this.updateButton.addActionListener(this);
        this.updateButton.setEnabled(false);
        this.closeButton = new JButton(Resource.getString("CLOSE"));
        this.closeButton.addActionListener(this);
        JPanel centerpanel = new JPanel();
        centerpanel.setLayout(new BorderLayout(5, 5));
        toppanel.add((Component)centerpanel, "Center");
        this.startrowField = new JTextField(Resource.getString("DATA_FIRSTROW_NR"));
        this.endrowField = new JTextField(Resource.getString("DATA_LASTROW_NR"));
        this.initData();
        this.datatable = new JTable(){

            public TableCellRenderer getCellRenderer(int row, int column) {
                return new DataRenderer();
            }
        };
        this.datatable.setModel(new DataModel());
        this.datatable.setSelectionMode(2);
        this.datatable.getTableHeader().setReorderingAllowed(false);
        this.datatable.setRowHeight(this.datatable.getRowHeight() + 2);
        TableColumnModel cmodel = this.datatable.getColumnModel();
        for (int i = 0; i < cmodel.getColumnCount(); ++i) {
            cmodel.getColumn(i).setMinWidth(10);
            cmodel.getColumn(i).setMaxWidth(Integer.MAX_VALUE);
        }
        this.datatable.setAutoResizeMode(0);
        centerpanel.add((Component)new JScrollPane(this.datatable), "Center");
        JPanel updatePanel = new JPanel();
        updatePanel.setLayout(new BorderLayout(5, 5));
        centerpanel.add((Component)updatePanel, "East");
        JPanel buttonPanel1 = new JPanel();
        buttonPanel1.setLayout(new BoxLayout(buttonPanel1, 0));
        buttonPanel1.add(Box.createHorizontalGlue());
        buttonPanel1.add(this.closeButton);
        updatePanel.add((Component)buttonPanel1, "South");
        updatePanel.setPreferredSize(new Dimension(180, updatePanel.getHeight()));
        JPanel updatePanel2 = new JPanel();
        updatePanel2.setLayout(new GridLayout(3, 1, 25, 25));
        updatePanel.add((Component)updatePanel2, "Center");
        JPanel columnPanel = new JPanel();
        columnPanel.setLayout(new BorderLayout(5, 5));
        updatePanel2.add(columnPanel);
        this.selectButton = new JButton(Resource.getString("DATA_SELECT"));
        this.selectButton.addActionListener(this);
        JPanel buttonPanel3 = new JPanel();
        buttonPanel3.setLayout(new BoxLayout(buttonPanel3, 0));
        buttonPanel3.add(Box.createHorizontalGlue());
        buttonPanel3.add(this.selectButton);
        columnPanel.add((Component)buttonPanel3, "South");
        this.columnlist = new JList(new ColumnListModel());
        this.columnlist.setVisibleRowCount(10);
        columnPanel.add((Component)new JScrollPane(this.columnlist), "Center");
        label = new JLabel(Resource.getString("COLUMNS") + ":");
        columnPanel.add((Component)label, "North");
        JPanel sortPanel = new JPanel();
        sortPanel.setLayout(new BorderLayout(5, 5));
        updatePanel2.add(sortPanel);
        label = new JLabel(Resource.getString("DATA_SORT_BY"));
        sortPanel.add((Component)label, "North");
        JPanel buttonPanel4 = new JPanel();
        this.sortlist = new JList(new SortListModel());
        this.sortlist.setVisibleRowCount(5);
        sortPanel.add((Component)new JScrollPane(this.sortlist), "Center");
        buttonPanel4.setLayout(new BoxLayout(buttonPanel4, 0));
        buttonPanel4.add(Box.createHorizontalGlue());
        buttonPanel4.add(this.sortButton);
        Object[] sortvalues = new Object[]{Resource.getString("DATA_SORT_ASC"), Resource.getString("DATA-SORT_DESC")};
        this.sortBox = new JComboBox<Object>(sortvalues);
        this.sortBox.addItemListener(this);
        JPanel sortPanel2 = new JPanel();
        sortPanel2.setLayout(new GridLayout(2, 1, 5, 5));
        sortPanel2.add(this.sortBox);
        sortPanel2.add(buttonPanel4);
        sortPanel.add((Component)sortPanel2, "South");
        JPanel rowPanel = new JPanel();
        rowPanel.setLayout(new SpringLayout());
        label = new JLabel(Resource.getString("DATA_FIRSTROW"));
        rowPanel.add(label);
        rowPanel.add(this.startrowField);
        label = new JLabel(Resource.getString("DATA_LASTROW"));
        rowPanel.add(label);
        rowPanel.add(this.endrowField);
        SpringUtilities.makeCompactGrid(rowPanel, 2, 2, 6, 6, 6, 6);
        this.startrowField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                DataDialog.this.updateButton.setEnabled(true);
            }

            public void insertUpdate(DocumentEvent e) {
                DataDialog.this.updateButton.setEnabled(true);
            }

            public void removeUpdate(DocumentEvent e) {
                DataDialog.this.updateButton.setEnabled(true);
            }
        });
        this.endrowField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                DataDialog.this.updateButton.setEnabled(true);
            }

            public void insertUpdate(DocumentEvent e) {
                DataDialog.this.updateButton.setEnabled(true);
            }

            public void removeUpdate(DocumentEvent e) {
                DataDialog.this.updateButton.setEnabled(true);
            }
        });
        JPanel rowPanel2 = new JPanel();
        rowPanel2.setLayout(new BorderLayout(5, 5));
        rowPanel2.add((Component)rowPanel, "North");
        updatePanel2.add(rowPanel2);
        JPanel rowPanel3 = new JPanel();
        rowPanel3.setLayout(new BorderLayout(5, 5));
        rowPanel2.add((Component)rowPanel3, "Center");
        JPanel buttonPanel2 = new JPanel();
        buttonPanel2.setLayout(new BoxLayout(buttonPanel2, 0));
        buttonPanel2.add(Box.createHorizontalGlue());
        buttonPanel2.add(this.nextButton);
        buttonPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPanel2.add(this.updateButton);
        rowPanel3.add((Component)buttonPanel2, "North");
    }

    private void sortColumns() {
        String[] data = new String[this.selectedcolumns.size()];
        for (int i = 0; i < this.selectedcolumns.size(); ++i) {
            data[i] = ((Column)this.selectedcolumns.get(i)).getName();
        }
        String[] selected_data = new String[this.sortcolumns.size()];
        for (int i = 0; i < this.sortcolumns.size(); ++i) {
            selected_data[i] = ((Column)this.sortcolumns.get(i)).getName();
        }
        ListSelectDialog dialog = new ListSelectDialog(this.app, Resource.getString("DATA_SORTDIALOG_TITLE"), Resource.getString("DATA_SORTDIALOG_SUBTITLE"), data, selected_data, true, 0, Integer.MAX_VALUE);
        if (dialog.getExitAction() == 1) {
            selected_data = dialog.getSelectedDataItems();
            this.sortcolumns = new Vector();
            for (int i = 0; i < selected_data.length; ++i) {
                try {
                    Column column = this.columnset.getColumn(selected_data[i]);
                    this.sortcolumns.add(column);
                    continue;
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
            }
            this.sortlist.setModel(new SortListModel());
            this.updateButton.setEnabled(true);
            this.updateDataView();
        }
    }

    private void nextDataView() {
        int startrow = 0;
        int endrow = 0;
        try {
            startrow = Integer.parseInt(this.startrowField.getText());
            endrow = Integer.parseInt(this.endrowField.getText());
        }
        catch (NumberFormatException error) {
            startrow = 0;
            endrow = 0;
        }
        startrow = Math.max(1, startrow);
        endrow = Math.max(1, endrow);
        startrow = Math.min(startrow, endrow);
        this.nr_rows = endrow - startrow + 1;
        startrow += this.nr_rows;
        endrow += this.nr_rows;
        try {
            startrow = Math.min(startrow, this.columnset.getStatisticsAll());
            endrow = Math.min(endrow, this.columnset.getStatisticsAll());
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return;
        }
        this.startRow = startrow;
        this.startrowField.setText(Integer.toString(startrow));
        this.endrowField.setText(Integer.toString(endrow));
        this.updateDataView();
    }

    private boolean initData() {
        Column column;
        int startrow = 0;
        int endrow = 0;
        try {
            startrow = Integer.parseInt(this.startrowField.getText());
            endrow = Integer.parseInt(this.endrowField.getText());
        }
        catch (NumberFormatException error) {
            startrow = 0;
            endrow = 0;
        }
        startrow = Math.max(1, startrow);
        endrow = Math.max(1, endrow);
        startrow = Math.min(startrow, endrow);
        try {
            startrow = Math.min(startrow, this.columnset.getStatisticsAll());
            endrow = Math.min(endrow, this.columnset.getStatisticsAll());
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return false;
        }
        this.startRow = startrow;
        this.startrowField.setText(Integer.toString(startrow));
        this.endrowField.setText(Integer.toString(endrow));
        this.nr_cols = this.selectedcolumns.size();
        this.nr_rows = endrow - startrow + 1;
        if (this.nr_rows == 0 || this.nr_cols == 0) {
            return false;
        }
        short dbms = 0;
        try {
            dbms = M4Interface.getInstance().getM4db().getBusinessDbms();
        }
        catch (DbConnectionClosed error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return false;
        }
        StringBuffer sbuf = new StringBuffer("SELECT ");
        for (int i = 0; i < this.nr_cols; ++i) {
            if (i != 0) {
                sbuf.append(", ");
            }
            column = (Column)this.selectedcolumns.get(i);
            String sqlDef = column.getSQLDefinition();
            String colName = column.getName();
            sbuf.append(sqlDef);
            if (sqlDef.equals(colName)) continue;
            sbuf.append(" AS " + colName);
        }
        String sql = null;
        sql = sbuf.toString() + " FROM " + this.columnset.getSchemaPlusName();
        if (this.sortcolumns.size() > 0) {
            sql = sql + " ORDER BY ";
            for (int i = 0; i < this.sortcolumns.size(); ++i) {
                if (i != 0) {
                    sql = sql + ", ";
                }
                column = (Column)this.sortcolumns.get(i);
                sql = sql + column.getSQLDefinition();
            }
            sql = this.sortBox.getSelectedIndex() == 0 ? sql + " ASC" : sql + " DESC";
        }
        if (sql == null) {
            return false;
        }
        ResultSet resultset = null;
        try {
            resultset = M4Interface.getCurrentCase().executeBusinessSqlRead(sql);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return false;
        }
        try {
            this.metadata = resultset.getMetaData();
        }
        catch (SQLException error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return false;
        }
        try {
            this.nr_cols = this.metadata.getColumnCount();
        }
        catch (SQLException error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return false;
        }
        this.nr_rows = endrow - startrow + 1;
        this.data = new Object[this.nr_rows][this.nr_cols];
        try {
            int row;
            int i;
            if (dbms == 2 && this.columnset.getType().equals("V")) {
                for (i = 1; i < startrow; ++i) {
                    resultset.next();
                }
                for (row = 0; resultset.next() && row < this.nr_rows; ++row) {
                    for (int i2 = 0; i2 < this.nr_cols; ++i2) {
                        this.data[row][i2] = resultset.getObject(i2 + 1);
                    }
                }
            } else {
                for (i = 1; i < startrow; ++i) {
                    resultset.next();
                }
                for (row = 0; resultset.next() && row < this.nr_rows; ++row) {
                    for (int i3 = 0; i3 < this.nr_cols; ++i3) {
                        this.data[row][i3] = resultset.getObject(i3 + 1);
                    }
                }
            }
        }
        catch (SQLException error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return false;
        }
        try {
            resultset.close();
        }
        catch (SQLException error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return false;
        }
        return true;
    }

    private void updateDataView() {
        if (this.initData()) {
            this.datatable.setModel(new DataModel());
            this.updateButton.setEnabled(false);
        }
    }

    private void selectColumns() {
        String[] data = new String[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            data[i] = ((Column)this.columns.get(i)).getName();
        }
        String[] selected_data = new String[this.selectedcolumns.size()];
        for (int i = 0; i < this.selectedcolumns.size(); ++i) {
            selected_data[i] = ((Column)this.selectedcolumns.get(i)).getName();
        }
        ListSelectDialog dialog = new ListSelectDialog(this.app, Resource.getString("DATA_SELECTDIALOG_TITLE"), Resource.getString("DATA_SELECTDIALOG_SUBTITLE"), data, selected_data, true, 0, Integer.MAX_VALUE);
        if (dialog.getExitAction() == 1) {
            Column column;
            selected_data = dialog.getSelectedDataItems();
            this.selectedcolumns = new Vector();
            for (int i = 0; i < selected_data.length; ++i) {
                try {
                    column = this.columnset.getColumn(selected_data[i]);
                    this.selectedcolumns.add(column);
                    continue;
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
            }
            boolean removed = false;
            for (int i = this.sortcolumns.size() - 1; i >= 0; --i) {
                column = (Column)this.sortcolumns.get(i);
                if (this.selectedcolumns.contains(column)) continue;
                this.sortcolumns.remove(i);
                removed = true;
            }
            if (removed) {
                this.sortlist.setModel(new SortListModel());
            }
            this.columnlist.setModel(new ColumnListModel());
            this.updateButton.setEnabled(true);
            this.updateDataView();
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (!(event.getSource() instanceof JButton)) {
            return;
        }
        JButton source = (JButton)event.getSource();
        if (source.getText().equals(this.closeButton.getText())) {
            this.dispose();
        }
        if (source.getText().equals(this.nextButton.getText())) {
            this.nextDataView();
        }
        if (source.getText().equals(this.updateButton.getText())) {
            this.updateDataView();
        }
        if (source.getText().equals(this.selectButton.getText())) {
            this.selectColumns();
        }
        if (source.getText().equals(this.sortButton.getText())) {
            this.sortColumns();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.updateDataView();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DataModel
    extends AbstractTableModel {
        private DataModel() {
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = DataDialog.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            Column column = null;
            try {
                column = DataDialog.this.columnset.getColumn(this.getColumnName(columnIndex - 1));
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
            String datatype = null;
            try {
                datatype = column.getColumnDataTypeName();
            }
            catch (DbConnectionClosed error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                datatype = null;
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                datatype = null;
            }
            if (datatype == null) {
                return class$java$lang$String == null ? (class$java$lang$String = DataDialog.class$("java.lang.String")) : class$java$lang$String;
            }
            if (datatype.equals("DATE")) {
                return class$java$lang$String == null ? (class$java$lang$String = DataDialog.class$("java.lang.String")) : class$java$lang$String;
            }
            if (datatype.equals("KEY")) {
                return class$java$lang$String == null ? (class$java$lang$String = DataDialog.class$("java.lang.String")) : class$java$lang$String;
            }
            if (datatype.equals("NUMBER")) {
                return class$java$lang$Double == null ? (class$java$lang$Double = DataDialog.class$("java.lang.Double")) : class$java$lang$Double;
            }
            if (datatype.equals("STRING")) {
                return class$java$lang$String == null ? (class$java$lang$String = DataDialog.class$("java.lang.String")) : class$java$lang$String;
            }
            return class$java$lang$String == null ? (class$java$lang$String = DataDialog.class$("java.lang.String")) : class$java$lang$String;
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return Resource.getString("DATA_ROW");
            }
            try {
                return DataDialog.this.metadata.getColumnName(column);
            }
            catch (SQLException sQLException) {
                return "";
            }
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColumnCount() {
            return DataDialog.this.nr_cols + 1;
        }

        public int getRowCount() {
            return DataDialog.this.nr_rows;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return new Integer(DataDialog.this.startRow + rowIndex);
            }
            return DataDialog.this.data[rowIndex][columnIndex - 1];
        }
    }

    private class DataRenderer
    extends DefaultTableCellRenderer {
        private DataRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if ((row + 1) % 2 == 0) {
                comp.setBackground(Resource.getColor("CONCEPT_NOTSELECTED_COLOR"));
            }
            return comp;
        }
    }

    private class ColumnListModel
    extends AbstractListModel {
        private ColumnListModel() {
        }

        public Object getElementAt(int index) {
            return ((Column)DataDialog.this.selectedcolumns.get(index)).getName();
        }

        public int getSize() {
            return DataDialog.this.selectedcolumns.size();
        }
    }

    private class SortListModel
    extends AbstractListModel {
        private SortListModel() {
        }

        public Object getElementAt(int index) {
            return ((Column)DataDialog.this.sortcolumns.get(index)).getName();
        }

        public int getSize() {
            return DataDialog.this.sortcolumns.size();
        }
    }
}

