/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.concepteditor.ConceptPanel;
import edu.udo.cs.miningmart.gui.concepteditor.MappingPanel;
import edu.udo.cs.miningmart.gui.concepteditor.SpringUtilities;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelDrawingView;

public class ConnectionPanel
extends ConceptPanel
implements ActionListener {
    private MiningMartApplication app;
    private Concept concept;
    private JButton createButton;
    private JButton removeButton;
    private JButton closeButton;
    private JButton matchButton;
    private JTextField columnsetfield;
    private JList tablelist;
    private JCheckBox checkbox;
    private JComboBox matcherBox;

    public ConnectionPanel(MiningMartApplication app, Concept concept) {
        this.app = app;
        this.concept = concept;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JTextArea infoMessageTextArea = new JTextArea(Resource.getString("CONNECTION_INFOMESSAGE"));
        infoMessageTextArea.setEditable(false);
        infoMessageTextArea.setLineWrap(true);
        infoMessageTextArea.setWrapStyleWord(true);
        infoMessageTextArea.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane scrollPane = new JScrollPane(infoMessageTextArea);
        scrollPane.setPreferredSize(new Dimension(scrollPane.getWidth(), 100));
        this.add((Component)scrollPane, "North");
        this.createButton = new JButton(Resource.getString("CONNECTION_CREATE"));
        this.createButton.addActionListener(this);
        this.createButton.setEnabled(false);
        this.removeButton = new JButton(Resource.getString("CONNECTION_REMOVE"));
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        this.matchButton = new JButton(Resource.getString("CONNECTION_MATCH"));
        this.matchButton.addActionListener(this);
        this.matchButton.setEnabled(false);
        this.closeButton = new JButton(Resource.getString("CLOSE"));
        this.closeButton.addActionListener(this);
        this.checkbox = new JCheckBox(Resource.getString("CONNECTION_SHOW_MAPPING"));
        this.checkbox.setSelected(true);
        this.checkbox.setToolTipText(Resource.getString("CONNECTION_SHOW_MAPPING_TIP"));
        JPanel buttonPanel1 = new JPanel();
        buttonPanel1.setLayout(new BoxLayout(buttonPanel1, 0));
        buttonPanel1.add(Box.createHorizontalGlue());
        buttonPanel1.add(this.checkbox);
        buttonPanel1.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPanel1.add(this.createButton);
        buttonPanel1.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPanel1.add(this.matchButton);
        JPanel buttonPanel2 = new JPanel();
        buttonPanel2.setLayout(new BoxLayout(buttonPanel2, 0));
        buttonPanel2.add(Box.createHorizontalGlue());
        buttonPanel2.add(this.removeButton);
        buttonPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPanel2.add(this.closeButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(2, 1, 5, 5));
        buttonPanel.add(buttonPanel1);
        buttonPanel.add(buttonPanel2);
        JPanel midpanel = new JPanel();
        midpanel.setLayout(new SpringLayout());
        midpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel label = new JLabel(Resource.getString("CONNECTED_COLUMNSET"));
        midpanel.add(label);
        this.columnsetfield = new JTextField();
        this.columnsetfield.setEditable(false);
        Object[] columnSets = null;
        try {
            columnSets = this.concept.getColumnSets().toArray();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        if (columnSets == null || columnSets.length == 0) {
            this.columnsetfield.setText(Resource.getString("CONNECTION_NONE"));
            this.createButton.setEnabled(true);
            this.matchButton.setEnabled(true);
        } else if (columnSets.length == 1) {
            this.columnsetfield.setText(((Columnset)columnSets[0]).getName());
            this.removeButton.setEnabled(true);
        } else if (columnSets.length > 1) {
            this.columnsetfield.setText(Resource.getString("CONNECTION_MORE_COLUMNSETS"));
            this.columnsetfield.setForeground(Resource.getColor("STEPSETTINGS_COLOR_NOT_VALID"));
        }
        if (this.app.getViewMode() == 1) {
            this.createButton.setEnabled(false);
            this.matchButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.checkbox.setEnabled(false);
        }
        midpanel.add(this.columnsetfield);
        label = new JLabel(Resource.getString("CONNECTION_TABLES"));
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(1);
        midpanel.add(label);
        Vector colls = new Vector();
        try {
            colls.addAll(MiningMartApplication.m4Interface.getNamesOfBusinessTablesAndViews());
            Collections.sort(colls);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            colls = new Vector();
        }
        Iterator iter = colls.iterator();
        String[] tablenames = new String[colls.size()];
        int index = 0;
        while (iter.hasNext()) {
            tablenames[index] = (String)iter.next();
            try {
                if (MiningMartApplication.m4Interface.isBusinessTable(tablenames[index])) {
                    int n = index;
                    tablenames[n] = tablenames[n] + " (" + Resource.getString("TABLE") + ")";
                } else if (MiningMartApplication.m4Interface.isBusinessView(tablenames[index])) {
                    int n = index;
                    tablenames[n] = tablenames[n] + " (" + Resource.getString("VIEW") + ")";
                }
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
            ++index;
        }
        this.tablelist = new JList<String>(tablenames);
        this.tablelist.setSelectionMode(2);
        this.tablelist.setLayoutOrientation(0);
        this.tablelist.setVisibleRowCount(12);
        scrollPane = new JScrollPane(this.tablelist);
        midpanel.add(scrollPane);
        if (columnSets.length == 1) {
            String table = ((Columnset)columnSets[0]).getName();
            try {
                if (MiningMartApplication.m4Interface.isBusinessTable(table)) {
                    table = table + " (" + Resource.getString("TABLE") + ")";
                } else if (MiningMartApplication.m4Interface.isBusinessView(table)) {
                    table = table + " (" + Resource.getString("VIEW") + ")";
                }
                this.tablelist.setSelectedValue(table, true);
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
        }
        label = new JLabel(Resource.getString("CONNECTION_MATCHER"));
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(1);
        midpanel.add(label);
        this.matcherBox = new JComboBox<String>(M4Interface.AVAILABLE_MATCHERS);
        midpanel.add(this.matcherBox);
        SpringUtilities.makeCompactGrid(midpanel, 3, 2, 6, 6, 6, 6);
        JPanel centerpanel2 = new JPanel();
        centerpanel2.setLayout(new BorderLayout());
        centerpanel2.add((Component)midpanel, "North");
        centerpanel2.add((Component)buttonPanel, "South");
        JPanel centerpanel = new JPanel();
        centerpanel.setLayout(new BorderLayout());
        centerpanel.add((Component)centerpanel2, "North");
        this.add((Component)centerpanel, "Center");
    }

    public Concept getConcept() {
        return this.concept;
    }

    private void findConnection() {
        String table;
        Object[] tables = this.tablelist.getSelectedValues();
        if (tables == null || tables.length == 0) {
            return;
        }
        String matcher = (String)this.matcherBox.getSelectedItem();
        Vector<String> dbobjects = new Vector<String>();
        for (int i = 0; i < tables.length; ++i) {
            table = (String)tables[i];
            if (table.endsWith(" (" + Resource.getString("TABLE") + ")")) {
                table = table.substring(0, table.length() - 3 - Resource.getString("TABLE").length());
            } else if (table.endsWith(" (" + Resource.getString("VIEW") + ")")) {
                table = table.substring(0, table.length() - 3 - Resource.getString("VIEW").length());
            }
            dbobjects.add(table);
        }
        try {
            Collection joinedSets = MiningMartApplication.m4Interface.findConnection(this.concept, dbobjects, matcher);
            if (joinedSets != null) {
                Iterator iter = joinedSets.iterator();
                Columnset columnset1 = (Columnset)iter.next();
                Columnset columnset2 = (Columnset)iter.next();
                Columnset joinedset = (Columnset)iter.next();
                String message = Resource.getString("CONNECTION_JOIN_MSG1") + " " + columnset1.getName() + "," + columnset2.getName() + " " + Resource.getString("CONNECTION_JOIN_MSG2") + "\n" + Resource.getString("CONNECTION_JOIN_MSG3") + " " + this.concept.getName();
                JOptionPane.showMessageDialog(this.app, message, Resource.getString("CONNECTION_JOIN_TITLE"), 1);
                return;
            }
            Object[] columnSets = null;
            try {
                columnSets = this.concept.getColumnSets().toArray();
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
            if (columnSets == null || columnSets.length == 0) {
                throw new M4Exception(Resource.getString("CONNECTION_ERRORMESSAGE"));
            }
            if (columnSets.length == 1) {
                table = ((Columnset)columnSets[0]).getName();
                this.columnsetfield.setText(table);
                try {
                    if (MiningMartApplication.m4Interface.isBusinessTable(table)) {
                        table = table + " (" + Resource.getString("TABLE") + ")";
                    } else if (MiningMartApplication.m4Interface.isBusinessView(table)) {
                        table = table + " (" + Resource.getString("VIEW") + ")";
                    }
                    this.tablelist.clearSelection();
                    this.tablelist.setSelectedValue(table, true);
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
            } else if (columnSets.length > 1) {
                throw new M4Exception(Resource.getString("CONNECTION_NONE"));
            }
            this.createButton.setEnabled(false);
            this.matchButton.setEnabled(false);
            this.removeButton.setEnabled(true);
            ((ModelDrawingView)this.app.getDrawingView()).repaint();
            this.app.getMiningMartConcepts().setDirty(true);
            if (this.checkbox.isSelected()) {
                MappingPanel panel = new MappingPanel(this.app, this.concept);
                this.app.showConceptPanel(panel);
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    private void createConnection() {
        Columnset set;
        boolean btable;
        String table = (String)this.tablelist.getSelectedValue();
        if (table == null) {
            return;
        }
        if (table.endsWith(" (" + Resource.getString("TABLE") + ")")) {
            table = table.substring(0, table.length() - 3 - Resource.getString("TABLE").length());
        } else if (table.endsWith(" (" + Resource.getString("VIEW") + ")")) {
            table = table.substring(0, table.length() - 3 - Resource.getString("VIEW").length());
        }
        try {
            btable = MiningMartApplication.m4Interface.isBusinessTable(table);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return;
        }
        try {
            this.concept.connect(table, btable, new HashMap());
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return;
        }
        try {
            set = this.concept.getCurrentColumnSet();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            set = null;
        }
        if (set == null) {
            return;
        }
        this.columnsetfield.setText(table);
        this.createButton.setEnabled(false);
        this.matchButton.setEnabled(false);
        this.removeButton.setEnabled(true);
        ((ModelDrawingView)this.app.getDrawingView()).repaint();
        this.app.getMiningMartConcepts().setDirty(true);
        if (this.checkbox.isSelected()) {
            MappingPanel panel = new MappingPanel(this.app, this.concept);
            this.app.showConceptPanel(panel);
        }
    }

    private void removeConnection() {
        try {
            this.concept.removeConnection();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return;
        }
        this.columnsetfield.setText(Resource.getString("CONNECTION_NONE"));
        this.createButton.setEnabled(true);
        this.matchButton.setEnabled(true);
        this.removeButton.setEnabled(false);
        ((ModelDrawingView)this.app.getDrawingView()).repaint();
        this.app.getMiningMartConcepts().setDirty(true);
    }

    public String toString() {
        return Resource.getString("CONCEPT_CONNECTION");
    }

    public void actionPerformed(ActionEvent event) {
        if (!(event.getSource() instanceof JButton)) {
            return;
        }
        JButton source = (JButton)event.getSource();
        if (source.getText().equals(this.closeButton.getText())) {
            this.app.removeComponentFromTab(this);
        }
        if (source.getText().equals(this.createButton.getText())) {
            this.createConnection();
        }
        if (source.getText().equals(this.removeButton.getText())) {
            this.removeConnection();
        }
        if (source.getText().equals(this.matchButton.getText())) {
            this.findConnection();
        }
    }
}

