/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.model.MiningMartCase;
import edu.udo.cs.miningmart.gui.model.MiningMartChain;
import edu.udo.cs.miningmart.gui.model.StepTransition;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.event.MouseEvent;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.standard.ConnectionTool;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.util.LogFile;

public class StepTransitionTool
extends ConnectionTool {
    private MiningMartApplication parent;
    private Class startType;
    private String startName;
    private Class endType;
    private String endName;
    private Class modelClass;
    private ModelConnectionElement newElement;

    public StepTransitionTool(MiningMartApplication parent, Class modelClass, Class startType, String startName, Class endType, String endName) {
        super(parent, null);
        this.parent = parent;
        this.startType = startType;
        this.startName = startName;
        this.endType = endType;
        this.endName = endName;
        this.modelClass = modelClass;
    }

    protected ConnectionFigure createConnection() {
        LineConnection line = new LineConnection();
        line.setStartDecoration(null);
        line.setEndDecoration(null);
        return line;
    }

    protected ModelConnectionElement createElement(Model model, ModelElement start, ModelElement end, boolean existsTransition) {
        if (model instanceof MiningMartChain) {
            StepTransition trans = ((MiningMartChain)model).createTransition(null, (ModelFigureElement)start, (ModelFigureElement)end, existsTransition);
            if (trans == null) {
                this.editor().toolDone();
                return null;
            }
            trans.setMMartApplication(((MiningMartChain)model).getMMartApplication());
            this.editor().toolDone();
            return trans;
        }
        StepTransition trans = ((MiningMartCase)model).createTransition(null, (ModelFigureElement)start, (ModelFigureElement)end, existsTransition);
        if (trans == null) {
            this.editor().toolDone();
            return null;
        }
        trans.setMMartApplication(((MiningMartCase)model).getMMartApplication());
        this.editor().toolDone();
        return trans;
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        ConnectionFigure fig = (ConnectionFigure)this.getAddedFigure();
        super.mouseUp(e, x, y);
        this.newElement = null;
        if (fig != null) {
            ModelFigure startFigure = (ModelFigure)fig.startFigure();
            ModelFigure endFigure = (ModelFigure)fig.endFigure();
            if (startFigure != null && endFigure != null) {
                ModelFigureElement startElement = startFigure.getElement();
                ModelFigureElement endElement = endFigure.getElement();
                boolean existstrans = false;
                Model parentmodel = (Model)startElement.getParent();
                for (int c = 0; c < parentmodel.getConnectionCount() && !existstrans; ++c) {
                    StepTransition exists = (StepTransition)parentmodel.getConnection(c);
                    if (!exists.getStart().getName().equals(startElement.getName()) || !exists.getEnd().getName().equals(endElement.getName())) continue;
                    existstrans = true;
                }
                this.drawing().remove(fig);
                fig.release();
                try {
                    ModelConnectionElement temp = (ModelConnectionElement)this.modelClass.newInstance();
                    if (temp.canConnect(startElement, endElement)) {
                        this.newElement = this.createElement(((ModelDrawing)this.drawing()).getModel(), startElement, endElement, existstrans);
                    } else {
                        this.parent.showStatus(Resource.getString("TXT_ILLEGAL_CONNECTION") + ": " + startElement.getName() + " --> " + endElement.getName());
                        this.parent.getToolkit().beep();
                    }
                }
                catch (Exception ignored) {
                    LogFile.log(ignored);
                }
            }
        }
        if (this.newElement != null) {
            this.parent.selectFigure(this.getElement());
            M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("CREATED_NEW_TRANSITION") + " " + this.getElement().getName());
        }
    }

    public ModelConnectionElement getElement() {
        return this.newElement;
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        this.parent.followPointer(x, y);
    }
}

