/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Resource;

public class StartWindow
extends JWindow {
    private ImageIcon logo;
    private String message = "Starting up.";
    private String productName;
    private String version;
    private WindowLabel startupLabel;

    public StartWindow() {
        this(Resource.getString("APP_TITLE"), Resource.getString("APP_VERSION"));
    }

    public StartWindow(String productName, String version) {
        this.productName = productName;
        this.version = version;
        this.logo = new ImageIcon(new Iconkit(this).loadImageResource(Resource.getString("MMART_IMAGE")));
        JPanel top = new JPanel(new BorderLayout());
        top.setBorder(BorderFactory.createBevelBorder(0));
        this.getContentPane().add((Component)top, "Center");
        this.startupLabel = new WindowLabel(this.logo);
        top.add((Component)this.startupLabel, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension startupWindowSize = this.getSize();
        this.setLocation((screenSize.width - startupWindowSize.width) / 2, (screenSize.height - startupWindowSize.height) / 2);
        this.setVisible(true);
    }

    public void setMessage(String message) {
        this.message = message;
        this.repaint();
    }

    private class WindowLabel
    extends JLabel {
        public WindowLabel(Icon icon) {
            super(icon);
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(Color.DARK_GRAY);
            String title = StartWindow.this.productName + " " + StartWindow.this.version;
            Dimension size = this.getSize();
            Font font = new Font("LucidaSans", 0, 12);
            FontMetrics fm = this.getFontMetrics(font);
            int titlewidth = fm.stringWidth(title);
            g.setFont(font);
            g.drawString(title, size.width - titlewidth - 20, size.height - 40);
            font = new Font("LucidaSans", 0, 10);
            g.setFont(font);
            fm = this.getFontMetrics(font);
            int messagewidth = fm.stringWidth(StartWindow.this.message);
            g.drawString(StartWindow.this.message, size.width - messagewidth - 20, size.height - 20);
        }
    }
}

