/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Resource;

public class SetModeDialog
extends JDialog
implements ActionListener {
    private JButton ok;
    private JButton cancel;
    private JRadioButton finale;
    private JRadioButton test;
    private MiningMartApplication parent;
    private Case currentcase;

    public SetModeDialog(MiningMartApplication parent, Case currentcase) {
        super(parent, Resource.getString("CASE_SET_MODE"), true);
        this.parent = parent;
        this.currentcase = currentcase;
        this.initComponents();
        this.pack();
        this.setSize(250, 130);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        Iconkit kit = Iconkit.instance();
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.setLayout(new BorderLayout(5, 5));
        this.ok = new JButton(Resource.getString("OK"));
        this.cancel = new JButton(Resource.getString("CANCEL"));
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BorderLayout());
        JPanel buttons2 = new JPanel();
        buttons2.setLayout(new BorderLayout());
        buttons2.add((Component)this.cancel, "East");
        buttons2.add((Component)this.ok, "Center");
        buttons.add((Component)buttons2, "East");
        panel.add((Component)buttons, "South");
        this.finale = new JRadioButton(Resource.getString("CASE_MODE_FINAL"));
        this.test = new JRadioButton(Resource.getString("CASE_MODE_TEST"));
        String mode = this.currentcase.getTheMode();
        if (mode.equals("FINAL")) {
            this.finale.setSelected(true);
            this.test.setSelected(false);
        } else {
            this.finale.setSelected(false);
            this.test.setSelected(true);
        }
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(this.finale);
        bGroup.add(this.test);
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout());
        JPanel midpanel = new JPanel();
        midpanel.setLayout(new BoxLayout(midpanel, 0));
        midpanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        midpanel.add(this.test);
        midpanel.add(this.finale);
        toppanel.add((Component)midpanel, "Center");
        toppanel.add((Component)new JLabel(Resource.getString("CASE_SET_THE_MODE")), "North");
        panel.add((Component)new JLabel(new ImageIcon(kit.loadImageResource(Resource.getString("INFORMATION_ICON")))), "West");
        panel.add((Component)toppanel, "Center");
        this.getContentPane().add(panel);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(Resource.getString("CANCEL"))) {
            this.dispose();
        }
        if (cmd.equals(Resource.getString("OK"))) {
            try {
                if (this.finale.isSelected()) {
                    this.currentcase.setTheMode("FINAL");
                } else {
                    this.currentcase.setTheMode("TEST");
                }
                M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("SET_THE_MODE") + " " + this.currentcase.getTheMode());
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, Resource.getString("CASE_SET_MODE_ERRORMESSAGE") + "\n" + error.getMessage(), error);
                JOptionPane.showMessageDialog(this.parent, Resource.getString("CASE_SET_MODE_ERRORMESSAGE") + "\n" + error.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            }
            this.dispose();
        }
    }
}

