/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.gui.application.LogFileFilter;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.PrintViewHandler;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.yale.gui.SearchDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;

public class PrintViewer
extends JPanel
implements ActionListener {
    public final PrintViewerOutputStream outputStream = new PrintViewerOutputStream();
    private JTextArea logarea;
    private JScrollPane scrollpane;
    private String name;
    private JPanel panel;
    private Application app;
    private PrintViewHandler handler;

    public PrintViewer(Application app) {
        this.app = app;
        this.initPrintViewer();
        this.initComponents();
    }

    private void initPrintViewer() {
        this.name = Resource.getString("LOGSERVICE");
        this.handler = new PrintViewHandler(this.outputStream);
        M4Interface.print.addHandler(this.handler);
    }

    public void closePrintViewer() {
        M4Interface.print.removeHandler(this.handler);
    }

    private void initComponents() {
        this.logarea = new JTextArea(100, 200);
        this.logarea.setBackground(Color.WHITE);
        this.logarea.setForeground(Color.BLACK);
        this.logarea.setEditable(false);
        this.scrollpane = new JScrollPane(this.logarea);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollpane, "Center");
        JPanel panel = new JPanel();
        panel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        BoxLayout boxlay = new BoxLayout(panel, 0);
        panel.setLayout(boxlay);
        JButton clearButton = new JButton(Resource.getString("CLEAR_VIEWER"));
        clearButton.addActionListener(this);
        JButton saveButton = new JButton(Resource.getString("SAVE_VIEWER"));
        saveButton.addActionListener(this);
        JButton findButton = new JButton(Resource.getString("FIND_VIEWER"));
        findButton.addActionListener(this);
        panel.add(Box.createHorizontalGlue());
        panel.add(clearButton);
        panel.add(saveButton);
        panel.add(findButton);
        this.add((Component)panel, "South");
    }

    public String toString() {
        return this.name;
    }

    public String getLogMessage() {
        return this.logarea.getText();
    }

    public void clear() {
        this.outputStream.clear();
        this.logarea.setText("");
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(Resource.getString("CLEAR_VIEWER"))) {
            this.clear();
        }
        if (cmd.equals(Resource.getString("SAVE_VIEWER"))) {
            Object f = null;
            JFileChooser chooser = new JFileChooser(((MiningMartApplication)this.app).getWorkingDir());
            chooser.addChoosableFileFilter(new LogFileFilter());
            int returnVal = chooser.showSaveDialog(this.app);
            if (returnVal != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (file != null) {
                int confirm;
                if (file.exists() && (confirm = JOptionPane.showConfirmDialog(this, Resource.getString("DIALOG_OVERWRITE_FILE") + " " + file.getName() + "?", Resource.getString("DIALOG_OVERWRITE_TITLE"), 0)) != 0) {
                    return;
                }
                try {
                    PrintWriter out = new PrintWriter(new FileWriter(file));
                    out.println(this.logarea.getText());
                    out.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        if (cmd.equals(Resource.getString("FIND_VIEWER"))) {
            new SearchDialog((Component)this, (JTextComponent)this.logarea).setVisible(true);
        }
    }

    private class PrintViewerOutputStream
    extends OutputStream {
        private StringBuffer currentString = new StringBuffer();

        private PrintViewerOutputStream() {
        }

        public void write(int b) {
            char c = (char)b;
            switch (b) {
                case 10: 
                case 13: {
                    if (this.currentString.length() <= 0) break;
                    PrintViewer.this.logarea.append(this.currentString.toString() + "\n");
                    PrintViewer.this.logarea.setCaretPosition(PrintViewer.this.logarea.getDocument().getLength());
                    this.currentString = new StringBuffer();
                    break;
                }
                case 9: {
                    this.currentString.append("   ");
                    break;
                }
                default: {
                    try {
                        this.currentString.append(c);
                        break;
                    }
                    catch (IOException error) {
                        error.printStackTrace();
                    }
                }
            }
        }

        public void clear() {
            this.currentString = new StringBuffer();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            for (int i = off; i < len; ++i) {
                this.write((char)b[i]);
            }
            PrintViewer.this.logarea.append(this.currentString.toString());
            this.currentString = new StringBuffer();
            PrintViewer.this.logarea.setCaretPosition(PrintViewer.this.logarea.getDocument().getLength());
        }

        public void write(byte[] b) throws IOException {
            for (int i = 0; i < b.length; ++i) {
                this.write((char)b[i]);
            }
            PrintViewer.this.logarea.append(this.currentString.toString());
            this.currentString = new StringBuffer();
            PrintViewer.this.logarea.setCaretPosition(PrintViewer.this.logarea.getDocument().getLength());
        }

        public void write(char c) {
            try {
                this.currentString.append(c);
            }
            catch (IOException error) {
                error.printStackTrace();
            }
        }
    }
}

