/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.m4.utils.PrintFormatter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class PrintViewHandler
extends Handler {
    private LogManager manager = LogManager.getLogManager();
    private OutputStream output;
    private boolean doneHeader;

    private void configure(Formatter formatter) {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        Logger logger = Logger.getLogger("org.musoft.limo");
        this.setLevel(logger.getLevel());
        this.setFilter(logger.getFilter());
        this.setFormatter(new PrintFormatter());
        try {
            this.setEncoding(manager.getProperty(cname + ".encoding"));
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
    }

    public PrintViewHandler(OutputStream out) {
        this.configure(new PrintFormatter());
        this.output = out;
    }

    public PrintViewHandler(OutputStream out, Formatter formatter) {
        this.configure(formatter);
        this.output = out;
    }

    public synchronized void publish(LogRecord record) {
        String msg;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        try {
            if (!this.doneHeader) {
                this.output.write(this.getFormatter().getHead(this).getBytes());
                this.doneHeader = true;
            }
            this.output.write(msg.getBytes());
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
    }

    public void close() throws SecurityException {
        try {
            this.output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flush() {
        try {
            this.output.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

