/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.StepTransitionTool;
import edu.udo.cs.miningmart.gui.model.MiningMartCase;
import edu.udo.cs.miningmart.gui.model.MiningMartChain;
import edu.udo.cs.miningmart.gui.model.MiningMartStep;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Operator;
import edu.udo.cs.miningmart.m4.OperatorGroup;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.MyToolButton;
import org.musoft.limo.application.Resource;
import org.musoft.limo.application.StaticJButton;
import org.musoft.limo.application.ToolBar;
import org.musoft.limo.model.ModelFigureElement;

public class OperatorToolPanel
extends ToolBar {
    private MiningMartApplication app;
    private JPanel op_panel;
    private JPanel stuff_panel;
    private JPanel panel;
    private JPanel panel2;
    private JPanel toppanel;
    private JScrollPane scrollpane;
    private JLayeredPane layerpane;
    private Vector opsintoolpanel;
    private Vector groups = new Vector();
    private Vector groupstoolbars = new Vector();
    static /* synthetic */ Class class$edu$udo$cs$miningmart$gui$model$StepTransition;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$gui$model$MiningMartStep;

    public OperatorToolPanel(MiningMartApplication app) {
        super(app);
        this.app = app;
        this.initOperatorsInToolPanel();
        this.initComponents();
    }

    private void initOperatorsInToolPanel() {
        this.opsintoolpanel = this.app.getOperatorsInToolPanel();
    }

    private void initComponents() {
        this.initStuffPanel();
        this.initOperatorPanel();
        this.op_panel = new JPanel();
        GridLayout grid = new GridLayout(this.groupstoolbars.size(), 1);
        grid.setHgap(4);
        grid.setVgap(4);
        this.op_panel.setLayout(grid);
        for (int index = 0; index < this.groupstoolbars.size(); ++index) {
            String groupname = (String)this.groups.get(index);
            ToolBar toolbar = (ToolBar)this.groupstoolbars.get(index);
            toolbar.addGroup(groupname);
            toolbar.showGroup(groupname, 0);
            toolbar.setPreferredSize(new Dimension(40, 40));
            toolbar.setFloatable(false);
            this.op_panel.add(toolbar);
        }
        this.panel2 = new JPanel();
        this.panel2.setLayout(new BorderLayout());
        this.panel2.add((Component)this.op_panel, "North");
        this.scrollpane = new JScrollPane(this.panel2);
        this.toppanel = new JPanel(){

            public String toString() {
                return Resource.getString("COMP_OPERATORTOOLS");
            }
        };
        this.toppanel.setLayout(new BorderLayout());
        this.toppanel.add((Component)this.scrollpane, "Center");
    }

    private void initStuffPanel() {
        Iconkit kit = Iconkit.instance();
        if (kit == null) {
            throw new JHotDrawRuntimeException("Iconkit instance isn't set");
        }
        AbstractTool tool = new MyAbstractTool(Resource.getString("TOOL_CHAIN"), this.app){

            public void mouseDown(MouseEvent e, int x, int y) {
                super.mouseDown(e, x, y);
                ModelFigureElement p = OperatorToolPanel.this.getPotentialParent(x, y, this.drawing());
                MiningMartChain s = null;
                if (p instanceof MiningMartCase) {
                    s = ((MiningMartCase)p).createMiningMartChain(p, Resource.getString("CHAIN"), new Point(x, y), new Rectangle(x, y, 35, 35));
                } else if (p instanceof MiningMartChain) {
                    s = ((MiningMartChain)p).createMiningMartChain(p, Resource.getString("CHAIN"), new Point(x, y), new Rectangle(x, y, 35, 35));
                } else {
                    return;
                }
                this.editor().toolDone();
                if (s != null) {
                    OperatorToolPanel.this.app.selectFigure(s);
                    M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("INSERTED_NEW_CHAIN") + " " + s.getName());
                }
            }
        };
        MyToolButton button = this.createMyToolButton(Resource.getString("TOOLIMG_CHAIN"), Resource.getString("TOOL_CHAIN"), tool);
        button.setToolTipText(Resource.getString("TOOL_CHAIN"));
        this.add("tools", button);
        StaticJButton jbutton = new StaticJButton(Resource.getString("TOOL_MERGE_CHAIN"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_MERGE_CHAIN"))));
        jbutton.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_MERGE_CHAIN"))));
        jbutton.setBorder(null);
        jbutton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (((StaticJButton)evt.getSource()).isEnabled()) {
                    ((MiningMartApplication)OperatorToolPanel.this.parent).promptMergeChain();
                }
            }
        });
        jbutton.setToolTipText(Resource.getString("TOOL_MERGE_CHAIN"));
        this.add("tools", jbutton);
        jbutton = new StaticJButton(Resource.getString("TOOL_UNMERGE_CHAIN"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_UNMERGE_CHAIN"))));
        jbutton.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_UNMERGE_CHAIN"))));
        jbutton.setBorder(null);
        jbutton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (((StaticJButton)evt.getSource()).isEnabled()) {
                    ((MiningMartApplication)OperatorToolPanel.this.parent).promptUnmergeChain();
                }
            }
        });
        jbutton.setToolTipText(Resource.getString("TOOL_UNMERGE_CHAIN"));
        this.add("tools", jbutton);
        tool = new StepTransitionTool((MiningMartApplication)this.parent, class$edu$udo$cs$miningmart$gui$model$StepTransition == null ? (class$edu$udo$cs$miningmart$gui$model$StepTransition = OperatorToolPanel.class$("edu.udo.cs.miningmart.gui.model.StepTransition")) : class$edu$udo$cs$miningmart$gui$model$StepTransition, class$edu$udo$cs$miningmart$gui$model$MiningMartStep == null ? (class$edu$udo$cs$miningmart$gui$model$MiningMartStep = OperatorToolPanel.class$("edu.udo.cs.miningmart.gui.model.MiningMartStep")) : class$edu$udo$cs$miningmart$gui$model$MiningMartStep, "outgoing", class$edu$udo$cs$miningmart$gui$model$MiningMartStep == null ? (class$edu$udo$cs$miningmart$gui$model$MiningMartStep = OperatorToolPanel.class$("edu.udo.cs.miningmart.gui.model.MiningMartStep")) : class$edu$udo$cs$miningmart$gui$model$MiningMartStep, "incoming");
        this.add("tools", this.createMyToolButton(Resource.getString("TOOLIMG_TRANSITION"), Resource.getString("TOOL_TRANSITION"), tool));
        jbutton = new StaticJButton(Resource.getString("TOOL_ALL_TRANSITIONS"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_ALL_TRANSITIONS"))));
        jbutton.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_ALL_TRANSITIONS"))));
        jbutton.setBorder(null);
        jbutton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (((StaticJButton)evt.getSource()).isEnabled()) {
                    ((MiningMartApplication)OperatorToolPanel.this.parent).promptShowAllTransitions();
                }
            }
        });
        jbutton.setToolTipText(Resource.getString("TOOL_ALL_TRANSITIONS"));
        this.add("tools", jbutton);
        jbutton = new StaticJButton(Resource.getString("TOOL_SHOW_STEPSETTINGS"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_SHOW_STEPSETTINGS"))));
        jbutton.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_SHOW_STEPSETTINGS"))));
        jbutton.setBorder(null);
        jbutton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (((StaticJButton)evt.getSource()).isEnabled()) {
                    ((MiningMartApplication)OperatorToolPanel.this.parent).showStepSettings();
                }
            }
        });
        jbutton.setToolTipText(Resource.getString("TOOL_SHOW_STEPSETTINGS"));
        this.add("tools", jbutton);
    }

    private void initOperatorPanel() {
        M4Interface m4i = M4Interface.getInstance();
        boolean success = true;
        if (m4i != null) {
            OperatorGroup opg = m4i.getOperatorGroup();
            Iterator it = opg.getTopLevelOperatorGroups().iterator();
            while (it.hasNext()) {
                Long opgId = (Long)it.next();
                try {
                    this.recurseThroughInsertOps(opgId, opg);
                }
                catch (M4Exception e) {
                    M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
                    success = false;
                }
            }
        }
    }

    private void recurseThroughInsertOps(Long opGroupId, OperatorGroup opg) throws M4Exception {
        Collection col = opg.getChildGroups(opGroupId);
        if (col != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                Long idNext = (Long)it.next();
                Collection down = opg.getChildGroups(idNext);
                if (down != null) {
                    this.recurseThroughInsertOps(idNext, opg);
                    continue;
                }
                Operator op = opg.getOperator(idNext);
                if (op == null) continue;
                String opName = op.getName();
                String groupname = opg.getGroupName(opGroupId);
                this.addOperatorToolButton(opName, groupname);
            }
        }
    }

    private void addOperatorToolButton(String opname, String groupname) {
        if (this.opsintoolpanel.contains(opname.toLowerCase())) {
            MyAbstractTool tool = new MyAbstractTool(opname, this.app){

                public void mouseDown(MouseEvent e, int x, int y) {
                    super.mouseDown(e, x, y);
                    ModelFigureElement p = OperatorToolPanel.this.app.getPotentialParent(x, y);
                    MiningMartStep s = null;
                    if (!(p instanceof MiningMartChain)) {
                        return;
                    }
                    s = ((MiningMartChain)p).createMiningMartStep(p, this.getName(), new Point(x, y), new Rectangle(x, y, 35, 35));
                    OperatorToolPanel.this.app.toolDone();
                    if (s != null) {
                        OperatorToolPanel.this.app.selectFigure(s);
                        M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("INSERTED_OPERATOR") + " " + s.getName());
                    }
                }
            };
            MyToolButton button = this.createMyToolButton(Resource.getString("TOOLIMG_GENERIC"), Resource.getString(opname), tool);
            button.setToolTipText(opname);
            this.add(groupname, button);
        }
    }

    public Component add(String groupname, JButton button) {
        if (this.groups.contains(groupname)) {
            int index = this.groups.indexOf(groupname);
            ToolBar bar = (ToolBar)this.groupstoolbars.remove(index);
            bar.addButton(groupname, button);
            this.groupstoolbars.insertElementAt(bar, index);
        } else {
            this.groups.add(groupname);
            ToolBar bar = new ToolBar(this.app);
            bar.removeAll();
            bar.addButton(groupname, button);
            this.groupstoolbars.add(bar);
        }
        return button;
    }

    public JPanel getOperatorToolPanel() {
        return this.toppanel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MyAbstractTool
    extends AbstractTool {
        private String name;

        public MyAbstractTool(String name, DrawingEditor drawingeditor) {
            super(drawingeditor);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

