/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.OpenCaseThread;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.musoft.limo.application.Resource;

public class OpeningCaseDialog
extends JDialog {
    private String text;
    private String casename;
    private JLabel textlabel;
    public static final int ONE_SECOND = 1000;
    public static final int MILLI_SECOND = 100;
    private JProgressBar progressbar;
    private OpenCaseThread thread;
    private Timer timer;
    private int value = 0;

    public OpeningCaseDialog(MiningMartApplication parent, String casename, OpenCaseThread thread) {
        super(parent, Resource.getString("OPENING_CASE"), false);
        this.thread = thread;
        this.text = thread.getComment();
        this.casename = casename;
        this.initComponents();
        this.initTimer();
        this.setDefaultCloseOperation(2);
        this.pack();
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.textlabel.setText(text);
        this.textlabel.repaint();
    }

    private void initComponents() {
        Border emptyborder = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        Border emptyborder2 = BorderFactory.createEmptyBorder(5, 0, 5, 0);
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout(5, 5));
        toppanel.setBorder(emptyborder);
        this.getContentPane().add(toppanel);
        JLabel titlelabel = new JLabel();
        titlelabel.setText(Resource.getString("TITLE_OPENING_CASE") + " " + this.casename);
        Font titlefont = new Font("SansSerif", 0, 14);
        titlelabel.setFont(titlefont);
        titlelabel.setForeground(Color.BLACK);
        titlelabel.setBorder(emptyborder2);
        toppanel.add((Component)titlelabel, "North");
        this.textlabel = new JLabel();
        this.textlabel.setHorizontalAlignment(0);
        this.textlabel.setVerticalAlignment(0);
        Font textfont = new Font("SansSerif", 0, 12);
        this.textlabel.setFont(textfont);
        this.textlabel.setForeground(Color.BLUE);
        this.textlabel.setText(this.text);
        toppanel.add((Component)this.textlabel, "Center");
        this.progressbar = new JProgressBar(0, 1000);
        this.progressbar.setValue(0);
        this.progressbar.setIndeterminate(true);
        this.progressbar.setStringPainted(false);
        Dimension d = new Dimension(300, 25);
        this.progressbar.setMaximumSize(d);
        this.progressbar.setMinimumSize(d);
        this.progressbar.setPreferredSize(d);
        JPanel center = new JPanel();
        center.setBorder(BorderFactory.createEmptyBorder(25, 25, 25, 25));
        center.add(this.progressbar);
        toppanel.add((Component)center, "South");
    }

    private void initTimer() {
        this.value = 0;
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!OpeningCaseDialog.this.thread.isReady()) {
                    OpeningCaseDialog.this.setText(OpeningCaseDialog.this.thread.getComment());
                } else {
                    OpeningCaseDialog.this.dispose();
                }
            }
        });
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.timer.start();
        }
        super.setVisible(visible);
    }
}

