/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.M4Interface;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;
import org.musoft.limo.application.StaticJButton;
import org.musoft.limo.application.ToolBar;
import org.musoft.limo.model.ModelFigureElement;

public class MiningMartToolBar
extends ToolBar {
    private Application parent = this.getParentApplication();

    public MiningMartToolBar(Application p) {
        super(p);
        this.setFloatable(false);
        this.removeAll();
        this.createCaseTools();
        this.createCompileTools();
        this.createHelpTools();
        this.addGroup("case");
        this.showGroup("case", 0);
        this.addGroup("compile");
        this.showGroup("compile", 0);
        this.addGroup("help");
        this.showGroup("help", 0);
        this.initToolStates();
    }

    public void initToolStates() {
        this.enableTool(Resource.getString("TOOL_EXPORTCASE"), false);
        this.enableTool(Resource.getString("TOOL_SAVECASE"), false);
        this.enableTool(Resource.getString("TOOL_PRINTCASE"), false);
        this.enableTool(Resource.getString("TOOL_CUT"), false);
        this.enableTool(Resource.getString("TOOL_COPY"), false);
        this.enableTool(Resource.getString("TOOL_PASTE"), false);
        this.enableTool(Resource.getString("TOOL_DELETE"), false);
        this.enableTool(Resource.getString("TOOL_VALIDATE"), false);
        this.enableTool(Resource.getString("TOOL_VALIDATEALL"), false);
        this.enableTool(Resource.getString("TOOL_GARBAGE"), false);
        this.enableTool(Resource.getString("TOOL_COMPILEALL"), false);
        this.enableTool(Resource.getString("TOOL_COMPILEFROMSELECTED"), false);
        this.enableTool(Resource.getString("TOOL_COMPILEUNTILSELECTED"), false);
        this.enableTool(Resource.getString("TOOL_COMPILESTEP"), false);
        this.enableTool(Resource.getString("TOOL_SWITCH_EDITOR"), false);
    }

    public void promptOpenItemStates() {
        this.enableTool(Resource.getString("TOOL_EXPORTCASE"), true);
        this.enableTool(Resource.getString("TOOL_PRINTCASE"), true);
        this.enableTool(Resource.getString("TOOL_ALL_TRANSITIONS"), true);
        this.enableTool(Resource.getString("TOOL_SHOW_STEPSETTINGS"), true);
        this.enableTool(Resource.getString("TOOL_SWITCH_EDITOR"), true);
        if (this.parent.getViewMode() == 0) {
            this.enableTool(Resource.getString("TOOL_CUT"), true);
            this.enableTool(Resource.getString("TOOL_COPY"), true);
            this.enableTool(Resource.getString("TOOL_PASTE"), true);
            this.enableTool(Resource.getString("TOOL_DELETE"), true);
            this.enableTool(Resource.getString("TOOL_VALIDATE"), true);
            this.enableTool(Resource.getString("TOOL_VALIDATEALL"), true);
            this.enableTool(Resource.getString("TOOL_GARBAGE"), true);
        }
        this.promptSwitchEditor();
    }

    public void promptStartCompilationItemStates() {
        this.enableTool(Resource.getString("TOOL_COMPILEALL"), false);
        this.enableTool(Resource.getString("TOOL_COMPILEFROMSELECTED"), false);
        this.enableTool(Resource.getString("TOOL_COMPILEUNTILSELECTED"), false);
        this.enableTool(Resource.getString("TOOL_COMPILESTEP"), false);
    }

    public void promptDoneCompilationItemStates() {
        this.enableTool(Resource.getString("TOOL_COMPILEALL"), true);
        this.enableTool(Resource.getString("TOOL_COMPILEFROMSELECTED"), true);
        this.enableTool(Resource.getString("TOOL_COMPILEUNTILSELECTED"), true);
        this.enableTool(Resource.getString("TOOL_COMPILESTEP"), true);
    }

    public void promptSwitchEditor() {
        if (((MiningMartApplication)this.parent).getEditorMode() == 0 && this.parent.getViewMode() == 0) {
            this.enableTool(Resource.getString("TOOL_COMPILEALL"), true);
            this.enableTool(Resource.getString("TOOL_COMPILEFROMSELECTED"), true);
            this.enableTool(Resource.getString("TOOL_COMPILEUNTILSELECTED"), true);
            this.enableTool(Resource.getString("TOOL_COMPILESTEP"), true);
        }
    }

    public void promptNewToolStates() {
        this.promptOpenItemStates();
    }

    public void promptCloseToolStates() {
        this.initToolStates();
    }

    protected void createCaseTools() {
        Iconkit kit = Iconkit.instance();
        if (kit == null) {
            throw new JHotDrawRuntimeException("Iconkit instance isn't set");
        }
        StaticJButton button = new StaticJButton(Resource.getString("TOOL_NEWCASE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_NEWCASE"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_NEWCASE"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (((StaticJButton)evt.getSource()).isEnabled()) {
                    MiningMartToolBar.this.parent.promptNew();
                }
            }
        });
        button.setToolTipText(Resource.getString("TOOL_NEWCASE"));
        this.addButton("case", button);
        button = new StaticJButton(Resource.getString("TOOL_OPENCASE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_OPENCASE"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_OPENCASE"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (((StaticJButton)evt.getSource()).isEnabled()) {
                    MiningMartToolBar.this.parent.promptOpen();
                }
            }
        });
        button.setToolTipText(Resource.getString("TOOL_OPENCASE"));
        this.addButton("case", button);
        button = new StaticJButton(Resource.getString("TOOL_SAVECASE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_SAVECASE"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_SAVECASE"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (((StaticJButton)evt.getSource()).isEnabled()) {
                    MiningMartToolBar.this.parent.saveModel();
                }
            }
        });
        button.setToolTipText(Resource.getString("TOOL_SAVECASE"));
        this.addButton("case", button);
        button = new StaticJButton(Resource.getString("TOOL_IMPORTCASE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_IMPORTCASE"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_IMPORTCASE"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (((StaticJButton)evt.getSource()).isEnabled()) {
                    ((MiningMartApplication)MiningMartToolBar.this.parent).importCase();
                }
            }
        });
        button.setToolTipText(Resource.getString("TOOL_IMPORTCASE"));
        this.addButton("case", button);
        button = new StaticJButton(Resource.getString("TOOL_EXPORTCASE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_EXPORTCASE"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_EXPORTCASE"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (((StaticJButton)evt.getSource()).isEnabled()) {
                    ((MiningMartApplication)MiningMartToolBar.this.parent).exportCase();
                }
            }
        });
        button.setToolTipText(Resource.getString("TOOL_EXPORTCASE"));
        this.addButton("case", button);
        button = new StaticJButton(Resource.getString("TOOL_PRINTCASE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_PRINTCASE"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_PRINTCASE"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (((StaticJButton)evt.getSource()).isEnabled()) {
                    MiningMartToolBar.this.parent.promptPrint(true);
                }
            }
        });
        button.setToolTipText(Resource.getString("TOOL_PRINTCASE"));
        this.addButton("case", button);
    }

    protected void createChainTools() {
        Iconkit kit = Iconkit.instance();
        if (kit == null) {
            throw new JHotDrawRuntimeException("Iconkit instance isn't set");
        }
        StaticJButton button = new StaticJButton(Resource.getString("TOOL_CUT"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_CUT"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_CUT"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
            }
        });
        button.setToolTipText(Resource.getString("TOOL_CUT"));
        this.addButton("chain", button);
        button = new StaticJButton(Resource.getString("TOOL_COPY"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_COPY"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_COPY"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
            }
        });
        button.setToolTipText(Resource.getString("TOOL_COPY"));
        this.addButton("chain", button);
        button = new StaticJButton(Resource.getString("TOOL_PASTE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_PASTE"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_PASTE"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
            }
        });
        button.setToolTipText(Resource.getString("TOOL_PASTE"));
        this.addButton("chain", button);
        button = new StaticJButton(Resource.getString("TOOL_DELETE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_DELETE"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_DELETE"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
            }
        });
        button.setToolTipText(Resource.getString("TOOL_DELETE"));
        this.addButton("chain", button);
    }

    protected void createCompileTools() {
        Iconkit kit = Iconkit.instance();
        if (kit == null) {
            throw new JHotDrawRuntimeException("Iconkit instance isn't set");
        }
        StaticJButton button = new StaticJButton(Resource.getString("TOOL_COMPILEALL"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_COMPILEALL"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_COMPILEALL"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ((MiningMartApplication)MiningMartToolBar.this.parent).compileAll();
            }
        });
        button.setToolTipText(Resource.getString("TOOL_COMPILEALL"));
        this.addButton("compile", button);
        button = new StaticJButton(Resource.getString("TOOL_COMPILEFROMSELECTED"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_COMPILEFROMSELECTED"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_COMPILEFROMSELECTED"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ((MiningMartApplication)MiningMartToolBar.this.parent).compileFrom();
            }
        });
        button.setToolTipText(Resource.getString("TOOL_COMPILEFROMSELECTED"));
        this.addButton("compile", button);
        button = new StaticJButton(Resource.getString("TOOL_COMPILEUNTILSELECTED"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_COMPILEUNTILSELECTED"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_COMPILEUNTILSELECTED"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ((MiningMartApplication)MiningMartToolBar.this.parent).compileUntil();
            }
        });
        button.setToolTipText(Resource.getString("TOOL_COMPILEUNTILSELECTED"));
        this.addButton("compile", button);
        button = new StaticJButton(Resource.getString("TOOL_COMPILESTEP"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_COMPILESTEP"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_COMPILESTEP"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ((MiningMartApplication)MiningMartToolBar.this.parent).compileStep();
            }
        });
        button.setToolTipText(Resource.getString("TOOL_COMPILESTEP"));
        this.addButton("compile", button);
        button = new StaticJButton(Resource.getString("TOOL_GARBAGE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_GARBAGE"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_GARBAGE"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ((MiningMartApplication)MiningMartToolBar.this.parent).collectGarbage();
            }
        });
        button.setToolTipText(Resource.getString("TOOL_GARBAGE"));
        this.addButton("compile", button);
    }

    protected void createHelpTools() {
        Iconkit kit = Iconkit.instance();
        if (kit == null) {
            throw new JHotDrawRuntimeException("Iconkit instance isn't set");
        }
        StaticJButton button = new StaticJButton(Resource.getString("TOOL_SWITCH_EDITOR"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_SWITCH_EDITOR"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_SWITCH_EDITOR"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MiningMartApplication app = (MiningMartApplication)MiningMartToolBar.this.parent;
                app.saveModel();
                String casename = app.getModel().getName();
                if (app.getEditorMode() == 1) {
                    casename = M4Interface.getCurrentCase().getName();
                }
                boolean editing = app.getViewMode() == 0;
                MiningMartApplication.keepCase = true;
                app.promptClose();
                if (app.getEditorMode() == 1) {
                    app.setEditorMode(0);
                } else {
                    app.setEditorMode(1);
                }
                app.promptOpen(casename, editing);
                MiningMartApplication.keepCase = false;
            }
        });
        button.setToolTipText(Resource.getString("TOOL_SWITCH_EDITOR"));
        this.addButton("help", button);
        button = new StaticJButton(Resource.getString("TOOL_HELP"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_HELP"))));
        button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_HELP"))));
        button.setBorder(null);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ((MiningMartApplication)MiningMartToolBar.this.parent).showHelp();
            }
        });
        button.setToolTipText(Resource.getString("TOOL_HELP"));
        this.addButton("help", button);
    }

    protected void createStateTools() {
    }

    public ModelFigureElement getPotentialParent(int x, int y, Drawing drawing) {
        return super.getPotentialParent(x, y, drawing);
    }

    private class MyAbstractTool
    extends AbstractTool {
        private String name;

        public MyAbstractTool(String name, DrawingEditor drawingeditor) {
            super(drawingeditor);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

