/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.ConceptEditorPreferencesPanel;
import edu.udo.cs.miningmart.gui.application.ConceptFromCaseDialog;
import edu.udo.cs.miningmart.gui.application.ConceptFromTableDialog;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.NewConceptDialog;
import edu.udo.cs.miningmart.gui.application.OperatorPreferencesPanel;
import edu.udo.cs.miningmart.gui.application.PreferencesFrame;
import edu.udo.cs.miningmart.gui.application.VerbosityPreferencesPanel;
import edu.udo.cs.miningmart.gui.model.MiningMartCase;
import edu.udo.cs.miningmart.gui.model.MiningMartChain;
import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.gui.model.MiningMartConcepts;
import edu.udo.cs.miningmart.gui.model.MiningMartStep;
import edu.udo.cs.miningmart.gui.model.StepTransition;
import edu.udo.cs.miningmart.gui.util.RecentFiles;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Operator;
import edu.udo.cs.miningmart.m4.OperatorGroup;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.Dimension;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.util.CommandMenu;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.IconCommandMenu;
import org.musoft.limo.application.MenuBar;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelFigureElement;

public class MiningMartMenuBar
extends MenuBar {
    private MiningMartApplication app;
    private RecentFiles recentfiles;
    private CommandMenu recentFiles;
    private static JCheckBoxMenuItem compileMode;
    private IconCommandMenu operatorsmenu;
    private JMenu switchmode;
    public JCheckBoxMenuItem show_tools;
    public JCheckBoxMenuItem show_annotations;
    public JCheckBoxMenuItem show_help;
    JRadioButtonMenuItem caseeditor;
    JRadioButtonMenuItem concepteditor;

    public MiningMartMenuBar(Application p) {
        super(p);
        this.app = (MiningMartApplication)p;
        this.initItemStates();
    }

    protected void createMenus() {
        this.setRecentCases();
        this.addMenu(this.createCaseMenu());
        this.addMenu(this.createInsertMenu());
        this.addMenu(this.createCompileMenu());
        this.addMenu(this.createToolsMenu());
        this.addMenu(this.createWindowMenu());
        this.addMenu(this.createHelpMenu());
    }

    public RecentFiles getRecentCases() {
        return this.recentfiles;
    }

    public void setRecentCases() {
        this.recentfiles = new RecentFiles(8);
        this.parent.loadParams();
        String recent = ((MiningMartApplication)this.parent).getPreferences().getString("RecentCases");
        if (recent == null) {
            recent = new String("");
        }
        StringTokenizer st = new StringTokenizer(recent, ";");
        int pos = 1;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.recentfiles.setRecentFile(token, pos);
            ++pos;
        }
        this.setRecentCasesGUI();
    }

    public void removeRecentCases() {
        M4Interface m4interface = MiningMartApplication.m4Interface;
        if (m4interface == null) {
            return;
        }
        for (int i = this.recentfiles.getSize() - 1; i >= 0; --i) {
            String recfile = this.recentfiles.getFile(i);
            if (m4interface.existsCase(recfile)) continue;
            this.recentfiles.removeRecentFile(recfile);
        }
    }

    public void setRecentCasesGUI() {
        Iconkit kit = Iconkit.instance();
        this.removeRecentCases();
        if (this.recentFiles == null) {
            this.recentFiles = new CommandMenu(Resource.getString("MENU_CASE_RECENT"));
            this.recentFiles.setMnemonic(Resource.getChar("MENUM_CASE_RECENT"));
            this.recentFiles.setIcon(new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_CASE_RECENT"))));
        } else {
            this.recentFiles.removeAll();
        }
        for (int i = 0; i < this.recentfiles.getSize(); ++i) {
            String recfile = this.recentfiles.getFile(i);
            AbstractCommand cmd = new AbstractCommand(recfile, this.parent, false){

                public void execute() {
                    ((MiningMartApplication)MiningMartMenuBar.this.parent).promptOpen(this.name(), true);
                }
            };
            this.recentFiles.add(cmd);
        }
    }

    public void initItemStates() {
        this.setItemState(Resource.getString("MENU_CASE") + "." + Resource.getString("MENU_CASE_MODE"), false);
        this.setItemState(Resource.getString("MENU_CASE") + "." + Resource.getString("MENU_CASE_EXPORT"), false);
        this.setItemState(Resource.getString("MENU_CASE") + "." + Resource.getString("MENU_CASE_SAVE"), false);
        this.setItemState(Resource.getString("MENU_CASE") + "." + Resource.getString("MENU_CASE_CLOSE"), false);
        this.setItemState(Resource.getString("MENU_EDIT") + "." + Resource.getString("MENU_EDIT_CUT"), false);
        this.setItemState(Resource.getString("MENU_EDIT") + "." + Resource.getString("MENU_EDIT_COPY"), false);
        this.setItemState(Resource.getString("MENU_EDIT") + "." + Resource.getString("MENU_EDIT_PASTE"), false);
        this.setItemState(Resource.getString("MENU_EDIT") + "." + Resource.getString("MENU_EDIT_DELETE"), false);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_VALIDATE"), false);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_VALIDATE_ALL"), false);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_ALL"), false);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_FROM_SELECTED"), false);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_UNTIL_SELECTED"), false);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_STEP"), false);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_LAZY"), false);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_TOOLS_GARBAGE"), false);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_KILL"), false);
        this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_CONCEPT"), false);
        this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_RELATION"), false);
        this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_SUBCONCEPT"), false);
        this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_SUBRELATION"), false);
        this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_CONCEPTFROMCASE"), false);
        this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_CONCEPTFROMTABLE"), false);
        this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_CHAIN"), false);
        this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_MERGE_CHAIN"), false);
        this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_UNMERGE_CHAIN"), false);
        this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_TRANSITION"), false);
        this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_ALL_TRANSITIONS"), false);
        this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_SHOW_STEPSETTINGS"), false);
        this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_OPERATORS"), false);
        this.setItemState(Resource.getString("MENU_TOOLS") + "." + Resource.getString("MENU_TOOLS_GARBAGE"), false);
        compileMode.setEnabled(false);
        this.show_annotations.setEnabled(false);
        this.show_tools.setEnabled(false);
        this.switchmode.setEnabled(false);
    }

    public void promptStartCompilationItemStates() {
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_ALL"), false);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_FROM_SELECTED"), false);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_UNTIL_SELECTED"), false);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_STEP"), false);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_LAZY"), false);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_KILL"), true);
    }

    public void promptDoneCompilationItemStates() {
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_ALL"), true);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_FROM_SELECTED"), true);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_UNTIL_SELECTED"), true);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_STEP"), true);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_LAZY"), true);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_KILL"), false);
    }

    public void promptOpenItemStates() {
        this.setItemState(Resource.getString("MENU_CASE") + "." + Resource.getString("MENU_CASE_CLOSE"), true);
        this.setItemState(Resource.getString("MENU_CASE") + "." + Resource.getString("MENU_CASE_EXPORT"), true);
        this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_ALL_TRANSITIONS"), true);
        this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_SHOW_STEPSETTINGS"), true);
        this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_TOOLS_GARBAGE"), true);
        this.show_annotations.setEnabled(true);
        this.switchmode.setEnabled(true);
        if (this.app.getViewMode() == 0) {
            this.show_tools.setEnabled(true);
            this.setItemState(Resource.getString("MENU_CASE") + "." + Resource.getString("MENU_CASE_MODE"), true);
            this.setItemState(Resource.getString("MENU_EDIT") + "." + Resource.getString("MENU_EDIT_CUT"), true);
            this.setItemState(Resource.getString("MENU_EDIT") + "." + Resource.getString("MENU_EDIT_COPY"), true);
            this.setItemState(Resource.getString("MENU_EDIT") + "." + Resource.getString("MENU_EDIT_PASTE"), true);
            this.setItemState(Resource.getString("MENU_EDIT") + "." + Resource.getString("MENU_EDIT_DELETE"), true);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_CONCEPT"), true);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_RELATION"), true);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_SUBCONCEPT"), true);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_SUBRELATION"), true);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_CONCEPTFROMCASE"), true);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_CONCEPTFROMTABLE"), true);
            this.setItemState(Resource.getString("MENU_TOOLS") + "." + Resource.getString("MENU_TOOLS_GARBAGE"), true);
            compileMode.setEnabled(true);
        }
        this.promptSwitchEditor();
    }

    public void promptNewItemStates() {
        this.promptOpenItemStates();
    }

    public void promptCloseItemStates() {
        this.initItemStates();
    }

    public void promptSwitchEditor() {
        if (this.app.getEditorMode() == 0) {
            this.caseeditor.setSelected(true);
            this.concepteditor.setSelected(false);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_ALL_TRANSITIONS"), true);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_SHOW_STEPSETTINGS"), true);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_CONCEPT"), false);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_RELATION"), false);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_SUBCONCEPT"), false);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_SUBRELATION"), false);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_CONCEPTFROMCASE"), false);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_CONCEPTFROMTABLE"), false);
            if (this.app.getViewMode() == 0) {
                this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_CHAIN"), true);
                this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_MERGE_CHAIN"), true);
                this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_UNMERGE_CHAIN"), true);
                this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_TRANSITION"), true);
                this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_OPERATORS"), true);
                this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_VALIDATE"), true);
                this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_VALIDATE_ALL"), true);
                this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_ALL"), true);
                this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_FROM_SELECTED"), true);
                this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_UNTIL_SELECTED"), true);
                this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_STEP"), true);
                this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_LAZY"), true);
                this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_KILL"), false);
            }
        } else {
            this.caseeditor.setSelected(false);
            this.concepteditor.setSelected(true);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_ALL_TRANSITIONS"), false);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_SHOW_STEPSETTINGS"), false);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_CHAIN"), false);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_MERGE_CHAIN"), false);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_UNMERGE_CHAIN"), false);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_INSERT_TRANSITION"), false);
            this.setItemState(Resource.getString("MENU_INSERT") + "." + Resource.getString("MENU_OPERATORS"), false);
            this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_VALIDATE"), false);
            this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_VALIDATE_ALL"), false);
            this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_ALL"), false);
            this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_FROM_SELECTED"), false);
            this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_UNTIL_SELECTED"), false);
            this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_STEP"), false);
            this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_LAZY"), false);
            this.setItemState(Resource.getString("MENU_COMPILE") + "." + Resource.getString("MENU_COMPILE_KILL"), false);
            if (this.app.getViewMode() == 0) {
                // empty if block
            }
        }
    }

    protected JMenu createCaseMenu() {
        Iconkit kit = Iconkit.instance();
        IconCommandMenu menu = new IconCommandMenu(Resource.getString("MENU_CASE"));
        menu.setMnemonic(Resource.getChar("MENUM_CASE"));
        AbstractCommand cmd = new AbstractCommand(Resource.getString("MENU_CASE_NEW"), this.parent, false){

            public void execute() {
                MiningMartMenuBar.this.parent.promptNew();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_CASE_NEW")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_CASE_NEW"))));
        cmd = new AbstractCommand(Resource.getString("MENU_CASE_OPEN"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).promptOpen(null, true);
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_CASE_OPEN")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_CASE_OPEN"))));
        menu.add(this.recentFiles);
        cmd = new AbstractCommand(Resource.getString("MENU_CASE_MODE"), this.parent, true){

            public void execute() {
                MiningMartMenuBar.this.app.promptSetMode();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_CASE_MODE")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_CASE_MODE"))));
        this.switchmode = new JMenu(Resource.getString("MENU_CASE_SWITCH_EDITOR"));
        menu.add(this.switchmode);
        ButtonGroup group = new ButtonGroup();
        this.caseeditor = new JRadioButtonMenuItem(Resource.getString("COMP_CASEEDITOR"));
        this.caseeditor.setMnemonic(Resource.getChar("MENUM_CASE_SWITCH_CASEEDITOR"));
        this.concepteditor = new JRadioButtonMenuItem(Resource.getString("COMP_CONCEPTEDITOR"));
        this.concepteditor.setMnemonic(Resource.getChar("MENUM_CASE_SWITCH_CONCEPTEDITOR"));
        this.caseeditor.addActionListener(new RadioButtonListener(this.caseeditor){

            public void actionPerformed(ActionEvent event) {
                MiningMartMenuBar.this.app.saveModel();
                String casename = MiningMartMenuBar.this.app.getModel().getName();
                if (MiningMartMenuBar.this.app.getEditorMode() == 1) {
                    casename = M4Interface.getCurrentCase().getName();
                }
                boolean editing = MiningMartMenuBar.this.app.getViewMode() == 0;
                MiningMartApplication.keepCase = true;
                MiningMartMenuBar.this.app.promptClose();
                MiningMartMenuBar.this.app.setEditorMode(0);
                MiningMartMenuBar.this.app.promptOpen(casename, editing);
                MiningMartApplication.keepCase = false;
            }
        });
        this.concepteditor.addActionListener(new RadioButtonListener(this.concepteditor){

            public void actionPerformed(ActionEvent event) {
                boolean editing;
                MiningMartMenuBar.this.app.saveModel();
                String casename = MiningMartMenuBar.this.app.getModel().getName();
                boolean bl = editing = MiningMartMenuBar.this.app.getViewMode() == 0;
                if (MiningMartMenuBar.this.app.getEditorMode() == 1) {
                    casename = M4Interface.getCurrentCase().getName();
                }
                MiningMartApplication.keepCase = true;
                MiningMartMenuBar.this.app.promptClose();
                MiningMartMenuBar.this.app.setEditorMode(1);
                MiningMartMenuBar.this.app.promptOpen(casename, editing);
                MiningMartApplication.keepCase = false;
            }
        });
        group.add(this.caseeditor);
        group.add(this.concepteditor);
        this.caseeditor.setSelected(true);
        this.switchmode.add(this.caseeditor);
        this.switchmode.add(this.concepteditor);
        menu.addSeparator();
        cmd = new AbstractCommand(Resource.getString("MENU_CASE_SAVE"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).saveModel();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_CASE_SAVE")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_CASE_SAVE"))));
        cmd = new AbstractCommand(Resource.getString("MENU_CASE_IMPORT"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).importCase();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_CASE_IMPORT")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_CASE_IMPORT"))));
        cmd = new AbstractCommand(Resource.getString("MENU_CASE_EXPORT"), this.parent, true){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).exportCase();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_CASE_EXPORT")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_CASE_EXPORT"))));
        cmd = new AbstractCommand(Resource.getString("MENU_CASE_PRINT"), this.parent, true){

            public void execute() {
                MiningMartMenuBar.this.parent.promptPrint(true);
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_CASE_PRINT")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_CASE_PRINT"))));
        cmd = new AbstractCommand(Resource.getString("MENU_CASE_EXPORT_IMAGE"), this.parent, true){

            public void execute() {
                MiningMartMenuBar.this.parent.promptExport();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_CASE_EXPORT_IMAGE")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_CASE_EXPORT_IMAGE"))));
        menu.addSeparator();
        cmd = new AbstractCommand(Resource.getString("MENU_CASE_DELETE"), this.parent, true){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).promptDeleteCase();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_CASE_DELETE")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_CASE_DELETE"))));
        cmd = new AbstractCommand(Resource.getString("MENU_CASE_CLOSE"), this.parent, true){

            public void execute() {
                MiningMartMenuBar.this.parent.promptClose();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_CASE_CLOSE")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_CASE_CLOSE"))));
        cmd = new AbstractCommand(Resource.getString("MENU_CASE_EXIT"), this.parent, true){

            public void execute() {
                MiningMartMenuBar.this.parent.exit();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_CASE_EXIT")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_CASE_EXIT"))));
        return menu;
    }

    public JMenu createEditMenu() {
        Iconkit kit = Iconkit.instance();
        IconCommandMenu menu = new IconCommandMenu(Resource.getString("MENU_EDIT"));
        menu.setMnemonic(Resource.getChar("MENUM_EDIT"));
        AbstractCommand cmd = new AbstractCommand(Resource.getString("MENU_EDIT_CUT"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).showHelp();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_EDIT_CUT")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_EDIT_CUT"))));
        cmd = new AbstractCommand(Resource.getString("MENU_EDIT_COPY"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).showHelp();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_EDIT_COPY")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_EDIT_COPY"))));
        cmd = new AbstractCommand(Resource.getString("MENU_EDIT_PASTE"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).showHelp();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_EDIT_PASTE")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_EDIT_PASTE"))));
        cmd = new AbstractCommand(Resource.getString("MENU_EDIT_DELETE"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).showHelp();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_EDIT_DELETE")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_EDIT_DELETE"))));
        return menu;
    }

    public JMenu createWindowMenu() {
        Iconkit kit = Iconkit.instance();
        IconCommandMenu menu = new IconCommandMenu(Resource.getString("MENU_WINDOW"));
        IconCommandMenu submenu1 = new IconCommandMenu(Resource.getString("MENU_WINDOW_GRID"));
        menu.add(submenu1);
        AbstractCommand gridCmd1 = new AbstractCommand(Resource.getString("MENU_WINDOW_GRID_ON"), this.parent){

            public void execute() {
                MiningMartMenuBar.this.parent.getMainPane().setGrid(true);
            }
        };
        submenu1.add(gridCmd1, new MenuShortcut(Resource.getChar("MENUM_WINDOW_GRID_ON")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_WINDOW_GRID_ON"))));
        AbstractCommand gridCmd2 = new AbstractCommand(Resource.getString("MENU_WINDOW_GRID_OFF"), this.parent){

            public void execute() {
                MiningMartMenuBar.this.parent.getMainPane().setGrid(false);
            }
        };
        submenu1.add(gridCmd2, new MenuShortcut(Resource.getChar("MENUM_WINDOW_GRID_OFF")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_WINDOW_GRID_OFF"))));
        IconCommandMenu submenu = new IconCommandMenu(Resource.getString("Look'n'Feel"));
        menu.add(submenu);
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lafs.length; ++i) {
            final String lnfClassName = lafs[i].getClassName();
            AbstractCommand cmd = new AbstractCommand(lafs[i].getName(), this.parent, false){

                public void execute() {
                    try {
                        UIManager.setLookAndFeel(lnfClassName);
                        SwingUtilities.updateComponentTreeUI(MiningMartMenuBar.this.parent);
                    }
                    catch (Exception e) {
                        M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
                    }
                }
            };
            submenu.add(cmd);
        }
        JMenu showmenu = new JMenu(Resource.getString("MENU_WINDOW_SHOW"));
        menu.add(showmenu);
        this.show_annotations = new JCheckBoxMenuItem(Resource.getString("MENU_WINDOW_SHOW_ANNOTATIONS"));
        this.show_annotations.addActionListener(new CheckBoxListener(this.show_annotations){

            public void actionPerformed(ActionEvent event) {
                if (this.box.isSelected()) {
                    MiningMartMenuBar.this.app.showAnnotations();
                } else {
                    MiningMartMenuBar.this.app.removeAnnotations();
                }
            }
        });
        this.show_annotations.setMnemonic(Resource.getChar("MENUM_WINDOW_SHOW_ANNOTATIONS"));
        showmenu.add(this.show_annotations);
        this.show_help = new JCheckBoxMenuItem(Resource.getString("MENU_WINDOW_SHOW_HELP"));
        this.show_help.addActionListener(new CheckBoxListener(this.show_help){

            public void actionPerformed(ActionEvent event) {
                if (this.box.isSelected()) {
                    MiningMartMenuBar.this.app.showHelp();
                } else {
                    MiningMartMenuBar.this.app.removeHelp();
                }
            }
        });
        this.show_help.setMnemonic(Resource.getChar("MENUM_WINDOW_SHOW_HELP"));
        showmenu.add(this.show_help);
        this.show_tools = new JCheckBoxMenuItem(Resource.getString("MENU_WINDOW_SHOW_TOOLS"));
        this.show_tools.addActionListener(new CheckBoxListener(this.show_tools){

            public void actionPerformed(ActionEvent event) {
                if (MiningMartMenuBar.this.app.getEditorMode() == 0) {
                    if (this.box.isSelected()) {
                        MiningMartMenuBar.this.app.showOperatorTools();
                    } else {
                        MiningMartMenuBar.this.app.removeOperatorTools();
                    }
                } else if (this.box.isSelected()) {
                    MiningMartMenuBar.this.app.showConceptTools();
                } else {
                    MiningMartMenuBar.this.app.removeConceptTools();
                }
            }
        });
        this.show_tools.setMnemonic(Resource.getChar("MENUM_WINDOW_SHOW_TOOLS"));
        showmenu.add(this.show_tools);
        JMenuItem cmd = new JMenuItem(Resource.getString("MENU_WINDOW_PRESENTATION"));
        cmd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MiningMartMenuBar.this.parent.setViewMode(2);
            }
        });
        cmd.setMnemonic(Resource.getChar("MENUM_WINDOW_PRESENTATION"));
        cmd.setIcon(new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_PRESENTATION"))));
        menu.add(cmd);
        menu.addSeparator();
        cmd = new JMenuItem(Resource.getString("MENU_WINDOW_PREFERENCES"));
        cmd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesFrame prefframe = new PreferencesFrame(MiningMartMenuBar.this.app, Resource.getString("WINDOW_PREFERENCES"));
                OperatorPreferencesPanel prefpanel = new OperatorPreferencesPanel(MiningMartMenuBar.this.app);
                VerbosityPreferencesPanel prefpanel2 = new VerbosityPreferencesPanel();
                ConceptEditorPreferencesPanel prefpanel3 = new ConceptEditorPreferencesPanel(MiningMartMenuBar.this.app);
                prefframe.addPreferencePanel(Resource.getString("COMP_OPERATORTOOLS"), prefpanel);
                prefframe.addPreferencePanel(Resource.getString("PREFERENCES_VERBOSITY"), prefpanel2);
                prefframe.addPreferencePanel(Resource.getString("PREFERENCES_CONCEPTEDITOR"), prefpanel3);
                prefframe.setSize(600, 500);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension WindowSize = prefframe.getSize();
                prefframe.setLocation((screenSize.width - WindowSize.width) / 2, (screenSize.height - WindowSize.height) / 2);
                prefframe.setVisible(true);
            }
        });
        cmd.setMnemonic(Resource.getChar("MENUM_WINDOW_PREFERENCES"));
        cmd.setIcon(new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_PREFERENCES"))));
        menu.add(cmd);
        return menu;
    }

    public JMenu createHelpMenu() {
        Iconkit kit = Iconkit.instance();
        IconCommandMenu menu = new IconCommandMenu(Resource.getString("MENU_HELP"));
        menu.setMnemonic(Resource.getChar("MENUM_HELP"));
        AbstractCommand cmd = new AbstractCommand(Resource.getString("MENU_HELP_CONTENTS"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).showHelp();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_HELP_CONTENTS")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_HELP_CONTENTS"))));
        cmd = new AbstractCommand(Resource.getString("MENU_HELP_MMART"), this.parent, false){

            public void execute() {
                MiningMartMenuBar.this.parent.openURLInBrowser(Resource.getString("URL_MMART"));
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_HELP_MMART")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_HELP_MMART"))));
        cmd = new AbstractCommand(Resource.getString("MENU_HELP_ABOUT"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).showAboutDialog();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_HELP_ABOUT")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_HELP_ABOUT"))));
        return menu;
    }

    public JMenu createCompileMenu() {
        Iconkit kit = Iconkit.instance();
        IconCommandMenu menu = new IconCommandMenu(Resource.getString("MENU_COMPILE"));
        menu.setMnemonic(Resource.getChar("MENUM_COMPILE"));
        AbstractCommand cmd = new AbstractCommand(Resource.getString("MENU_COMPILE_ALL"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).compileAll();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_COMPILE_ALL")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_COMPILE_ALL"))));
        cmd = new AbstractCommand(Resource.getString("MENU_COMPILE_FROM_SELECTED"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).compileFrom();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_COMPILE_FROM_SELECTED")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_COMPILE_FROM_SELECTED"))));
        cmd = new AbstractCommand(Resource.getString("MENU_COMPILE_UNTIL_SELECTED"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).compileUntil();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_COMPILE_UNTIL_SELECTED")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_COMPILE_UNTIL_SELECTED"))));
        cmd = new AbstractCommand(Resource.getString("MENU_COMPILE_STEP"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).compileStep();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_COMPILE_STEP")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_COMPILE_STEP"))));
        menu.addSeparator();
        cmd = new AbstractCommand(Resource.getString("MENU_TOOLS_GARBAGE"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).collectGarbage();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_TOOLS_GARBAGE")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_TOOLS_GARBAGE"))));
        menu.addSeparator();
        compileMode = new JCheckBoxMenuItem(Resource.getString("MENU_COMPILE_LAZY"));
        compileMode.setSelected(MiningMartApplication.compileLazy);
        compileMode.addActionListener(new CheckBoxListener(compileMode){

            public void actionPerformed(ActionEvent event) {
                MiningMartApplication.compileLazy = this.box.isSelected();
            }
        });
        compileMode.setMnemonic(Resource.getChar("MENUM_COMPILE_LAZY"));
        menu.add(compileMode);
        menu.addSeparator();
        cmd = new AbstractCommand(Resource.getString("MENU_COMPILE_KILL"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).killCompilation();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_COMPILE_KILL")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_COMPILE_KILL"))));
        return menu;
    }

    public JMenu createToolsMenu() {
        Iconkit kit = Iconkit.instance();
        IconCommandMenu menu = new IconCommandMenu(Resource.getString("MENU_TOOLS"));
        menu.setMnemonic(Resource.getChar("MENUM_TOOLS"));
        AbstractCommand cmd = new AbstractCommand(Resource.getString("MENU_TOOLS_DBSETTINGS"), this.parent, false){

            public void execute() {
                MiningMartMenuBar.this.app.promptEditDbSettings();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_TOOLS_DBSETTINGS")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_TOOLS_DBSETTINGS"))));
        return menu;
    }

    public JMenu createInsertMenu() {
        Iconkit kit = Iconkit.instance();
        IconCommandMenu menu = new IconCommandMenu(Resource.getString("MENU_INSERT"));
        menu.setMnemonic(Resource.getChar("MENUM_INSERT"));
        AbstractCommand cmd = new AbstractCommand(Resource.getString("MENU_INSERT_CONCEPT"), this.parent, false){

            public void execute() {
                NewConceptDialog dialog;
                Point point = MiningMartMenuBar.this.app.getPointforConcept();
                int x = point.x;
                int y = point.y;
                ModelFigureElement p = MiningMartMenuBar.this.app.getPotentialParent(x, y);
                MiningMartConcept s = null;
                if (p instanceof MiningMartConcepts) {
                    dialog = new NewConceptDialog(MiningMartMenuBar.this.app);
                    if (dialog.getExitAction() == dialog.CANCEL) {
                        MiningMartMenuBar.this.parent.toolDone();
                        return;
                    }
                } else {
                    MiningMartMenuBar.this.parent.toolDone();
                    return;
                }
                s = ((MiningMartConcepts)p).createMiningMartConcept(p, dialog.getNewConceptName(), new Point(x, y), dialog.getConceptType());
                MiningMartMenuBar.this.parent.toolDone();
                if (s != null) {
                    MiningMartMenuBar.this.parent.selectFigure(s);
                    M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("INSERTED_NEW_CONCEPT") + " " + s.getName());
                }
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_INSERT_CONCEPT")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_INSERT_CONCEPT"))));
        cmd = new AbstractCommand(Resource.getString("MENU_INSERT_CONCEPTFROMTABLE"), this.parent, false){

            public void execute() {
                ConceptFromTableDialog dialog = new ConceptFromTableDialog(MiningMartMenuBar.this.app);
                if (dialog.getExitAction() == dialog.OK) {
                    String tablename = dialog.getTableName();
                    try {
                        Concept concept = M4Interface.getCurrentCase().createConceptFromTable(tablename);
                        MiningMartConcepts concepts = MiningMartMenuBar.this.app.getMiningMartConcepts();
                        concepts.createMiningMartConcept(concepts, concept, MiningMartMenuBar.this.app.getPointforConcept());
                    }
                    catch (M4Exception error) {
                        M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                    }
                }
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_INSERT_CONCEPTFROMTABLE")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_INSERT_CONCEPTFROMTABLE"))));
        cmd = new AbstractCommand(Resource.getString("MENU_INSERT_CONCEPTFROMCASE"), this.parent, false){

            public void execute() {
                ConceptFromCaseDialog dialog = new ConceptFromCaseDialog(MiningMartMenuBar.this.app);
                if (dialog.getExitAction() == dialog.OK) {
                    Case thecase = dialog.getTheCase();
                    String conceptname = dialog.getConceptName();
                    try {
                        Concept concept = thecase.getConcept(conceptname);
                        Concept newconcept = concept.copy(M4Interface.getCurrentCase());
                        MiningMartMenuBar.this.app.saveModel();
                        newconcept = M4Interface.getCurrentCase().getConcept(conceptname);
                        MiningMartConcepts concepts = MiningMartMenuBar.this.app.getMiningMartConcepts();
                        concepts.createMiningMartConcept(concepts, newconcept, MiningMartMenuBar.this.app.getPointforConcept());
                        MiningMartApplication.m4Interface.releaseCaseWithoutStoring(thecase.getName());
                    }
                    catch (M4Exception error) {
                        M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                    }
                }
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_INSERT_CONCEPTFROMCASE")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_INSERT_CONCEPTFROMCASE"))));
        menu.addSeparator();
        IconCommandMenu chain = new IconCommandMenu(Resource.getString("MENU_INSERT_CHAIN"));
        cmd = new AbstractCommand(Resource.getString("MENU_INSERT_CHAIN"), this.parent, false){

            public void execute() {
                Point point = MiningMartMenuBar.this.app.getPointforOperator();
                int x = point.x;
                int y = point.y;
                ModelFigureElement p = MiningMartMenuBar.this.app.getPotentialParent(x, y);
                if (!(p instanceof Model)) {
                    return;
                }
                MiningMartChain s = null;
                if (p instanceof MiningMartCase) {
                    s = ((MiningMartCase)p).createMiningMartChain(p, Resource.getString("CHAIN"), point, new Rectangle(x, y, 35, 35));
                } else if (p instanceof MiningMartChain) {
                    s = ((MiningMartChain)p).createMiningMartChain(p, Resource.getString("CHAIN"), point, new Rectangle(x, y, 35, 35));
                }
                MiningMartMenuBar.this.parent.toolDone();
                if (s != null) {
                    MiningMartMenuBar.this.parent.selectFigure(s);
                }
                M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("INSERTED_NEW_CHAIN") + " " + s.getName());
            }
        };
        chain.add(cmd, new MenuShortcut(Resource.getChar("MENUM_INSERT_CHAIN")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_INSERT_NEW_CHAIN"))));
        cmd = new AbstractCommand(Resource.getString("MENU_INSERT_MERGE_CHAIN"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).promptMergeChain();
            }
        };
        chain.add(cmd, new MenuShortcut(Resource.getChar("MENUM_INSERT_MERGE_CHAIN")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_INSERT_MERGE_CHAIN"))));
        cmd = new AbstractCommand(Resource.getString("MENU_INSERT_UNMERGE_CHAIN"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).promptUnmergeChain();
            }
        };
        chain.add(cmd, new MenuShortcut(Resource.getChar("MENUM_INSERT_UNMERGE_CHAIN")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_INSERT_UNMERGE_CHAIN"))));
        menu.add(chain);
        cmd = new AbstractCommand(Resource.getString("MENU_INSERT_TRANSITION"), this.parent, false){

            public void execute() {
                int index;
                FigureEnumeration figureEnumeration = MiningMartMenuBar.this.app.getMainPane().getDrawingView().selection();
                ModelFigureElement[] elements = new ModelFigureElement[2];
                for (index = 0; figureEnumeration.hasNextFigure() && index < 2; ++index) {
                    elements[index] = ((ModelFigure)figureEnumeration.nextFigure()).getElement();
                }
                if (index != 2) {
                    return;
                }
                Model parentmodel = elements[0].getModel();
                StepTransition trans = null;
                boolean existstrans = false;
                for (int c = 0; c < parentmodel.getConnectionCount() && !existstrans; ++c) {
                    StepTransition exists = (StepTransition)parentmodel.getConnection(c);
                    if (!exists.getStart().getName().equals(elements[0].getName()) || !exists.getEnd().getName().equals(elements[1].getName())) continue;
                    existstrans = true;
                }
                if (parentmodel instanceof MiningMartCase) {
                    trans = ((MiningMartCase)parentmodel).createTransition(null, elements[0], elements[1], existstrans);
                    trans.setMMartApplication(((MiningMartCase)parentmodel).getMMartApplication());
                    ((MiningMartCase)parentmodel).addStepTransition(trans);
                } else if (parentmodel instanceof MiningMartChain) {
                    trans = ((MiningMartChain)parentmodel).createTransition(null, elements[0], elements[1], existstrans);
                    trans.setMMartApplication(((MiningMartChain)parentmodel).getMMartApplication());
                    ((MiningMartChain)parentmodel).addStepTransition(trans);
                }
                M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("CREATED_NEW_TRANSITION") + " " + trans.getName());
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_INSERT_TRANSITION")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_INSERT_TRANSITION"))));
        cmd = new AbstractCommand(Resource.getString("MENU_INSERT_ALL_TRANSITIONS"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).promptShowAllTransitions();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_INSERT_ALL_TRANSITIONS")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_INSERT_ALL_TRANSITIONS"))));
        menu.addSeparator();
        cmd = new AbstractCommand(Resource.getString("MENU_INSERT_SHOW_STEPSETTINGS"), this.parent, false){

            public void execute() {
                ((MiningMartApplication)MiningMartMenuBar.this.parent).showStepSettings();
            }
        };
        menu.add(cmd, new MenuShortcut(Resource.getChar("MENUM_INSERT_SHOW_STEPSETTINGS")), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_INSERT_SHOW_STEPSETTINGS"))));
        this.operatorsmenu = this.createOperatorMenu();
        menu.add(this.createOperatorMenu());
        return menu;
    }

    public IconCommandMenu getOperatorsMenu() {
        return this.operatorsmenu;
    }

    public IconCommandMenu createOperatorMenu() {
        Iconkit kit = Iconkit.instance();
        IconCommandMenu menu = new IconCommandMenu(Resource.getString("MENU_OPERATORS"));
        menu = this.getOpGroups(menu);
        return menu;
    }

    private IconCommandMenu getOpGroups(IconCommandMenu topLevel) {
        M4Interface m4i = M4Interface.getInstance();
        if (m4i != null) {
            OperatorGroup opg = m4i.getOperatorGroup();
            Collection c = opg.getTopLevelOperatorGroups();
            if (c == null || c.isEmpty()) {
                System.err.println("Fatal error: no operator groups found in M4 schema.");
                System.exit(-1);
            }
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Long opgId = (Long)it.next();
                try {
                    topLevel.add(this.recurseThroughInsertOps(opgId, opg));
                }
                catch (M4Exception e) {
                    M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
                    return null;
                }
            }
        }
        return topLevel;
    }

    private IconCommandMenu recurseThroughInsertOps(Long opGroupId, OperatorGroup opg) throws M4Exception {
        String name = opg.getGroupName(opGroupId);
        IconCommandMenu cclist = this.getInsertItemFolder(name);
        Collection col = opg.getChildGroups(opGroupId);
        if (col != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                Long idNext = (Long)it.next();
                Collection down = opg.getChildGroups(idNext);
                if (down != null) {
                    cclist.add(this.recurseThroughInsertOps(idNext, opg));
                    continue;
                }
                Operator op = opg.getOperator(idNext);
                if (op == null) continue;
                String opName = op.getName();
                AbstractCommand cmd = this.getInsertItemForOperator(opName);
                cclist.add(cmd, this.getMenuShortCutForOperator(opName), this.getImageIconForOperator(opName));
            }
        }
        return cclist;
    }

    private ImageIcon getImageIconForOperator(String opName) {
        Iconkit kit = Iconkit.instance();
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_OP_" + opName.toUpperCase())));
        }
        catch (NullPointerException e) {
            icon = new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_OP_GENERICOPERATOR")));
        }
        return icon;
    }

    private MenuShortcut getMenuShortCutForOperator(String opName) {
        return new MenuShortcut(Resource.getChar("MENUM_OP_" + opName.toUpperCase()));
    }

    private IconCommandMenu getInsertItemFolder(String name) {
        IconCommandMenu subList = new IconCommandMenu(name);
        return subList;
    }

    private AbstractCommand getInsertItemForOperator(String operatorName) {
        AbstractCommand compItem = new AbstractCommand(operatorName, this.parent, false){

            public void execute() {
                Point point = MiningMartMenuBar.this.app.getPointforOperator();
                int x = point.x;
                int y = point.y;
                ModelFigureElement p = MiningMartMenuBar.this.app.getPotentialParent(x, y);
                if (!(p instanceof Model)) {
                    M4Interface.print.doPrint(Print.ERROR, "The potential parent must be a model!");
                    return;
                }
                MiningMartStep s = null;
                if (p instanceof MiningMartChain) {
                    s = ((MiningMartChain)p).createMiningMartStep(p, this.name(), point, new Rectangle(x, y, 35, 35));
                }
                MiningMartMenuBar.this.parent.toolDone();
                if (s != null) {
                    MiningMartMenuBar.this.parent.selectFigure(s);
                    M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("INSERTED_OPERATOR") + " " + s.getName());
                }
            }
        };
        return compItem;
    }

    private class RadioButtonListener
    implements ActionListener {
        private JRadioButtonMenuItem button;

        public RadioButtonListener(JRadioButtonMenuItem button) {
            this.button = button;
        }

        public void actionPerformed(ActionEvent event) {
        }
    }

    private class CheckBoxListener
    implements ActionListener {
        public JCheckBoxMenuItem box;

        public CheckBoxListener(JCheckBoxMenuItem box) {
            this.box = box;
        }

        public void actionPerformed(ActionEvent event) {
        }
    }
}

