/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.figures.ChainFigure;
import edu.udo.cs.miningmart.gui.figures.ConceptFigure;
import edu.udo.cs.miningmart.gui.figures.FeatureFigure;
import edu.udo.cs.miningmart.gui.figures.ProjectionFigure;
import edu.udo.cs.miningmart.gui.figures.RelationFigure;
import edu.udo.cs.miningmart.gui.figures.StepFigure;
import edu.udo.cs.miningmart.gui.figures.SubConceptFigure;
import edu.udo.cs.miningmart.gui.figures.TransitionFigure;
import edu.udo.cs.miningmart.gui.model.MiningMartBaseAttribute;
import edu.udo.cs.miningmart.gui.model.MiningMartCase;
import edu.udo.cs.miningmart.gui.model.MiningMartChain;
import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.gui.model.MiningMartConcepts;
import edu.udo.cs.miningmart.gui.model.MiningMartMultiColumnFeature;
import edu.udo.cs.miningmart.gui.model.MiningMartProjection;
import edu.udo.cs.miningmart.gui.model.MiningMartRelation;
import edu.udo.cs.miningmart.gui.model.MiningMartStep;
import edu.udo.cs.miningmart.gui.model.MiningMartSubConcept;
import edu.udo.cs.miningmart.gui.model.StepTransition;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.util.Vector;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelListener;

public class MiningMartDrawing
extends ModelDrawing
implements ModelListener {
    private MiningMartApplication application;
    private Vector activeElements = new Vector();

    public MiningMartDrawing(MiningMartApplication app, MiningMartCase root) {
        super(root);
        this.application = app;
    }

    public MiningMartDrawing(MiningMartApplication app, MiningMartChain root) {
        super(root);
        this.application = app;
    }

    public MiningMartDrawing(MiningMartApplication app, MiningMartConcepts root) {
        super(root);
        this.application = app;
    }

    public void onCreateChild(ModelFigureElement sender, ModelElement child) {
        Model model = this.getModel();
        if (child instanceof MiningMartStep && model instanceof MiningMartChain) {
            this.add(new StepFigure((MiningMartStep)child, this));
            this.invalidate();
        } else if (child instanceof MiningMartChain && model instanceof Model) {
            this.add(new ChainFigure((MiningMartChain)child, (ModelDrawing)this));
            this.invalidate();
        } else if (child instanceof MiningMartConcept && model instanceof MiningMartConcepts) {
            this.add(new ConceptFigure((MiningMartConcept)child, this));
            this.invalidate();
        } else if (child instanceof MiningMartBaseAttribute && sender instanceof MiningMartConcept) {
            this.add(new FeatureFigure((MiningMartBaseAttribute)child, (ModelDrawing)this));
            this.invalidate();
        } else if (child instanceof MiningMartMultiColumnFeature && sender instanceof MiningMartConcept) {
            this.add(new FeatureFigure((MiningMartMultiColumnFeature)child, (ModelDrawing)this));
            this.invalidate();
        }
    }

    public void onCreateConnection(Model model, ModelConnectionElement connection) {
        if (connection instanceof StepTransition) {
            try {
                TransitionFigure figure = new TransitionFigure(this, connection);
                this.add(figure);
                figure.updateConnection();
                figure.setLabelPosition(0);
                if (figure.getLabel() != null) {
                    figure.setLabelPosition(16);
                }
            }
            catch (Exception e) {
                M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
            }
        } else if (connection instanceof MiningMartSubConcept) {
            try {
                SubConceptFigure figure = new SubConceptFigure(this, connection);
                this.add(figure);
                figure.updateConnection();
                figure.setLabelPosition(0);
            }
            catch (Exception e) {
                M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
            }
        } else if (connection instanceof MiningMartRelation) {
            try {
                RelationFigure figure = new RelationFigure(this, connection);
                this.add(figure);
                figure.updateConnection();
                figure.setLabelPosition(0);
                if (figure.getLabel() != null) {
                    figure.setLabelPosition(16);
                }
            }
            catch (Exception e) {
                M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
            }
        } else if (connection instanceof MiningMartProjection) {
            try {
                ProjectionFigure figure = new ProjectionFigure(this, connection);
                this.add(figure);
                figure.updateConnection();
                figure.setLabelPosition(0);
                if (figure.getLabel() != null) {
                    figure.setLabelPosition(16);
                }
            }
            catch (Exception e) {
                M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
            }
        }
    }

    public void onDestroy(ModelElement sender) {
        if (this.application.getViewMode() == 0) {
            super.onDestroy(sender);
        }
    }
}

