/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.model.MiningMartChain;
import edu.udo.cs.miningmart.gui.model.MiningMartStep;
import edu.udo.cs.miningmart.m4.Chain;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.ModelFigureElement;

public class ExistingTransitionsDialog
extends JDialog
implements ActionListener {
    public static final int OK = 0;
    private JButton ok;
    private JList fromlist;
    private JList tolist;
    private Chain fromchain;
    private Chain tochain;
    private Step fromstep;
    private Step tostep;
    private Step[] fromsteps;
    private Step[] tosteps;
    private String[] fromstepnames;
    private String[] tostepnames;
    private boolean chaintochain = false;
    private boolean chaintostep = false;
    private boolean steptochain = false;
    private boolean steptostep = false;
    private int exitAction = 0;
    private ModelFigureElement start;
    private ModelFigureElement end;

    public ExistingTransitionsDialog(MiningMartApplication parent, ModelFigureElement start, ModelFigureElement end) {
        super(parent, Resource.getString("SHOW_ALL_TRANSITIONS"), true);
        this.start = start;
        this.end = end;
        if (start instanceof MiningMartChain) {
            this.fromchain = ((MiningMartChain)start).getChain();
            if (end instanceof MiningMartChain) {
                this.tochain = ((MiningMartChain)end).getChain();
                this.chaintochain = true;
            }
            if (end instanceof MiningMartStep) {
                this.tostep = ((MiningMartStep)end).getStep();
                this.chaintostep = true;
            }
        }
        if (start instanceof MiningMartStep) {
            this.fromstep = ((MiningMartStep)start).getStep();
            if (end instanceof MiningMartChain) {
                this.tochain = ((MiningMartChain)end).getChain();
                this.steptochain = true;
            }
            if (end instanceof MiningMartStep) {
                this.steptostep = true;
            }
        }
        if (!this.steptostep) {
            this.initComponents();
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(500, 350);
            Dimension size = this.getSize();
            this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
            this.setVisible(true);
        }
    }

    private void initComponents() {
        try {
            Step step;
            int index;
            Iterator iter;
            Collection col;
            Border emptyborder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
            Border emptyborder2 = BorderFactory.createEmptyBorder(2, 10, 2, 10);
            JPanel top_panel = new JPanel();
            top_panel.setLayout(new BorderLayout(5, 5));
            JLabel toplabel = new JLabel(Resource.getString("TRANSITION") + ": " + this.start.getName() + " -> " + this.end.getName());
            top_panel.add((Component)toplabel, "North");
            this.fromlist = new JList();
            this.fromlist.setSelectionMode(0);
            this.fromlist.setLayoutOrientation(0);
            this.fromlist.setVisibleRowCount(-1);
            this.tolist = new JList();
            this.tolist.setSelectionMode(0);
            this.tolist.setLayoutOrientation(0);
            this.tolist.setVisibleRowCount(-1);
            if (this.chaintochain) {
                col = this.fromchain.getAllTransitionsToChain(this.tochain);
                iter = col.iterator();
                this.fromsteps = new Step[col.size()];
                this.tosteps = new Step[col.size()];
                this.fromstepnames = new String[col.size()];
                index = 0;
                while (iter.hasNext()) {
                    Step[] steps = (Step[])iter.next();
                    this.fromsteps[index] = steps[0];
                    this.tosteps[index] = steps[1];
                    this.fromstepnames[index] = steps[0].getName() + " -> " + steps[1].getName();
                    ++index;
                }
                this.tostepnames = new String[]{Resource.getString("TRANSITION_NONE")};
            }
            if (this.steptochain) {
                col = this.tochain.getSuccessors(this.fromstep);
                iter = col.iterator();
                this.tosteps = new Step[col.size()];
                this.tostepnames = new String[col.size()];
                index = 0;
                while (iter.hasNext()) {
                    this.tosteps[index] = step = (Step)iter.next();
                    this.tostepnames[index] = step.getName();
                    ++index;
                }
                this.fromsteps = new Step[]{this.tostep};
                this.fromstepnames = new String[]{this.fromstep.getName()};
            }
            if (this.chaintostep) {
                col = this.fromchain.getPredecessors(this.tostep);
                iter = col.iterator();
                this.fromsteps = new Step[col.size()];
                this.fromstepnames = new String[col.size()];
                index = 0;
                while (iter.hasNext()) {
                    this.fromsteps[index] = step = (Step)iter.next();
                    this.fromstepnames[index] = step.getName();
                    ++index;
                }
                this.tosteps = new Step[]{this.tostep};
                this.tostepnames = new String[]{this.tostep.getName()};
            }
            this.fromlist.setListData(this.fromstepnames);
            this.tolist.setListData(this.tostepnames);
            JScrollPane fromscrollpane = new JScrollPane(this.fromlist);
            JScrollPane toscrollpane = new JScrollPane(this.tolist);
            fromscrollpane.setBorder(emptyborder2);
            toscrollpane.setBorder(emptyborder2);
            JLabel fromlabel = new JLabel(Resource.getString("FROM_STEP"));
            JLabel tolabel = new JLabel(Resource.getString("TO_STEP"));
            fromlabel.setBorder(emptyborder);
            tolabel.setBorder(emptyborder);
            JPanel frompanel = new JPanel();
            frompanel.setLayout(new BorderLayout());
            frompanel.add((Component)fromlabel, "North");
            frompanel.add((Component)fromscrollpane, "Center");
            JPanel topanel = new JPanel();
            topanel.setLayout(new BorderLayout());
            topanel.add((Component)tolabel, "North");
            topanel.add((Component)toscrollpane, "Center");
            JPanel mid_panel = new JPanel();
            if (this.chaintochain) {
                mid_panel.setLayout(new GridLayout(1, 1));
            } else {
                mid_panel.setLayout(new GridLayout(1, 2));
            }
            mid_panel.add(frompanel);
            if (!this.chaintochain) {
                mid_panel.add(topanel);
            }
            top_panel.add((Component)mid_panel, "Center");
            this.ok = new JButton(Resource.getString("OK"));
            if (this.fromstepnames.length == 1 && this.tostepnames.length == 1) {
                this.ok.setEnabled(true);
            }
            this.ok.addActionListener(this);
            JPanel bottom = new JPanel();
            bottom.setLayout(new BoxLayout(bottom, 0));
            bottom.add(Box.createHorizontalGlue());
            bottom.add(this.ok);
            bottom.add(Box.createRigidArea(new Dimension(10, 0)));
            top_panel.add((Component)bottom, "South");
            top_panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.getContentPane().add(top_panel);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            this.dispose();
        }
    }

    public int getExitAction() {
        return this.exitAction;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(Resource.getString("OK"))) {
            this.exitAction = 0;
            this.dispose();
        }
    }
}

