/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.musoft.limo.application.Resource;

public class CreateCaseDialog
extends JDialog {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel caseLabel = new JLabel();
    private JTextField caseName = new JTextField("", 15);
    private JLabel modeLabel = new JLabel();
    private JCheckBox trainingCheckBox = new JCheckBox();
    private JCheckBox finalCheckBox = new JCheckBox();
    private JButton createButton = new JButton();
    private JButton cancelButton = new JButton();
    private Case caseToCreate = null;
    private boolean rename = false;
    private Case caseToRename = null;
    private MiningMartApplication app;

    public CreateCaseDialog(MiningMartApplication app, String title, boolean modal) {
        super(app, title, modal);
        this.app = app;
        try {
            this.initComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() throws Exception {
        this.caseLabel.setText(Resource.getString("CASE_NAME"));
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.modeLabel.setText(Resource.getString("CASE_MODE"));
        this.trainingCheckBox.setText(Resource.getString("CASE_MODE_TEST"));
        this.trainingCheckBox.setSelected(true);
        this.trainingCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCaseDialog.this.checkBox_actionPerformed(e);
            }
        });
        this.finalCheckBox.setText(Resource.getString("CASE_MODE_FINAL"));
        this.finalCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCaseDialog.this.checkBox_actionPerformed(e);
            }
        });
        this.createButton.setText(Resource.getString("OK"));
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCaseDialog.this.createButton_actionPerformed(e);
            }
        });
        this.cancelButton.setText(Resource.getString("CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCaseDialog.this.cancelButton_actionPerformed(e);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(this.gridBagLayout1);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)this.caseLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
        panel.add((Component)this.caseName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        panel.add((Component)this.modeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.finalCheckBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.createButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 5), 0, 0));
        panel.add((Component)this.cancelButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.trainingCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getRootPane());
    }

    public Case showCreateDialog() {
        this.rename = false;
        this.setVisible(true);
        return this.caseToCreate;
    }

    public Case showCreateDialog(Case c) {
        this.rename = true;
        this.caseToRename = c;
        this.caseName.setText(this.caseToRename.getName());
        this.finalCheckBox.setSelected(this.caseToRename.getTheMode().equals("final"));
        this.trainingCheckBox.setSelected(!this.caseToRename.getTheMode().equals("final"));
        this.setVisible(true);
        return this.caseToRename;
    }

    private void createButton_actionPerformed(ActionEvent e) {
        try {
            if (!this.rename) {
                boolean setAsCurrentCase = true;
                this.caseToCreate = MiningMartApplication.m4Interface.createCase(this.caseName.getText(), setAsCurrentCase);
                if (this.finalCheckBox.isSelected()) {
                    this.caseToCreate.setTheMode("FINAL");
                } else {
                    this.caseToCreate.setTheMode("TEST");
                }
                this.caseToCreate.store();
            } else {
                this.caseToRename.setName(this.caseName.getText());
                if (this.finalCheckBox.isSelected()) {
                    this.caseToRename.setTheMode("FINAL");
                } else {
                    this.caseToRename.setTheMode("TEST");
                }
            }
        }
        catch (M4Exception ex) {
            M4Interface.print.doPrint(Print.ERROR, ex.getMessage(), ex);
            JOptionPane.showMessageDialog(this, ex.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return;
        }
        this.dispose();
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        this.caseToCreate = null;
        this.dispose();
    }

    private void checkBox_actionPerformed(ActionEvent e) {
        if (e.getSource() == this.trainingCheckBox) {
            this.trainingCheckBox.setSelected(true);
            this.finalCheckBox.setSelected(false);
        } else {
            this.trainingCheckBox.setSelected(false);
            this.finalCheckBox.setSelected(true);
        }
    }
}

