/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.musoft.limo.application.Resource;

public class ConceptFromTableDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    public final int CANCEL = 0;
    public final int OK = 1;
    private int exitAction = 0;
    private JButton ok;
    private JButton cancel;
    private JList tables;
    private String concept;
    private String[] tablenames;

    public ConceptFromTableDialog(MiningMartApplication parent) {
        super(parent, Resource.getString("DIALOG_CONCEPTFROMTABLE_TITLE"), true);
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(250, 300);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    public void initComponents() {
        JPanel top_panel = new JPanel();
        top_panel.setLayout(new BorderLayout(5, 5));
        this.cancel = new JButton(Resource.getString("CANCEL"));
        this.ok = new JButton(Resource.getString("OK"));
        this.ok.setEnabled(false);
        this.cancel.addActionListener(this);
        this.ok.addActionListener(this);
        JLabel label = new JLabel(Resource.getString("DIALOG_CONCEPTFROMTABLE_TABLE"));
        top_panel.add((Component)label, "North");
        Collection coll = new LinkedList();
        try {
            coll = MiningMartApplication.m4Interface.getNamesOfBusinessTablesAndViews();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            coll = new LinkedList();
        }
        Iterator iter = coll.iterator();
        this.tablenames = new String[coll.size()];
        int index = 0;
        while (iter.hasNext()) {
            this.tablenames[index] = (String)iter.next();
            ++index;
        }
        this.tables = new JList<String>(this.tablenames);
        this.tables.addListSelectionListener(this);
        JScrollPane scrollpane = new JScrollPane(this.tables);
        top_panel.add((Component)scrollpane, "Center");
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this.ok);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        bottom.add(this.cancel);
        top_panel.add((Component)bottom, "South");
        top_panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(top_panel);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(Resource.getString("CANCEL"))) {
            this.exitAction = 0;
            this.dispose();
        }
        if (cmd.equals(Resource.getString("OK"))) {
            this.exitAction = 1;
            this.concept = (String)this.tables.getSelectedValue();
            this.dispose();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.tables.isSelectionEmpty()) {
            this.ok.setEnabled(true);
        } else {
            this.ok.setEnabled(false);
        }
    }

    public int getExitAction() {
        return this.exitAction;
    }

    public String getTableName() {
        if (this.exitAction == 1) {
            return this.concept;
        }
        return null;
    }
}

