/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.compiler.M4CompilerInterfaceError;
import edu.udo.cs.miningmart.exception.M4CompilerWarning;
import edu.udo.cs.miningmart.exception.UserError;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.MiningMartMenuBar;
import edu.udo.cs.miningmart.gui.application.MiningMartToolBar;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import javax.swing.JOptionPane;
import org.musoft.limo.application.Resource;

public class CompilerThread
extends Thread {
    public static final int COMPILE_STEP = 0;
    public static final int COMPILE_FROM_STEP = 1;
    public static final int COMPILE_UNTIL_STEP = 2;
    public static final int COMPILE_ALL = 3;
    private MiningMartApplication app;
    private int task;
    private long stepId;

    public CompilerThread(MiningMartApplication app, int task, long stepId) {
        this.app = app;
        this.task = task;
        this.stepId = stepId;
    }

    public void killCompilation() {
    }

    public void run() {
        ((MiningMartMenuBar)this.app.getJMenuBar()).promptStartCompilationItemStates();
        ((MiningMartToolBar)this.app.getToolbar()).promptStartCompilationItemStates();
        try {
            if (this.task == 0) {
                this.runCompileStep();
            } else if (this.task == 1) {
                this.runCompileFrom();
            } else if (this.task == 2) {
                this.runCompileUntil();
            } else if (this.task == 3) {
                this.runCompileAll();
            }
        }
        catch (M4CompilerWarning warn) {
            JOptionPane.showMessageDialog(this.app, warn.getMessage(), Resource.getString("COMPILE_WARNING_TITLE"), 2);
        }
        catch (M4CompilerInterfaceError ce) {
            JOptionPane.showMessageDialog(this.app, ce.getMessage(), Resource.getString("COMPILE_ERROR_UNTIL_STEP"), 0);
        }
        catch (UserError ue) {
            M4Interface.print.doPrint(Print.ERROR, ue.getMessage());
            JOptionPane.showMessageDialog(null, ue.getMessage(), "Runtime condition violated", 0);
        }
        catch (Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("COMPILING_DONE"));
        ((MiningMartMenuBar)this.app.getJMenuBar()).promptDoneCompilationItemStates();
        ((MiningMartToolBar)this.app.getToolbar()).promptDoneCompilationItemStates();
    }

    private void runCompileStep() throws UserError, M4CompilerWarning, M4CompilerInterfaceError {
        this.app.getCompilerAccess().compileStep(this.stepId, MiningMartApplication.compileLazy);
    }

    private void runCompileFrom() throws UserError, M4CompilerWarning, M4CompilerInterfaceError {
        this.app.getCompilerAccess().compileStepFrom(this.stepId, MiningMartApplication.compileLazy);
    }

    private void runCompileUntil() throws UserError, M4CompilerWarning, M4CompilerInterfaceError {
        this.app.getCompilerAccess().compileStepTo(this.stepId, MiningMartApplication.compileLazy, true);
    }

    private void runCompileAll() throws UserError, M4CompilerWarning, M4CompilerInterfaceError {
        this.app.getCompilerAccess().compileAll(M4Interface.getCurrentCase().getId(), MiningMartApplication.compileLazy);
    }
}

