/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.db;

import edu.udo.cs.miningmart.db.DbCore;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.M4InterfaceContext;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.postgresql.Driver;

public class DbCorePostgres
extends DbCore {
    public static final String POSTGRES_TYPE_NUMBER = "NUMERIC";
    public static final String POSTGRES_TYPE_STRING = "VARCHAR";
    public static final String POSTGRES_TYPE_CHAR = "CHAR";
    public static final String POSTGRES_TYPE_DATE = "DATE";
    public static final String POSTGRES_TYPE_TIME = "TIME";
    public static final String POSTGRES_TYPE_TIMESTAMP = "TIMESTAMP";
    public static final String POSTGRES_TYPE_TEXT = "TEXT";
    private final String nameOfM4Sequence = "all_sq";

    public DbCorePostgres(String url, String dbName, String user, String passwd, M4InterfaceContext cal, boolean isM4Schema) throws SQLException {
        super(url, "/" + dbName, user, passwd, cal, isM4Schema);
    }

    protected void registerJDBC_Driver() throws SQLException {
        DriverManager.registerDriver((java.sql.Driver)new Driver());
    }

    public short getDbms() {
        return 2;
    }

    protected void switchAutocommitOff(Connection con) throws SQLException {
        this.openTransactionBlock();
    }

    public void commitTransactions() throws SQLException {
        super.commitTransactions();
        this.openTransactionBlock();
    }

    protected long getNextM4SequenceValue(Statement stmt) throws M4Exception {
        String query = "select nextval('" + this.nameOfM4Sequence + "')";
        Long nextval = null;
        String sqle = "";
        try {
            nextval = this.executeSingleValueSqlReadL(query, stmt);
        }
        catch (SQLException e) {
            sqle = "\nAn SQLException occured during invocation:\n" + e.getMessage();
        }
        if (nextval == null) {
            String msg = "Error in method DbCorePostgres.getNextM4SequenceValue(Statement):\nSequence '" + this.nameOfM4Sequence + "' did not return a value!" + sqle;
            throw new M4Exception(msg);
        }
        return nextval;
    }

    public String getSelectStringAllTables() {
        String ret = "SELECT UPPER(relname) FROM pg_class, pg_user WHERE relkind='r'AND SUBSTRING(relname FROM 1 FOR 3) != 'pg_'";
        if (this.getUser() != null) {
            ret = ret + " AND relowner = pg_user.usesysid AND pg_user.usename = '" + this.getUser() + "'";
        }
        return ret;
    }

    public String getSelectStringAllViews() {
        String ret = "SELECT UPPER(relname) FROM pg_class, pg_user WHERE relkind='v'AND SUBSTRING(relname FROM 1 FOR 3) != 'pg_'";
        if (this.getUser() != null) {
            ret = ret + " AND relowner = pg_user.usesysid AND pg_user.usename = '" + this.getUser() + "'";
        }
        return ret;
    }

    public String getSelectStringAllColumnsForDbObject(String dbObjectName) {
        return "SELECT attname, typname FROM pg_attribute, pg_type, pg_class WHERE attrelid = pg_class.oid AND atttypid = pg_type.oid AND attname != 'tableoid' AND attname != 'cmax' AND attname != 'xmax' AND attname != 'cmin' AND attname != 'xmin' AND attname != 'oid' AND attname != 'ctid' AND relname = '" + dbObjectName.toLowerCase() + "'";
    }

    public boolean tableExists(String tableName) throws M4Exception {
        String query = "SELECT oid FROM pg_class, pg_user WHERE relkind='r' AND relname='" + tableName.toLowerCase() + "'";
        if (this.getUser() != null) {
            query = query + " AND relowner = pg_user.usesysid AND pg_user.usename = '" + this.getUser() + "'";
        }
        Long l = null;
        try {
            l = this.executeSingleValueSqlReadL(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error testing if table '" + tableName + "' exists: " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("DB connection error when testing if table '" + tableName + "' exists: " + d.getMessage());
        }
        return l != null;
    }

    public String getSelectStringColumnDataTypes(String dbObjectName, String owner, String columnName) {
        String ret = "SELECT typname FROM pg_attribute, pg_type, pg_class, pg_user WHERE attrelid = pg_class.oid AND atttypid = pg_type.oid AND relowner = pg_user.usesysid AND attname != 'tableoid' AND attname != 'cmax' AND attname != 'xmax' AND attname != 'cmin' AND attname != 'xmin' AND attname != 'oid' AND attname != 'ctid' AND relname = '" + dbObjectName.toLowerCase() + "' AND attname = '" + columnName.toLowerCase() + "'";
        if (owner != null) {
            ret = ret + " AND usename = '" + owner.toLowerCase() + "'";
        }
        return ret;
    }

    public Collection getPrimaryKeyColumnNames(String dbObjectName) throws SQLException, DbConnectionClosed {
        String query = "SELECT indkey FROM pg_index, pg_class WHERE pg_class.oid =indrelid AND relname = '" + dbObjectName.toLowerCase() + "' AND indisprimary='t'";
        ResultSet rs = this.executeSqlRead(query);
        String colNos = null;
        if (rs.next()) {
            colNos = rs.getString(1);
        }
        rs.close();
        if (colNos == null) {
            return new Vector();
        }
        StringTokenizer st = new StringTokenizer(colNos);
        int nextPrimaryKeyColNumber = -1;
        if (st.hasMoreTokens()) {
            nextPrimaryKeyColNumber = Integer.parseInt(st.nextToken());
        }
        query = this.getSelectStringAllColumnsForDbObject(dbObjectName);
        rs = this.executeSqlRead(query);
        Vector<String> thePrimaryKeyColumns = new Vector<String>();
        int colNumberRead = 1;
        while (rs.next()) {
            String colName = rs.getString(1);
            if (colNumberRead == nextPrimaryKeyColNumber) {
                thePrimaryKeyColumns.add(colName);
            }
            if (!st.hasMoreTokens()) break;
            nextPrimaryKeyColNumber = Integer.parseInt(st.nextToken());
            ++colNumberRead;
        }
        rs.close();
        return thePrimaryKeyColumns;
    }

    public boolean isColumnUsedAsPrimaryKey(String columnName, String dbObjectName) throws SQLException, DbConnectionClosed {
        Collection primColumnsForTable = this.getPrimaryKeyColumnNames(dbObjectName);
        if (primColumnsForTable == null) {
            return false;
        }
        return primColumnsForTable.contains(columnName);
    }

    public Map getTablesReferencedBy(String dbObjectName) throws SQLException, DbConnectionClosed {
        String query = this.getSelectStringAllColumnsForDbObject(dbObjectName);
        ResultSet rs = this.executeSqlRead(query);
        HashMap<String, String> myMap = new HashMap<String, String>();
        while (rs.next()) {
            myMap.put(rs.getString(1), null);
        }
        rs.close();
        query = "SELECT tgargs, tgconstrrelid FROM pg_trigger, pg_class WHERE pg_class.oid = pg_trigger.tgrelid and pg_class.relname = '" + dbObjectName + "'";
        rs = this.executeSqlRead(query);
        while (rs.next()) {
            String argumentsOfTrigger = rs.getString(1);
            String[] args = this.getArguments(argumentsOfTrigger);
            if (args.length < 2 || !args[1].equalsIgnoreCase(dbObjectName)) continue;
            String referencedTable = args[2];
            if (args.length <= 4) continue;
            int noOfKeyCols = (args.length - 4) / 2;
            for (int i = 0; i < noOfKeyCols; ++i) {
                myMap.put(args[i + 4], referencedTable);
            }
        }
        rs.close();
        return myMap;
    }

    private String[] getArguments(String postgresTriggerArgs) {
        int i = 0;
        Vector<String> allArgs = new Vector<String>();
        String currentArg = "";
        while (i < postgresTriggerArgs.length()) {
            if (postgresTriggerArgs.charAt(i) == '\\') {
                i += 4;
                allArgs.add(currentArg);
                currentArg = "";
                continue;
            }
            currentArg = currentArg + postgresTriggerArgs.charAt(i);
            ++i;
        }
        return (String[])allArgs.toArray();
    }

    public String getTableOrViewType(String dbObjectName) throws SQLException, DbConnectionClosed {
        String query = "SELECT relkind FROM pg_class WHERE relname = '" + dbObjectName.toLowerCase() + "'";
        String type = this.executeSingleValueSqlRead(query);
        if (type.equalsIgnoreCase("v")) {
            return "V";
        }
        if (type.equalsIgnoreCase("r")) {
            return "T";
        }
        return null;
    }

    public String getAttributeForColumnNames() {
        return "attname";
    }

    public String getAttributeForColumnTypes() {
        return "typname";
    }

    public String getUniqueRowIdentifier() {
        return "oid";
    }

    public String getDatatypeName(String m4RelDatatypeName, int size) {
        String ret = null;
        if (m4RelDatatypeName.equals("NUMBER")) {
            ret = POSTGRES_TYPE_NUMBER;
        } else if (m4RelDatatypeName.equals(POSTGRES_TYPE_DATE)) {
            ret = POSTGRES_TYPE_DATE;
        } else if (m4RelDatatypeName.equals("KEY")) {
            ret = POSTGRES_TYPE_NUMBER;
        } else if (m4RelDatatypeName.equals("STRING")) {
            ret = POSTGRES_TYPE_STRING;
        }
        if (ret != null && size > 0) {
            ret = ret + "(" + size + ")";
        }
        return ret;
    }

    public String getM4DatatypeName(String dbmsDatatypeName) {
        if ((dbmsDatatypeName = dbmsDatatypeName.toUpperCase()).equals(POSTGRES_TYPE_NUMBER)) {
            return "NUMBER";
        }
        if (dbmsDatatypeName.startsWith("FLOAT")) {
            return "NUMBER";
        }
        if (dbmsDatatypeName.startsWith("INT")) {
            return "NUMBER";
        }
        if (dbmsDatatypeName.equals(POSTGRES_TYPE_DATE) || dbmsDatatypeName.equals(POSTGRES_TYPE_TIME) || dbmsDatatypeName.equals(POSTGRES_TYPE_TIMESTAMP)) {
            return POSTGRES_TYPE_DATE;
        }
        if (dbmsDatatypeName.equals(POSTGRES_TYPE_STRING)) {
            return "STRING";
        }
        if (dbmsDatatypeName.equals(POSTGRES_TYPE_TEXT)) {
            return "STRING";
        }
        return null;
    }

    public boolean dropRelation(String tableName) throws M4Exception {
        boolean tableExists = this.tableExists(tableName);
        if (tableExists) {
            String sql_drop = "DROP TABLE " + tableName;
            try {
                this.executeSqlWrite(sql_drop);
            }
            catch (SQLException sqle) {
                throw new M4Exception("Error trying to remove the table '" + tableName + "':\n" + sqle.getMessage());
            }
            catch (DbConnectionClosed dbe) {
                throw new M4Exception("DB Connection closed when deleting table '" + tableName + "':\n" + dbe.getMessage());
            }
        }
        return tableExists;
    }

    private void openTransactionBlock() {
    }

    public String getTestQuery() {
        return this.getSelectStringAllTables();
    }
}

