/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.db;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.db.DbCoreOracle;
import edu.udo.cs.miningmart.db.DbCorePostgres;
import edu.udo.cs.miningmart.db.ExtendedResultSet;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.M4InterfaceContext;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

public abstract class DbCore {
    public static String DBMS_ORACLE = "Oracle";
    public static String DBMS_POSTGRES = "Postgres";
    private Connection con = null;
    private final HashMap readResultSets = new HashMap();
    private Statement statementWrite;
    private static final int MAX_OPEN_STATEMENTS = 20;
    private final String url;
    private final String user;
    private final String passwd;
    private final boolean refersToM4Schema;
    private final transient M4InterfaceContext cal;

    static DbCore getDbCore(String url, String dbName, String user, String passwd, M4InterfaceContext cal, boolean isM4Schema) throws SQLException {
        String dbms = DbCore.findDBMS(url);
        if (dbms == null) {
            return null;
        }
        if (dbms.equals(DBMS_ORACLE)) {
            return new DbCoreOracle(url, dbName, user, passwd, cal, isM4Schema);
        }
        if (dbms.equals(DBMS_POSTGRES)) {
            return new DbCorePostgres(url, dbName, user, passwd, cal, isM4Schema);
        }
        throw new SQLException("DbCore.getDbCore(): Could not recognize DBMS system!");
    }

    public static String findDBMS(String url) {
        if (url != null) {
            String lowUrl = url.toLowerCase();
            if (lowUrl.indexOf("oracle") >= 0) {
                return DBMS_ORACLE;
            }
            if (lowUrl.indexOf("postgres") >= 0) {
                return DBMS_POSTGRES;
            }
        }
        return null;
    }

    public Print getCasePrintObject() {
        return this.cal.getPrintObject();
    }

    public DbCore(String url, String dbName, String user, String passwd, M4InterfaceContext cal, boolean refersToM4Schema) throws SQLException {
        this.url = url + dbName;
        this.user = user;
        this.passwd = passwd;
        this.refersToM4Schema = refersToM4Schema;
        this.cal = cal;
        this.getFreshConnection();
    }

    public void finalize() throws SQLException {
        this.closeDbStatements();
        if (this.con != null) {
            this.con.close();
            this.con = null;
            this.doPrint(Print.COMPILER_CASE_CONTROL, "DB disconnected");
        }
    }

    public abstract short getDbms();

    protected abstract void registerJDBC_Driver() throws SQLException;

    protected abstract void switchAutocommitOff(Connection var1) throws SQLException;

    void getFreshConnection() throws SQLException {
        if (this.con != null) {
            this.con.commit();
            this.closeDbStatements();
            this.con.close();
        } else {
            this.registerJDBC_Driver();
        }
        this.con = DriverManager.getConnection(this.url, this.user, this.passwd);
        this.switchAutocommitOff(this.con);
        DatabaseMetaData md = this.con.getMetaData();
        this.doPrint(Print.MAX, "\n--- Refreshing database connection ---");
        this.doPrint(Print.MAX, "JDBC-Driver-Version: " + md.getDriverVersion() + "  " + md.getDatabaseProductName());
        this.doPrint(Print.MAX, "Database: " + this.url + "\tUser:  " + this.user);
        this.doPrint(Print.MAX, "DB-Connection ok");
    }

    String getUrl() {
        return this.url;
    }

    String getUser() {
        return this.user;
    }

    String getPasswd() {
        return this.passwd;
    }

    boolean isM4Schema() {
        return this.refersToM4Schema;
    }

    public void commitTransactions() throws SQLException {
        this.closeDbStatements();
        if (this.isM4Schema()) {
            this.getDatabaseConnection().commit();
        } else {
            this.getDatabaseConnection().commit();
        }
        this.doPrint(Print.DB_WRITE, "DB: Batch executed, updates committed!");
    }

    public void rollback() throws SQLException {
        this.closeDbStatements();
        this.getDatabaseConnection().rollback();
        this.doPrint(Print.DB_WRITE, "DB: Updates rolled back!");
    }

    private Connection getDatabaseConnection() {
        return this.con;
    }

    private Statement getDbReadStatement() throws SQLException, DbConnectionClosed {
        Statement stmt = DbCore.findFreeStatement(this.readResultSets);
        if (stmt == null) {
            stmt = this.getDatabaseConnection().createStatement();
            this.readResultSets.put(stmt, new ExtendedResultSet(stmt));
        }
        if (this.readResultSets.size() > 20) {
            this.openStatementsWarning(this.readResultSets.size());
        }
        return stmt;
    }

    private Statement getDbWriteStatement() throws SQLException, DbConnectionClosed {
        if (this.statementWrite == null) {
            Statement stmt = this.getDatabaseConnection().createStatement();
            stmt.clearBatch();
            this.statementWrite = stmt;
        }
        return this.statementWrite;
    }

    private void closeDbStatements() {
        if (this.statementWrite != null) {
            try {
                DbCore.commitBatch(this.statementWrite);
                this.statementWrite.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.statementWrite = null;
        }
        DbCore.clearStatementMap(this.readResultSets);
    }

    Connection getExternalDatabaseConnection() throws SQLException {
        this.registerJDBC_Driver();
        Connection newDataCon = DriverManager.getConnection(this.getUrl(), this.getUser(), this.getPasswd());
        this.switchAutocommitOff(newDataCon);
        DatabaseMetaData dmd = newDataCon.getMetaData();
        this.doPrint(Print.COMPILER_CASE_CONTROL, "\n--- Setting up new database connection for external use ---");
        this.doPrint(Print.COMPILER_CASE_CONTROL, "JDBC-Driver-Version: " + dmd.getDriverVersion() + "  " + dmd.getDatabaseProductName());
        this.doPrint(Print.COMPILER_CASE_CONTROL, "DB-Connection ok");
        return newDataCon;
    }

    public void executeSqlWrite(String query) throws SQLException, DbConnectionClosed {
        Statement stmt = this.getDbWriteStatement();
        this.executeSqlWrite(query, stmt);
    }

    public void createSQLView(Columnset cs, boolean materialize) throws SQLException, DbConnectionClosed {
        String sqlTemp = cs.getSQLDefinition();
        sqlTemp = sqlTemp.substring(1, sqlTemp.length() - 1);
        String query = "CREATE " + (materialize ? "TABLE " : "OR REPLACE VIEW ") + cs.getName() + " AS " + sqlTemp;
        this.executeSqlWrite(query);
    }

    public void createSQLFunction(String myFunction) throws SQLException, DbConnectionClosed {
        String query = "CREATE OR REPLACE " + myFunction;
        this.executeSqlWrite(query);
    }

    public String createSqlIndex(String tableName, String[] attributes) throws SQLException, DbConnectionClosed {
        if (attributes == null || attributes.length == 0) {
            return null;
        }
        String indexName = tableName + "_IDX";
        String query = "CREATE INDEX " + indexName + " ON " + tableName + " (";
        for (int i = 0; i < attributes.length; ++i) {
            query = query + attributes[i] + ", ";
        }
        query = query.subSequence(0, query.length() - 2) + ")";
        this.executeSqlWrite(query);
        return indexName;
    }

    public ResultSet executeSqlRead(String query) throws SQLException, DbConnectionClosed {
        Statement stmt = this.getDbReadStatement();
        return this.executeSqlRead(query, stmt);
    }

    private void executeSqlWrite(String query, Statement stmt) throws SQLException {
        if (DbCore.isBatchableWriteQuery(query)) {
            stmt.addBatch(query);
            this.doPrint(Print.DB_WRITE, "DB write (to batch): " + query);
        } else {
            DbCore.commitBatch(stmt);
            stmt.executeUpdate(query);
            this.doPrint(Print.DB_WRITE, "DB execute/update: " + query);
        }
    }

    private ResultSet executeSqlRead(String query, Statement stmt) throws SQLException {
        this.doPrint(Print.DB_READ, "DB Query (Read): " + query);
        ExtendedResultSet rs = new ExtendedResultSet(stmt.executeQuery(query));
        this.readResultSets.put(stmt, rs);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeSingleValueSqlRead(String query, Statement stmt) throws SQLException {
        ResultSet rs;
        block3: {
            String string;
            rs = null;
            try {
                String s;
                rs = this.executeSqlRead(query, stmt);
                if (!rs.next()) break block3;
                string = s = rs.getString(1);
            }
            catch (Throwable throwable) {
                DB.closeResultSet(rs);
                throw throwable;
            }
            DB.closeResultSet(rs);
            return string;
        }
        String string = null;
        DB.closeResultSet(rs);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long executeSingleValueSqlReadL(String query, Statement stmt) throws SQLException {
        ResultSet rs;
        block3: {
            Long l;
            rs = null;
            try {
                rs = this.executeSqlRead(query, stmt);
                if (!rs.next()) break block3;
                Long l2 = new Long(rs.getLong(1));
                rs.close();
                l = l2;
            }
            catch (Throwable throwable) {
                DB.closeResultSet(rs);
                throw throwable;
            }
            DB.closeResultSet(rs);
            return l;
        }
        Long l = null;
        DB.closeResultSet(rs);
        return l;
    }

    public Long executeSingleValueSqlReadL(String query) throws SQLException, DbConnectionClosed {
        Statement stmt = this.getDbReadStatement();
        return this.executeSingleValueSqlReadL(query, stmt);
    }

    public String executeSingleValueSqlRead(String query) throws SQLException, DbConnectionClosed {
        Statement stmt = this.getDbReadStatement();
        return this.executeSingleValueSqlRead(query, stmt);
    }

    protected abstract long getNextM4SequenceValue(Statement var1) throws M4Exception;

    long getNextM4SequenceValue() throws DbConnectionClosed, M4Exception {
        try {
            Statement stmt = this.getDbReadStatement();
            return this.getNextM4SequenceValue(stmt);
        }
        catch (SQLException e) {
            String msg = "Error in method DbCore.getNextM4SequenceValue():\nCould not create Statement:\n" + e.getMessage();
            throw new M4Exception(msg);
        }
    }

    public void executeDBProcedure(String procedureName, String[] parameters) throws SQLException, DbConnectionClosed, M4CompilerError {
        Statement stmt = this.getDbWriteStatement();
        DbCore.commitBatch(stmt);
        String queryStart = "BEGIN " + procedureName + "(";
        String queryEnd = "); END; ";
        String queryParameters = "";
        for (int i = 0; i < parameters.length; ++i) {
            queryParameters = queryParameters + parameters[i];
            if (i >= parameters.length - 1) continue;
            queryParameters = queryParameters + ", ";
        }
        String query = queryStart + queryParameters + queryEnd;
        this.doPrint(Print.DB_READ, "DB Query: " + query);
        stmt.executeUpdate(query);
    }

    private void openStatementsWarning(int number) {
        this.doPrint(Print.MAX, "( Warning: The number of open statements is " + number + ".");
        this.doPrint(Print.MAX, "  Probably some of the ResultSets are not closed after usage! )");
    }

    void stopDbThread() {
        this.doPrint(Print.MAX, "Thread was requested to stop. Closing database resources.");
        try {
            if (this.statementWrite != null) {
                this.statementWrite.clearBatch();
            }
            DbCore.clearStatementMap(this.readResultSets);
            if (this.con != null) {
                this.con.rollback();
                this.con.close();
                this.con = null;
            }
            this.doPrint(Print.DB_WRITE, "DB: Rollback and closing of connection successful!");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void doPrint(Level verbosity, String message) {
        this.getCasePrintObject().doPrint(verbosity, message);
    }

    private void doPrint(Exception ex) {
        this.getCasePrintObject().doPrint(Print.ERROR, ex.getMessage(), ex);
    }

    private static void commitBatch(Statement stmt) throws SQLException {
        stmt.executeBatch();
        stmt.clearBatch();
    }

    private static boolean isBatchableWriteQuery(String query) {
        String tmp = query.trim().toLowerCase();
        return tmp.startsWith("update ") || tmp.startsWith("insert ");
    }

    private static void clearStatementMap(HashMap theMap) {
        if (theMap == null || theMap.isEmpty()) {
            return;
        }
        Iterator it = theMap.keySet().iterator();
        while (it.hasNext()) {
            Statement stmt = (Statement)it.next();
            if (stmt == null) continue;
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {}
        }
        theMap.clear();
    }

    private static Statement findFreeStatement(HashMap theMap) {
        Iterator it = theMap.keySet().iterator();
        while (it.hasNext()) {
            ExtendedResultSet rs;
            Statement stmt = (Statement)it.next();
            if (stmt == null || (rs = (ExtendedResultSet)theMap.get(stmt)) == null || !rs.isClosed()) continue;
            return stmt;
        }
        return null;
    }

    public abstract String getSelectStringAllTables();

    public abstract String getSelectStringAllViews();

    public abstract boolean tableExists(String var1) throws M4Exception;

    public abstract String getSelectStringAllColumnsForDbObject(String var1);

    public abstract String getAttributeForColumnNames();

    public abstract String getAttributeForColumnTypes();

    public abstract String getUniqueRowIdentifier();

    public abstract Map getTablesReferencedBy(String var1) throws SQLException, DbConnectionClosed;

    public boolean hasOnlyForeignKeyColumns(String dbObjectName) throws SQLException, DbConnectionClosed {
        Map referencedTables = this.getTablesReferencedBy(dbObjectName);
        ResultSet rs = this.executeSqlRead(this.getSelectStringAllColumnsForDbObject(dbObjectName));
        boolean allColumnsAreForeignKeys = true;
        while (rs.next()) {
            String columnName = rs.getString(1);
            if (referencedTables.get(columnName) != null) continue;
            allColumnsAreForeignKeys = false;
        }
        rs.close();
        return allColumnsAreForeignKeys;
    }

    public abstract Collection getPrimaryKeyColumnNames(String var1) throws SQLException, DbConnectionClosed;

    public abstract String getTableOrViewType(String var1) throws SQLException, DbConnectionClosed;

    public abstract String getDatatypeName(String var1, int var2);

    public abstract String getM4DatatypeName(String var1);

    public abstract String getSelectStringColumnDataTypes(String var1, String var2, String var3);

    public abstract boolean dropRelation(String var1) throws M4Exception;

    public abstract String getTestQuery();
}

