/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.compiler.wrapper;

import edu.udo.cs.miningmart.compiler.utils.DrawSample;
import edu.udo.cs.miningmart.compiler.wrapper.SVM_Wrapper;
import edu.udo.cs.miningmart.db.CompilerDatabaseService;
import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

abstract class SupportVectorMachine
extends SVM_Wrapper {
    private String svmCommand;
    private String tempDir;
    protected String svmOutput;

    public SupportVectorMachine(CompilerDatabaseService databaseObj, Print printObj, String nameForDatabaseUse, String nameOfDatabaseSchema, long stepId, long sampleSize) throws M4CompilerError {
        super(databaseObj, printObj, nameForDatabaseUse, nameOfDatabaseSchema, stepId);
        this.sampleSize = sampleSize;
        String path = System.getProperty("ML_HOME");
        String osName = System.getProperty("os.name");
        if (osName.substring(0, 3).equalsIgnoreCase("win")) {
            osName = "Windows";
        }
        if (!(osName.equals("SunOS") || osName.equals("Linux") || osName.equals("Windows"))) {
            throw new M4CompilerError("SVM-Wrapper: current implementation works only on SunOS. Install\nmySVM for your Operating System and change the constructor in\n'SupportVectorMachine.java' (set the mySVM-command path) to adapt\nthe implementation.\nYour operating system is: " + System.getProperty("os.name"));
        }
        String s = File.separator;
        this.svmCommand = path + "bin" + s + osName + s + "mysvm";
        this.tempDir = System.getProperty("TEMP_DIR");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSVM(Columnset inputColumnset, Column targetColumn, long conceptId, String c, String kernelType, String epsilon, Vector thePredictingColumns) throws M4CompilerError {
        this.checkForConversion(inputColumnset, thePredictingColumns, targetColumn);
        String columnsToSelect = this.getCompleteSelectString();
        if (columnsToSelect == null) {
            throw new M4CompilerError("Error in SVM Wrapper: no columns to select from business data.");
        }
        String ttable = "tmp1_" + this.myStepId;
        Vector<String> selectedCols = new Vector<String>();
        for (int i = 0; i < this.theColumnInfos.length; ++i) {
            String cstring = this.theColumnInfos[i].getSelectString();
            selectedCols.add(cstring.toUpperCase());
        }
        new DrawSample(inputColumnset, selectedCols, ttable, "tmp2_" + this.myStepId, null, this.sampleSize, null, this.getDatabaseObj());
        this.inputTableName = ttable;
        String sql_getData = "SELECT " + columnsToSelect + " FROM " + ttable + " WHERE " + targetColumn.getName() + " IS NOT NULL";
        ResultSet rs = null;
        try {
            try {
                rs = this.getDatabaseObj().executeBusinessSqlRead(sql_getData);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Error in SVM Wrapper when reading business data: " + sqle.getMessage());
            }
            Process svmProcess = null;
            this.getPrint().doPrint(Print.OPERATOR, "Starting external algorithm (mySVM) (command: '" + this.svmCommand + "')...");
            try {
                String[] args = new String[]{this.svmCommand};
                svmProcess = Runtime.getRuntime().exec(args, null, new File(this.tempDir));
            }
            catch (IOException ioe) {
                if (svmProcess != null) {
                    svmProcess.destroy();
                }
                throw new M4CompilerError("Error accessing mySVM binary: " + ioe.getMessage());
            }
            OutputStream streamForDataInput = svmProcess.getOutputStream();
            try {
                this.createSVM_Input(rs, kernelType, c, epsilon, streamForDataInput);
            }
            catch (M4CompilerError mce) {
                svmProcess.destroy();
                throw mce;
            }
            this.svmOutput = this.readStream(svmProcess.getInputStream());
            if (this.svmOutput == null || this.svmOutput.equals("")) {
                throw new M4CompilerError("Error trying to read mySVM-Output!");
            }
            if (this.svmOutput.indexOf("* Error") > -1) {
                throw new M4CompilerError("Error in SVM: " + this.svmOutput);
            }
            String svmErrors = this.readStream(svmProcess.getErrorStream());
            if (!svmErrors.equals("")) {
                throw new M4CompilerError("An error occurred in mySVM: " + svmErrors);
            }
            this.getPrint().doPrint(Print.MIN, "\n--- SVM output ---");
            this.getPrint().doPrint(Print.MIN, this.svmOutput);
            this.getPrint().doPrint(Print.MIN, "------------------\n");
            Object var18_21 = null;
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            DB.closeResultSet(rs);
            try {
                CompilerDatabaseService db = this.getDatabaseObj();
                db.dropBusinessTable(ttable);
            }
            catch (M4Exception m4e) {
                // empty catch block
            }
            throw throwable;
        }
        DB.closeResultSet(rs);
        try {
            CompilerDatabaseService db = this.getDatabaseObj();
            db.dropBusinessTable(ttable);
        }
        catch (M4Exception m4e) {}
        try {
            this.processSVMResult();
        }
        catch (Exception e) {
            throw new M4CompilerError("Wrapper for SVM: Error processing result of mySVM: " + e.getMessage());
        }
        if (this.forClassification) {
            this.extractXiAlpha();
        }
        this.createDecisionFunctionAsSQL_Function(kernelType);
    }

    private void processSVMResult() throws M4CompilerError {
        int numberOfLearnAttribs = this.theColumnInfos.length - 1;
        String[] xValues = new String[numberOfLearnAttribs];
        boolean tableExisted = true;
        int numberOfSupportVectors = 0;
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(this.tempDir + "mysvm.svm"));
            String line = lnr.readLine().trim();
            while (line != null && (!Character.isDigit(line.charAt(0)) || line.charAt(0) == '-' && Character.isDigit(line.charAt(1)))) {
                if (line.startsWith("b ")) {
                    try {
                        this.b = Double.parseDouble(line.substring(1).trim());
                    }
                    catch (NumberFormatException nfe) {
                        throw new M4CompilerError("Error reading b from mySVM-Output: tried to convert " + line.substring(1).trim() + " into double.");
                    }
                    catch (IndexOutOfBoundsException ioube) {
                        throw new M4CompilerError("Error reading b from mySVM-Output: tried to read line " + line);
                    }
                }
                line = lnr.readLine();
            }
            try {
                tableExisted = this.getDatabaseObj().dropBusinessTable(this.getModelTableName());
            }
            catch (M4Exception m4e) {
                throw new M4CompilerError(m4e.getMessage());
            }
            String sql_createTable = "CREATE TABLE " + this.getModelTableName() + " (";
            String numbertype = this.getDBMS_Datatype("NUMBER", null);
            for (int i = 0; i < numberOfLearnAttribs - 1; ++i) {
                sql_createTable = sql_createTable + this.theColumnInfos[i].getColumnName() + " " + numbertype + ", ";
            }
            sql_createTable = sql_createTable + this.theColumnInfos[numberOfLearnAttribs - 1].getColumnName() + " " + numbertype + ",  Alpha " + numbertype + ")";
            try {
                this.getDatabaseObj().executeBusinessSqlWrite(sql_createTable);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Error trying to create the intermediate table, under name '" + this.getModelTableName() + "': " + sqle.getMessage());
            }
            this.getDatabaseObj().addTableToTrash(this.getModelTableName(), this.schema, this.myStepId);
            while (line != null) {
                int i;
                StringTokenizer tok = new StringTokenizer(line);
                for (i = 0; i < numberOfLearnAttribs; ++i) {
                    if (!tok.hasMoreTokens()) {
                        throw new M4CompilerError("Error reading the support vectors: wrong dimension!");
                    }
                    xValues[i] = tok.nextToken();
                    xValues[i] = this.checkDouble(xValues[i]);
                    if (xValues[i] != null) continue;
                    throw new M4CompilerError("Error reading mySVM-Resultfile (reading an x-Value): expected double, found " + xValues[i]);
                }
                if (!tok.hasMoreTokens()) {
                    throw new M4CompilerError("Error reading the support vectors: wrong dimension!");
                }
                String label = tok.nextToken();
                if ((label = this.checkDouble(label)) == null) {
                    throw new M4CompilerError("Error reading mySVM-Resultfile (reading a label): expected double, found " + label);
                }
                if (!tok.hasMoreTokens()) {
                    throw new M4CompilerError("Error reading the support vectors: wrong dimension!");
                }
                String alpha = tok.nextToken();
                if ((alpha = this.checkDouble(alpha)) == null) {
                    throw new M4CompilerError("Error reading mySVM-Resultfile (reading an alpha): expected double, found " + alpha);
                }
                if (Double.parseDouble(alpha) != 0.0) {
                    String sql_insert = "insert into " + this.getModelTableName() + " values (";
                    for (i = 0; i < numberOfLearnAttribs; ++i) {
                        sql_insert = sql_insert + xValues[i] + ", ";
                    }
                    sql_insert = sql_insert + alpha + ")";
                    try {
                        this.getDatabaseObj().executeBusinessSqlWrite(sql_insert);
                    }
                    catch (SQLException sqle) {
                        throw new M4CompilerError("Error trying to insert values into intermediate table '" + this.getModelTableName() + "': " + sqle.getMessage());
                    }
                    ++numberOfSupportVectors;
                }
                line = lnr.readLine();
            }
        }
        catch (IOException ioe) {
            throw new M4CompilerError("Error: Could not access SVM-file after training: " + ioe.getMessage());
        }
        File f = new File(this.tempDir + "mysvm.svm");
        f.delete();
        this.noSV = numberOfSupportVectors;
        try {
            this.getDatabaseObj().commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error trying to commit the transactions for the intermediate table: " + sqle.getMessage());
        }
        String message = "Found " + numberOfSupportVectors + " support vectors, entered them into intermediate table in database.";
        message = tableExisted ? message + " Replaced " : message + " Created ";
        message = message + "intermediate database table '" + this.getModelTableName() + "'.";
        this.getPrint().doPrint(Print.OPERATOR, message);
    }

    protected void extractNumberSV() {
    }

    private void createSVM_Input(ResultSet rs, String kernelType, String c, String epsilon, OutputStream whereTo) throws M4CompilerError {
        if ((c = this.checkDouble(c)) == null) {
            throw new M4CompilerError("Wrapper for SVM: Parameter 'C' must be a real number!");
        }
        if (!this.forClassification) {
            this.lossPos = this.checkDouble(this.lossPos);
            if (this.lossPos == null) {
                throw new M4CompilerError("Wrapper for SVM: Parameter 'LossFunctionPos' must be a real number!");
            }
            this.lossNeg = this.checkDouble(this.lossNeg);
            if (this.lossNeg == null) {
                throw new M4CompilerError("Wrapper for SVM: Parameter 'LossFunctionNeg' must be a real number!");
            }
        }
        if (epsilon != null && (epsilon = this.checkDouble(epsilon)) == null) {
            throw new M4CompilerError("Wrapper for SVM: Parameter 'Epsilon' must be a real number!");
        }
        this.checkKernel(kernelType);
        PrintStream output = new PrintStream(whereTo);
        output.println("\n@parameters");
        if (this.forClassification) {
            output.println("pattern");
        } else {
            output.println("regression");
            output.println("epsilon " + epsilon);
        }
        output.println("C " + c);
        if (!this.forClassification) {
            output.println("L+ " + this.lossPos);
            output.println("L- " + this.lossNeg);
        }
        output.println("\n@kernel");
        output.println("type " + kernelType.toLowerCase());
        this.addKernelParameters(kernelType, output);
        output.println("\n@examples");
        output.println("format xy\n");
        int noOfWrittenRows = 0;
        try {
            while (rs.next()) {
                String line = "";
                for (int i = 1; i <= this.theColumnInfos.length; ++i) {
                    String entry = rs.getString(i);
                    if (this.theColumnInfos[i - 1].mappingIsUsed()) {
                        entry = this.theColumnInfos[i - 1].getMappedValue(entry);
                    }
                    if (entry == null) {
                        throw new M4CompilerError("Error producing SVM-input: found unknown or NULL entry in column with col_id = " + this.theColumnInfos[i - 1].getColumn().getId() + ": " + entry);
                    }
                    line = line + entry + " ";
                }
                output.println(line);
                ++noOfWrittenRows;
            }
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error accessing database query result: " + sqle.getMessage());
        }
        output.flush();
        output.close();
        if (noOfWrittenRows == 0) {
            throw new M4CompilerError("SVM wrapper: empty training set!");
        }
        this.getPrint().doPrint(Print.OPERATOR, "SVM read " + noOfWrittenRows + " examples.");
    }

    protected void checkKernel(String kern) throws M4CompilerError {
        if (!(kern.equalsIgnoreCase("dot") || kern.equalsIgnoreCase("polynomial") || kern.equalsIgnoreCase("radial") || kern.equalsIgnoreCase("neural") || kern.equalsIgnoreCase("anova"))) {
            throw new M4CompilerError("Support Vector Machine: unknown or disallowed kernel type: " + kern + "!");
        }
    }

    protected void checkColSetType(String type) throws M4CompilerError {
    }

    protected Vector getColNamesInput() {
        Vector<String> inputNames = new Vector<String>(this.theColumnInfos.length - 1);
        for (int i = 0; i < this.theColumnInfos.length - 1; ++i) {
            inputNames.add(this.theColumnInfos[i].getColumnName());
        }
        inputNames.trimToSize();
        return inputNames;
    }

    protected String getModelTablePlusCondition() {
        return this.getModelTableName();
    }

    private String readStream(InputStream in) throws M4CompilerError {
        StringBuffer sb;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            sb = new StringBuffer();
            String line = br.readLine();
            while (line != null) {
                sb.append(line + "\n");
                line = br.readLine();
            }
        }
        catch (IOException ioe) {
            throw new M4CompilerError("SupportVectorMachine: could not read mySVM-Output");
        }
        return sb.toString();
    }

    private void addKernelParameters(String kern, PrintStream output) {
        Vector theKernelParams = this.getKernelParams(kern);
        if (theKernelParams == null) {
            return;
        }
        for (int i = 0; i < theKernelParams.size(); ++i) {
            output.println((String)theKernelParams.get(i));
        }
    }
}

