/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.compiler.wrapper;

import edu.udo.cs.miningmart.compiler.wrapper.ColumnInfo;
import edu.udo.cs.miningmart.db.CompilerDatabaseService;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class SVM_Wrapper {
    public static final long DEFAULTSAMPLESIZE = 10000L;
    protected static final String SAMPLE_TABLE_PREFIX = "tmp1_";
    protected static final String TEMP_TABLE_PREFIX = "tmp2_";
    protected long sampleSize;
    private final CompilerDatabaseService databaseObj;
    private final Print pr;
    private final String dbPrefix;
    protected final boolean useOracle;
    protected final boolean usePostgres;
    protected String lossPos;
    protected String lossNeg;
    protected ColumnInfo[] theColumnInfos;
    private Vector theKernelParams;
    protected String targetColSQLDefinition;
    protected String schema;
    protected String inputTableName;
    protected long myStepId;
    protected String targetPositive = null;
    protected boolean forClassification;
    protected double b;
    protected double xiAlphaEstimation;
    protected int noSV;

    public SVM_Wrapper(CompilerDatabaseService databaseObj, Print printObj, String nameForDatabaseUse, String nameOfDatabaseSchema, long stepId) throws M4CompilerError {
        this.databaseObj = databaseObj;
        this.useOracle = this.databaseObj.getBusinessDbms() == 1;
        this.usePostgres = this.databaseObj.getBusinessDbms() == 2;
        this.pr = printObj;
        this.dbPrefix = nameForDatabaseUse;
        this.schema = nameOfDatabaseSchema;
        this.myStepId = stepId;
        this.xiAlphaEstimation = 0.0;
        if (this.getDatabaseObj() == null) {
            throw new M4CompilerError("Error in Support Vector Machine: got invalid db connection (null).");
        }
        this.lossPos = null;
        this.lossNeg = null;
    }

    public abstract void callSVM(Columnset var1, Column var2, long var3, String var5, String var6, String var7, Vector var8) throws M4CompilerError;

    public double getXiAlphaEstimation() {
        return this.xiAlphaEstimation;
    }

    public int getNumberOfSupportVectors() {
        return this.noSV;
    }

    protected abstract void extractXiAlpha() throws M4CompilerError;

    protected abstract void extractNumberSV() throws M4CompilerError;

    protected void checkForConversion(Columnset inputCS, Vector predictingColumns, Column targetColumn) throws M4CompilerError {
        int i;
        if (predictingColumns.isEmpty()) {
            throw new M4CompilerError("SVM wrapper: set of attributes to predict from is empty!");
        }
        int numberOfLearnAttribs = predictingColumns.size();
        this.inputTableName = inputCS.getSchemaPlusName();
        this.theColumnInfos = new ColumnInfo[numberOfLearnAttribs + 1];
        for (i = 0; i < predictingColumns.size(); ++i) {
            Column theCol = (Column)predictingColumns.get(i);
            this.theColumnInfos[i] = new ColumnInfo(theCol, this.missingValuesOccur(theCol));
        }
        this.theColumnInfos[numberOfLearnAttribs] = new ColumnInfo(targetColumn, this.missingValuesOccur(targetColumn));
        this.checkColSetType(inputCS.getType());
        this.targetColSQLDefinition = targetColumn.getSQLDefinition();
        try {
            if (this.forClassification && !targetColumn.getTheBaseAttribute().getConceptualDataTypeName().equalsIgnoreCase("BINARY")) {
                throw new M4CompilerError("SVM wrapper: Error with target attribute: must be binary for SVM_CL!");
            }
            for (i = 0; i < this.theColumnInfos.length; ++i) {
                String conceptualType = this.theColumnInfos[i].getColumn().getTheBaseAttribute().getConceptualDataTypeName();
                String columnType = this.theColumnInfos[i].getColumn().getColumnDataTypeName();
                if (conceptualType.equals("SCALAR") || conceptualType.equals("TIME") || conceptualType.equals("NUMERIC")) {
                    if (columnType.equals("DATE")) {
                        if (this.useOracle) {
                            this.theColumnInfos[i].setSelectString("to_number(to_char(" + this.theColumnInfos[i].getColumnName() + ", 'J'))");
                        }
                        if (this.usePostgres) {
                            throw new M4CompilerError("SVM Wrapper: cannot handle columns of type DATE under Postgres; found column '" + this.theColumnInfos[i].getColumnName() + "' of type DATE!");
                        }
                    } else {
                        this.theColumnInfos[i].setSelectString(this.theColumnInfos[i].getColumnName());
                    }
                    this.theColumnInfos[i].setDatatype(this.getDBMS_Datatype(columnType, this.theColumnInfos[i].getColumnName()));
                    continue;
                }
                if (!conceptualType.equals("BINARY") && !conceptualType.equals("NOMINAL")) continue;
                if (columnType.equalsIgnoreCase("STRING")) {
                    this.storeValueMappings(this.theColumnInfos[i]);
                }
                this.theColumnInfos[i].setSelectString(this.theColumnInfos[i].getColumnName());
                this.theColumnInfos[i].setDatatype(this.getDBMS_Datatype(columnType, this.theColumnInfos[i].getColumnName()));
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in SVM Wrapper: " + m4e.getMessage());
        }
    }

    private void storeValueMappings(ColumnInfo ci) throws M4CompilerError {
        try {
            String[] vs = this.getDatabaseObj().getDistinctElements(ci.getColumn().getId());
            boolean thisIsTheTargetColumn = ci.getColumn().getSQLDefinition().equalsIgnoreCase(this.targetColSQLDefinition);
            if (thisIsTheTargetColumn && this.forClassification && vs.length != 2) {
                throw new M4CompilerError("SVM_Wrapper: Classification SVM needs a binary target; found " + vs.length + " distinct values in target column '" + this.targetColSQLDefinition + "'!");
            }
            boolean positiveTargetValueFound = false;
            for (int i = 0; i < vs.length; ++i) {
                ci.setValueMapping(vs[i], "" + i);
                if (!thisIsTheTargetColumn || !this.forClassification || !vs[i].equalsIgnoreCase(this.getPositiveTargetValue())) continue;
                positiveTargetValueFound = true;
            }
            if (thisIsTheTargetColumn && this.forClassification && !positiveTargetValueFound) {
                throw new M4CompilerError("SVM_Wrapper: the positive target value '" + this.getPositiveTargetValue() + "' was not found in the target column '" + this.targetColSQLDefinition + "'!");
            }
        }
        catch (M4CompilerError mce) {
            throw new M4CompilerError("SVM_Wrapper: could not set mapped values for column '" + ci.getColumnName() + "': " + mce.getMessage());
        }
    }

    private boolean missingValuesOccur(Column col) throws M4CompilerError {
        String sql = "SELECT COUNT(*) FROM " + this.inputTableName + " WHERE " + col.getSQLDefinition() + " IS NULL";
        try {
            Long l = this.getDatabaseObj().executeBusinessSingleValueSqlReadL(sql);
            return l > 0L;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SVM_Wrapper: Sql exception caught when trying to find out if column '" + col.getSQLDefinition() + "' in table '" + this.inputTableName + "' has NULL values: " + sqle.getMessage());
        }
        catch (DbConnectionClosed db) {
            throw new M4CompilerError("Error trying to find out if column '" + col.getName() + "' in table '" + this.inputTableName + "' has NULL values: " + "connection to DB was closed: " + db.getMessage());
        }
    }

    protected String getCompleteSelectString() {
        if (this.theColumnInfos == null) {
            return null;
        }
        String select = "";
        for (int i = 0; i < this.theColumnInfos.length; ++i) {
            select = select + this.theColumnInfos[i].getSelectString() + ", ";
        }
        select = select.substring(0, select.length() - 2);
        return select;
    }

    protected String getDBMS_Datatype(String m4ColumnDatatype, String columnName) throws M4CompilerError {
        if (m4ColumnDatatype.equals("DATE") && this.usePostgres) {
            throw new M4CompilerError("SVM_Wrapper.java#getDBMS_Datatype: can't support M4 column datatype 'DATE' under Postgres! Column: " + columnName);
        }
        if (m4ColumnDatatype.equals("KEY")) {
            throw new M4CompilerError("SVM_Wrapper.java#getDBMS_Datatype(): found M4 column datatype 'KEY' for column '" + columnName + "'. Not supported.");
        }
        boolean useBusinessDBMS = true;
        String ret = this.getDatabaseObj().getDbNameOfM4Datatype(m4ColumnDatatype, 0, useBusinessDBMS);
        if (ret == null) {
            throw new M4CompilerError("SVM_Wrapper: found unknown M4 column datatype '" + m4ColumnDatatype + "' for column '" + columnName);
        }
        return ret;
    }

    protected String getSampleRatio(long maxSample, String tableName) throws M4CompilerError {
        if (maxSample <= 0L) {
            throw new M4CompilerError("Wrapper for SupportVectorMachine: Sample Size must be positive! Found: " + maxSample + ".");
        }
        String sql_getNumberOfRecords = "SELECT count(*) FROM " + tableName + " WHERE " + this.targetColSQLDefinition + " is not null";
        long count = 0L;
        try {
            Long countL = this.getDatabaseObj().executeBusinessSingleValueSqlReadL(sql_getNumberOfRecords);
            if (countL == null) {
                throw new M4CompilerError("Wrapper for SVM: Could not read result from query: " + sql_getNumberOfRecords);
            }
            count = countL;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Wrapper for SVM: Could not read result from query: " + sql_getNumberOfRecords + ", Database problem: " + sqle.getMessage());
        }
        if (maxSample > count) {
            maxSample = count;
        }
        double sampleRatio = (double)maxSample / (double)count;
        String integerSampleRatio = Double.toString(sampleRatio *= 1000000.0);
        if (integerSampleRatio.indexOf(".") > -1) {
            integerSampleRatio = integerSampleRatio.substring(0, integerSampleRatio.indexOf("."));
        }
        return integerSampleRatio;
    }

    protected void createDecisionFunctionAsSQL_Function(String kernelType) throws M4CompilerError {
        String theFunction = this.createDecisionFunctionTemplate();
        String declaration = this.createDeclaration(kernelType);
        if (declaration == null) {
            throw new M4CompilerError("Error: null-declaration in SQL decision function; check kernel type!");
        }
        String body = this.createBody(kernelType);
        if (body == null) {
            throw new M4CompilerError("Error trying to create body of SQL decision function; check kernel type!");
        }
        theFunction = this.replace(theFunction, "$DECLARATION", declaration);
        theFunction = this.replace(theFunction, "$BODY", body);
        this.insertFunctionIntoDB(theFunction);
    }

    protected String createDeclaration(String kernelType) throws M4CompilerError {
        int i;
        Vector colNamesInput = this.getColNamesInput();
        String declaration = "";
        if (this.useOracle) {
            declaration = declaration + "    CURSOR supportvectors IS\n      SELECT ";
            for (i = 0; i < colNamesInput.size(); ++i) {
                declaration = declaration + (String)colNamesInput.get(i) + ", ";
            }
            declaration = declaration + "Alpha FROM " + this.getModelTablePlusCondition() + ";\n";
            declaration = declaration + "    currentrow supportvectors%ROWTYPE;\n";
        }
        if (this.usePostgres) {
            for (i = 1; i <= colNamesInput.size(); ++i) {
                declaration = declaration + "    X_" + this.theColumnInfos[i - 1].getColumnName() + " ALIAS FOR $" + i + ";\n";
            }
            declaration = declaration + "    currentrow " + this.getModelTableName() + "%ROWTYPE;\n";
        }
        String numberTypeName = this.getDBMS_Datatype("NUMBER", null);
        declaration = declaration + "    kernel " + numberTypeName + ";\n";
        declaration = declaration + "    inner " + numberTypeName + ";\n";
        return declaration;
    }

    protected String createBody(String kernelType) throws M4CompilerError {
        String body = null;
        String param1 = null;
        String param2 = null;
        int dimension = this.theColumnInfos.length - 1;
        if (kernelType.equalsIgnoreCase("dot") && this.theKernelParams != null || (kernelType.equalsIgnoreCase("polynomial") || kernelType.equalsIgnoreCase("radial")) && this.theKernelParams.size() != 1 || (kernelType.equalsIgnoreCase("neural") || kernelType.equalsIgnoreCase("anova")) && this.theKernelParams.size() != 2) {
            throw new M4CompilerError("SVM Wrapper error: Found wrong number of kernel parameters!");
        }
        if (!kernelType.equalsIgnoreCase("dot")) {
            String params = (String)this.theKernelParams.get(0);
            StringTokenizer st = new StringTokenizer(params);
            if (!st.hasMoreTokens()) {
                throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
            }
            params = st.nextToken();
            if (!st.hasMoreTokens()) {
                throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
            }
            param1 = st.nextToken();
            try {
                Double.parseDouble(param1);
            }
            catch (NumberFormatException nfe) {
                throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
            }
            if (kernelType.equalsIgnoreCase("neural") || kernelType.equalsIgnoreCase("anova")) {
                params = (String)this.theKernelParams.get(1);
                st = new StringTokenizer(params);
                if (!st.hasMoreTokens()) {
                    throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
                }
                params = st.nextToken();
                if (!st.hasMoreTokens()) {
                    throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
                }
                param2 = st.nextToken();
                try {
                    Double.parseDouble(param2);
                }
                catch (NumberFormatException nfe) {
                    throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
                }
            }
        }
        String operator = null;
        Vector colNamesInput = this.getColNamesInput();
        operator = kernelType.equalsIgnoreCase("polynomial") || kernelType.equalsIgnoreCase("neural") || kernelType.equalsIgnoreCase("dot") ? " * " : " - ";
        body = "    retValue := 0;\n";
        if (this.useOracle) {
            body = body + "    FOR currentrow IN supportvectors\n    LOOP\n";
        }
        if (this.usePostgres) {
            body = body + "    FOR currentrow IN\n";
            body = body + "        SELECT ";
            for (int i = 0; i < colNamesInput.size(); ++i) {
                body = body + (String)colNamesInput.get(i) + ", ";
            }
            body = body + "Alpha\n";
            body = body + "        FROM " + this.getModelTablePlusCondition() + "\n";
            body = body + "    LOOP\n";
        }
        body = body + "      inner := ";
        String component = null;
        for (int i = 0; i < dimension; ++i) {
            component = this.theColumnInfos[i].mappingIsUsed() ? "(currentrow." + (String)colNamesInput.get(i) + operator + "help" + i + ")" : (this.theColumnInfos[i].getDatatype().equals("DATE") ? "(currentrow." + (String)colNamesInput.get(i) + operator + "help" + i + i + ")" : "(currentrow." + (String)colNamesInput.get(i) + operator + "X_" + this.theColumnInfos[i].getColumnName() + ")");
            body = kernelType.equalsIgnoreCase("radial") ? body + component + " * " + component : (kernelType.equalsIgnoreCase("anova") ? body + "EXP( -" + param1 + " * " + component + ")" : body + component);
            if (i >= dimension - 1) continue;
            body = body + "\n               + ";
        }
        if (kernelType.equalsIgnoreCase("polynomial")) {
            body = body + ";\n      kernel := POWER(inner + 1, " + param1 + ") ";
        }
        if (kernelType.equalsIgnoreCase("neural")) {
            body = body + ";\n      kernel := TANH(inner * " + param1 + " + " + param2 + ") ";
        }
        if (kernelType.equalsIgnoreCase("dot")) {
            body = body + ";\n      kernel := inner ";
        }
        if (kernelType.equalsIgnoreCase("radial")) {
            body = body + ";\n      kernel := EXP( -(" + param1 + ") * inner) ";
        }
        if (kernelType.equalsIgnoreCase("anova")) {
            body = body + ";\n      kernel := POWER(inner, " + param2 + ") ";
        }
        body = body + "* currentrow.Alpha;\n";
        body = body + "      retValue := retValue + kernel;\n";
        body = body + "    END LOOP;\n";
        body = body + "    retValue := retValue + (" + this.b + ");\n";
        return body;
    }

    protected void insertFunctionIntoDB(String theFunction) throws M4CompilerError {
        try {
            CompilerDatabaseService db = this.getDatabaseObj();
            db.executeBusinessSqlWrite(theFunction);
            db.commitBusinessTransactions();
            String decisionFunction = null;
            if (this.useOracle) {
                decisionFunction = this.getDecisionFunctionName();
            }
            if (this.usePostgres) {
                decisionFunction = this.getDecisionFunctionNameWithArgumentTypes();
            }
            db.addFunctionToTrash(decisionFunction, this.schema, this.myStepId);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SVM wrapper: Error trying to insert SQL result function into database: " + sqle.getMessage());
        }
    }

    protected String replace(String theString, String searchFor, String replaceBy) {
        int i = theString.indexOf(searchFor);
        String newString = "";
        int b = 0;
        while (i > -1) {
            newString = newString + theString.substring(b, i);
            newString = newString + replaceBy;
            b = i + searchFor.length();
            i = theString.indexOf(searchFor, b);
        }
        if (b < theString.length()) {
            newString = newString + theString.substring(b);
        }
        return newString;
    }

    protected String createDecisionFunctionTemplate() throws M4CompilerError {
        int i;
        int dimension = this.theColumnInfos.length - 1;
        String theFunction = "CREATE OR REPLACE function ";
        if (this.useOracle) {
            theFunction = theFunction + this.getDecisionFunctionName();
        }
        if (this.usePostgres) {
            theFunction = theFunction + this.getDecisionFunctionNameWithSchema();
        }
        theFunction = theFunction + "\n(\n";
        for (int i2 = 0; i2 < dimension; ++i2) {
            if (this.useOracle) {
                theFunction = theFunction + "X_" + this.theColumnInfos[i2].getColumnName() + " IN " + this.theColumnInfos[i2].getDatatype();
            }
            if (this.usePostgres) {
                theFunction = theFunction + this.theColumnInfos[i2].getDatatype();
            }
            if (i2 >= dimension - 1) continue;
            theFunction = theFunction + ",\n";
        }
        if (this.useOracle) {
            theFunction = theFunction + "\n)\nRETURN NUMBER\nAS\nBEGIN\n";
        }
        if (this.usePostgres) {
            theFunction = theFunction + "\n)\nRETURNS NUMERIC\nAS '\n";
        }
        String numbertype = this.getDBMS_Datatype("NUMBER", null);
        theFunction = theFunction + "  DECLARE\n";
        theFunction = theFunction + "    retValue " + numbertype + ";\n";
        for (i = 0; i < dimension; ++i) {
            if (this.theColumnInfos[i].mappingIsUsed()) {
                theFunction = theFunction + "    help" + i + " " + numbertype + ";\n";
            }
            if (!this.theColumnInfos[i].getDatatype().equals("DATE")) continue;
            theFunction = theFunction + "    help" + i + i + " " + numbertype + ";\n";
        }
        theFunction = theFunction + "$DECLARATION\n";
        theFunction = theFunction + "  BEGIN\n";
        for (i = 0; i < dimension; ++i) {
            if (this.theColumnInfos[i].mappingIsUsed()) {
                String value;
                Iterator it = this.theColumnInfos[i].getValuesIterator();
                if (it.hasNext()) {
                    value = (String)it.next();
                    theFunction = theFunction + "    IF X_" + this.theColumnInfos[i].getColumnName() + " = '" + value + "'\n" + "      THEN help" + i + " := " + this.theColumnInfos[i].getMappedValue(value) + ";\n";
                }
                while (it.hasNext()) {
                    value = (String)it.next();
                    theFunction = theFunction + "    ELSIF X_" + this.theColumnInfos[i].getColumnName() + " = '" + value + "'\n" + "      THEN help" + i + " := " + this.theColumnInfos[i].getMappedValue(value) + ";\n";
                }
                theFunction = theFunction + "    END IF;\n";
            }
            if (!this.theColumnInfos[i].getDatatype().equals("DATE")) continue;
            theFunction = theFunction + "    help" + i + i + " := to_number(to_char(X_" + this.theColumnInfos[i].getColumnName() + ", 'J'));\n";
        }
        theFunction = theFunction + "\n$BODY\n";
        theFunction = this.forClassification ? theFunction + "    IF (retValue > 0)\n      THEN RETURN 1;\n    END IF;\n    RETURN -1;\n" : theFunction + "    RETURN retValue;\n";
        theFunction = theFunction + "  END;\n";
        if (this.useOracle) {
            theFunction = theFunction + "END;\n";
        }
        if (this.usePostgres) {
            theFunction = theFunction + "' LANGUAGE 'plpgsql';";
        }
        return theFunction;
    }

    protected String checkDouble(String test) throws M4CompilerError {
        int a = test.indexOf(",");
        if (a > -1) {
            String pre = test.substring(0, a);
            String post = test.substring(a + 1);
            test = pre + "." + post;
        }
        if (test.startsWith(".")) {
            test = "0" + test;
        }
        try {
            Double.parseDouble(test);
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("SVM wrapper: Error trying to convert '" + test + "' into double.");
        }
        return test;
    }

    protected void setPositiveTargetValue(String posValue) {
        this.targetPositive = posValue;
    }

    protected String getPositiveTargetValue() {
        return this.targetPositive;
    }

    protected abstract void checkKernel(String var1) throws M4CompilerError;

    protected abstract String getModelTablePlusCondition() throws M4CompilerError;

    protected abstract Vector getColNamesInput();

    protected abstract void checkColSetType(String var1) throws M4CompilerError;

    protected CompilerDatabaseService getDatabaseObj() {
        return this.databaseObj;
    }

    protected String getParTableName() {
        return this.dbPrefix + "_PAR";
    }

    protected String getLogTableName() {
        return this.dbPrefix + "_LOG";
    }

    protected String getOutputViewName() {
        return this.dbPrefix + "_OUT";
    }

    protected String getInputViewName() {
        return this.dbPrefix + "_IN";
    }

    protected String getModelTableName() {
        return this.dbPrefix + "_MOD";
    }

    public String getDecisionFunctionName() {
        return this.dbPrefix + "_F";
    }

    protected String getDecisionFunctionNameWithArgumentTypes() {
        String theName = this.getDecisionFunctionName() + "(";
        for (int i = 0; i < this.theColumnInfos.length - 1; ++i) {
            theName = theName + this.theColumnInfos[i].getColumnName() + ",";
        }
        theName = theName.substring(0, theName.length() - 1) + ")";
        return theName;
    }

    public String getDecisionFunctionNameWithSchema() throws M4CompilerError {
        if (this.schema == null || this.schema.equals("")) {
            throw new M4CompilerError("SVM Wrapper: Postgres needs the fully qualified Function name, but schema is not available!");
        }
        return this.schema + "." + this.getDecisionFunctionName();
    }

    protected Print getPrint() {
        return this.pr;
    }

    protected Vector getKernelParams(String kern) {
        this.theKernelParams = new Vector();
        if (kern.toLowerCase().equals("dot")) {
            this.theKernelParams = null;
            return null;
        }
        if (kern.toLowerCase().equals("polynomial")) {
            this.theKernelParams.add("degree 2");
        }
        if (kern.toLowerCase().equals("neural")) {
            this.theKernelParams.add("a 0.5");
            this.theKernelParams.add("b 0.5");
        }
        if (kern.toLowerCase().equals("radial")) {
            this.theKernelParams.add("gamma 0.1");
        }
        if (kern.toLowerCase().equals("anova")) {
            this.theKernelParams.add("gamma 0.1");
            this.theKernelParams.add("degree 2");
        }
        this.theKernelParams.trimToSize();
        return this.theKernelParams;
    }
}

