/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.compiler.utils;

import edu.udo.cs.miningmart.compiler.utils.Sampling;
import edu.udo.cs.miningmart.db.CompilerDatabaseService;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.m4.Columnset;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;

public class RandomPartition
extends Sampling {
    private final String[] destTableNames;
    private final boolean stopWithTempTable;

    public RandomPartition(Columnset sourceCs, Collection selectedColumns, String[] destTableNames, boolean stopWithTempTable, String tempTable, Long rowcount, Long seed, CompilerDatabaseService db) throws M4CompilerError {
        super(sourceCs, selectedColumns, tempTable, rowcount, seed, db);
        this.destTableNames = destTableNames;
        this.stopWithTempTable = stopWithTempTable;
        try {
            this.createTempTable();
            if (!this.isStopWithTempTable()) {
                this.joinSourceWithTempTable();
                this.deleteTable(this.getTempTableName());
            }
            db.commitBusinessTransactions();
        }
        catch (SQLException e) {
            throw new M4CompilerError("miningmart.compiler.utils.DrawSample:\n" + e.getMessage());
        }
    }

    private String getDestTableName(int i) {
        String[] dtm = this.destTableNames;
        if (dtm != null && i > 0 && i < dtm.length) {
            return this.destTableNames[i];
        }
        return null;
    }

    private int getHowMany() {
        return this.destTableNames.length;
    }

    private int getNextRandomPartition() {
        double d = this.getNextRandomDouble();
        return (int)(d *= (double)this.getHowMany());
    }

    private void createTempTable() throws M4CompilerError, SQLException {
        this.deleteTable(this.getTempTableName());
        this.dbWrite("CREATE TABLE " + this.getTempTableName() + " ( the_Id " + this.numericDatatypeName + ", the_Segment " + this.numericDatatypeName + " )");
        String prefix = "INSERT INTO " + this.getTempTableName() + " VALUES ( ";
        String separ = ", ";
        String suffix = " )";
        long loops = this.getRowCount();
        long commitCounter = 0L;
        Iterator it = null;
        if (this.usingPostgres) {
            it = this.allRowIds.iterator();
        }
        for (long i = 1L; i <= loops; ++i) {
            Long nextNumber = this.usingPostgres ? (Long)it.next() : new Long(i);
            int partition = this.getNextRandomPartition();
            this.dbWrite(prefix + nextNumber + ", " + partition + " )");
            if (++commitCounter < 10000L) continue;
            this.commit();
            commitCounter = 0L;
        }
    }

    private void joinSourceWithTempTable() throws M4CompilerError, SQLException {
        int howMany = this.getHowMany();
        for (int segmentNumber = 0; segmentNumber < howMany; ++segmentNumber) {
            String destTable = this.getDestTableName(segmentNumber);
            String sqlDefs = this.getSourceAttributeDefinitions();
            String colNames = this.getSourceAttributes();
            this.deleteTable(destTable);
            String idAttr = "ROW_NUM_";
            while (colNames.indexOf(idAttr) >= 0) {
                idAttr = idAttr + "Z";
            }
            String innerQuery = "( SELECT " + this.rowIdentifierName + " AS " + idAttr + ", " + sqlDefs + " FROM " + this.getSourceTableName() + " )";
            String query = "CREATE TABLE " + destTable + " AS SELECT " + colNames + " FROM " + this.getTempTableName() + " T, " + innerQuery + " S" + " WHERE t.the_Segment = " + segmentNumber + " AND s." + idAttr + " = t.the_Id";
            this.dbWrite(query);
        }
    }

    public boolean isStopWithTempTable() {
        return this.stopWithTempTable;
    }
}

