/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.compiler.utils;

import edu.udo.cs.miningmart.compiler.utils.Sampling;
import edu.udo.cs.miningmart.db.CompilerDatabaseService;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.m4.Columnset;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;

public class DrawSample
extends Sampling {
    private final String destTable;
    private final double ratio;

    public DrawSample(Columnset sourceCs, String destTable, String tempTable, double ratio, CompilerDatabaseService db) throws M4CompilerError {
        this(sourceCs, destTable, tempTable, null, ratio, null, db);
    }

    public DrawSample(Columnset sourceCs, String destTable, String tempTable, Long rowcount, double ratio, Long seed, CompilerDatabaseService db) throws M4CompilerError {
        super(sourceCs, null, tempTable, rowcount, seed, db);
        this.destTable = destTable;
        this.ratio = ratio;
        try {
            this.createTempTable();
            this.joinSourceWithTempTable();
            this.deleteTable(this.getTempTableName());
            db.commitBusinessTransactions();
        }
        catch (SQLException e) {
            this.deleteTable(this.getTempTableName());
            this.deleteTable(this.getDestTableName());
            throw new M4CompilerError("miningmart.compiler.utils.DrawSample:\n" + e.getMessage());
        }
    }

    public DrawSample(Columnset sourceCs, String destTable, String tempTable, Long rowcount, long sampleSize, Long seed, CompilerDatabaseService db) throws M4CompilerError {
        this(sourceCs, null, destTable, tempTable, rowcount, sampleSize, seed, db);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DrawSample(Columnset sourceCs, Collection selectedColumns, String destTable, String tempTable, Long rowcount, long sampleSize, Long seed, CompilerDatabaseService db) throws M4CompilerError {
        super(sourceCs, selectedColumns, tempTable, rowcount, seed, db);
        this.destTable = destTable;
        this.ratio = (double)sampleSize / (double)this.getRowCount();
        try {
            try {
                this.createTempTable();
                this.joinSourceWithTempTable();
                this.deleteTable(this.getTempTableName());
                db.commitBusinessTransactions();
            }
            catch (SQLException e) {
                this.deleteTable(this.getTempTableName());
                this.deleteTable(this.getDestTableName());
                throw new M4CompilerError("miningmart.compiler.utils.DrawSample:\n" + e.getMessage());
            }
            Object var12_9 = null;
            if (!this.materializedInput) return;
        }
        catch (Throwable throwable) {
            Object var12_10 = null;
            if (!this.materializedInput) throw throwable;
            this.deleteTable(this.getSourceTableName());
            throw throwable;
        }
        this.deleteTable(this.getSourceTableName());
    }

    public String getDestTableName() {
        return this.destTable;
    }

    public boolean getNextBoolean() {
        return this.getNextRandomDouble() <= this.ratio;
    }

    private void createTempTable() throws M4CompilerError, SQLException {
        this.deleteTable(this.getTempTableName());
        this.dbWrite("CREATE TABLE " + this.getTempTableName() + " ( the_Id " + this.numericDatatypeName + " )");
        String prefix = "INSERT INTO " + this.getTempTableName() + " VALUES ( ";
        String suffix = " )";
        long loops = this.getRowCount();
        long commitCounter = 0L;
        Iterator it = null;
        if (this.usingPostgres) {
            it = this.allRowIds.iterator();
        }
        for (long i = 1L; i <= loops; ++i) {
            Long nextNumber;
            Long l = nextNumber = this.usingPostgres ? (Long)it.next() : new Long(i);
            if (!this.getNextBoolean()) continue;
            this.dbWrite(prefix + nextNumber.toString() + " )");
            if (++commitCounter < 10000L) continue;
            this.commit();
            commitCounter = 0L;
        }
        this.commit();
    }

    private void joinSourceWithTempTable() throws M4CompilerError, SQLException {
        String destTable = this.getDestTableName();
        String sqlDefs = this.getSourceAttributeDefinitions();
        String colNames = this.getSourceAttributes();
        this.deleteTable(destTable);
        String idAttr = "ROW_NUM_";
        while (colNames.indexOf(idAttr) >= 0) {
            idAttr = idAttr + "Z";
        }
        String innerQuery = "";
        innerQuery = "( SELECT " + this.rowIdentifierName + " AS " + idAttr + ", " + sqlDefs + " FROM " + this.getSourceTableName() + " )";
        String query = "CREATE TABLE " + destTable + " AS SELECT " + colNames + " FROM " + this.getTempTableName() + " T, " + innerQuery + " S" + " WHERE s." + idAttr + " = t.the_Id";
        this.dbWrite(query);
    }
}

