/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.compiler.utils;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.core.Case;
import edu.udo.cs.miningmart.m4.core.Chain;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.Columnset;
import edu.udo.cs.miningmart.m4.core.Concept;
import edu.udo.cs.miningmart.m4.core.Operator;
import edu.udo.cs.miningmart.m4.core.Parameter;
import edu.udo.cs.miningmart.m4.core.ParameterObject;
import edu.udo.cs.miningmart.m4.core.Step;
import edu.udo.cs.miningmart.m4.core.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class AttributeCreationTool {
    protected final DB myDB;
    protected final Case myCase;
    protected final Concept myInputConcept;
    protected final Chain myChain;
    protected final Columnset myInputColumnset;
    protected final Column myIndexColumn;
    protected final edu.udo.cs.miningmart.m4.core.BaseAttribute myIndexBA;
    protected Step myStep;
    protected Operator myOperator;
    protected int numOfLoops;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Step;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Operator;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$BaseAttribute;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Parameter;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Value;

    public AttributeCreationTool(edu.udo.cs.miningmart.m4.Concept inputConcept, BaseAttribute indexBA, edu.udo.cs.miningmart.m4.Chain chain) throws M4Exception {
        String msgIntro = "Constructor of " + this.getClass().getName() + ":\n";
        if (inputConcept == null || indexBA == null || chain == null) {
            throw new M4Exception(msgIntro + "<null> argument found!");
        }
        if (!inputConcept.equals(indexBA.getConcept())) {
            throw new M4Exception(msgIntro + "The specified index BaseAttribute does not belong to the InputConcept!");
        }
        this.myDB = inputConcept.getM4Db();
        this.myInputConcept = (Concept)inputConcept;
        this.myChain = (Chain)chain;
        this.myCase = (Case)inputConcept.getTheCase();
        this.myIndexBA = (edu.udo.cs.miningmart.m4.core.BaseAttribute)indexBA;
        if (this.myCase == null || !this.myCase.equals(chain.getTheCase())) {
            throw new M4Exception(msgIntro + "InputConcept and Chain are not part of the same Case!");
        }
        Collection csCollection = this.myInputConcept.getColumnSets();
        if (csCollection.size() != 1) {
            throw new M4Exception(msgIntro + "InputConcept must have exactly one Columnset, but has" + csCollection.size() + "!");
        }
        this.myInputColumnset = (Columnset)csCollection.iterator().next();
        if (this.myInputColumnset == null) {
            throw new M4Exception(msgIntro + "InputConcept has no Columnset (NULL entry in Columnset list)!");
        }
        Collection indexColCollection = indexBA.getColumns();
        if (indexColCollection.size() != 1) {
            boolean exception = true;
            if (indexColCollection.size() > 1) {
                Iterator it = indexColCollection.iterator();
                while (it.hasNext()) {
                    Column col = (Column)it.next();
                    if (col == null || !this.myInputColumnset.equals(col.getColumnset())) continue;
                    this.myDB.getCasePrintObject().doPrint(Print.MAX, msgIntro + "WARNING: found multiple Columns in Index BaseAttribute, choosing the one linked to the found Columnset!");
                    indexColCollection.clear();
                    indexColCollection.add(col);
                    exception = false;
                    break;
                }
            }
            if (exception) {
                throw new M4Exception(msgIntro + "Found no (suitable) Column for Index BaseAttribute!");
            }
        }
        this.myIndexColumn = (Column)indexColCollection.iterator().next();
        if (this.myIndexColumn == null) {
            throw new M4Exception(msgIntro + "Index BaseAttribute has a null entry instead of the column!");
        }
    }

    public void execute() throws Exception {
        Iterator it = this.createOutputBAs().iterator();
        this.createStep();
        while (it.hasNext()) {
            Object[] array = (Object[])it.next();
            String val = (String)array[0];
            edu.udo.cs.miningmart.m4.core.BaseAttribute newBa = (edu.udo.cs.miningmart.m4.core.BaseAttribute)array[1];
            this.createLoopForBa(newBa, val);
        }
        this.updateLoopNr();
        this.myDB.getCasePrintObject().doPrint(Print.OPERATOR, this.getClass().getName() + ": Writing changes to M4 database!");
        this.commit();
    }

    protected abstract int getIdOfOperator();

    protected abstract String getNameOfOperator();

    protected abstract String getNameOfNewStep();

    protected abstract String getConceptualDatatypeNameOfNewAttributes() throws M4Exception;

    protected abstract void insertSpecificParameters(int var1, int var2, String var3) throws M4Exception;

    protected void createStep() throws M4Exception {
        Step newStep = (Step)this.myDB.createNewInstance(class$edu$udo$cs$miningmart$m4$core$Step == null ? (class$edu$udo$cs$miningmart$m4$core$Step = AttributeCreationTool.class$("edu.udo.cs.miningmart.m4.core.Step")) : class$edu$udo$cs$miningmart$m4$core$Step);
        newStep.setTheCase(this.myCase);
        newStep.setTheChain(this.myChain);
        int stepNr = this.myCase.getTheSteps().size();
        String stepName = stepNr + " " + this.getNameOfNewStep();
        newStep.setName(stepName);
        newStep.setNumber(stepNr);
        this.myOperator = (Operator)this.myDB.getM4Object(this.getIdOfOperator(), class$edu$udo$cs$miningmart$m4$core$Operator == null ? (class$edu$udo$cs$miningmart$m4$core$Operator = AttributeCreationTool.class$("edu.udo.cs.miningmart.m4.core.Operator")) : class$edu$udo$cs$miningmart$m4$core$Operator);
        if (this.myOperator == null || !this.myOperator.getName().equals(this.getNameOfOperator())) {
            throw new M4Exception("PivotizeWithoutAggregation: Could not find operator " + this.getNameOfOperator() + "," + " expected to have ID " + this.getIdOfOperator() + "!");
        }
        newStep.setTheOperator(this.myOperator);
        this.numOfLoops = 0;
        newStep.setLoopCount(this.numOfLoops);
        this.myStep = newStep;
        this.createParameterForNewStep(this.numOfLoops, 1, "TheInputConcept", true, this.myInputConcept);
    }

    protected void createLoopForBa(edu.udo.cs.miningmart.m4.core.BaseAttribute outputBa, String targetValS) throws M4Exception {
        int loopNr = ++this.numOfLoops;
        int parNr = 2;
        this.createParameterForNewStep(loopNr, parNr++, "TheTargetAttribute", true, this.myIndexBA);
        this.createParameterForNewStep(loopNr, parNr++, "TheOutputAttribute", false, outputBa);
        this.insertSpecificParameters(loopNr, parNr, targetValS);
    }

    protected Collection createOutputBAs() throws M4Exception, M4CompilerError {
        Vector<Object[]> newBaCollection = new Vector<Object[]>();
        String query = "SELECT DISTINCT " + this.myIndexColumn.getSQLDefinition() + " FROM " + this.myInputColumnset.getSQLDefinition();
        String baNamePre = this.myIndexBA.getName() + "_";
        ResultSet rs = null;
        try {
            rs = this.myDB.executeBusinessSqlRead(query);
            while (rs.next()) {
                String value = rs.getString(1);
                if (rs.wasNull()) continue;
                edu.udo.cs.miningmart.m4.core.BaseAttribute newBa = (edu.udo.cs.miningmart.m4.core.BaseAttribute)this.myDB.createNewInstance(class$edu$udo$cs$miningmart$m4$core$BaseAttribute == null ? AttributeCreationTool.class$("edu.udo.cs.miningmart.m4.core.BaseAttribute") : class$edu$udo$cs$miningmart$m4$core$BaseAttribute);
                newBa.setName(baNamePre + value);
                newBa.setConceptualDataTypeName(this.myIndexBA.getConceptualDataTypeName());
                newBa.setDBAttrib(false);
                newBa.setConcept(this.myInputConcept);
                Object[] baData = new Object[]{value, newBa};
                newBaCollection.add(baData);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new M4Exception("PivotizeWithoutAggregation: SQLException caught when reading distinct values of index attribute: " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                DB.closeResultSet(rs);
                throw throwable;
            }
        }
        DB.closeResultSet(rs);
        this.myDB.getCasePrintObject().doPrint(Print.OPERATOR, "PivotizeWithoutAggregation: Successfully created BaseAttributes for " + newBaCollection.size() + " values!");
        return newBaCollection;
    }

    protected void createParameterForNewStep(int loopNr, int parNr, String parName, boolean isInput, ParameterObject theParObject) throws M4Exception {
        Parameter newPar = (Parameter)this.myDB.createNewInstance(class$edu$udo$cs$miningmart$m4$core$Parameter == null ? (class$edu$udo$cs$miningmart$m4$core$Parameter = AttributeCreationTool.class$("edu.udo.cs.miningmart.m4.core.Parameter")) : class$edu$udo$cs$miningmart$m4$core$Parameter);
        newPar.setName(parName + loopNr);
        newPar.setTheParameterObject(theParObject);
        newPar.setTheOperator(this.myOperator);
        newPar.setIsInputParam(isInput);
        newPar.setParamNr(parNr);
        newPar.setTheStep(this.myStep);
        newPar.setLoopNr(loopNr);
    }

    protected void createInputValueParameter(String parameterName, int loopNr, String value, int valCondDT, int parNr) throws M4Exception {
        Value valueObj = (Value)this.myDB.createNewInstance(class$edu$udo$cs$miningmart$m4$core$Value == null ? (class$edu$udo$cs$miningmart$m4$core$Value = AttributeCreationTool.class$("edu.udo.cs.miningmart.m4.core.Value")) : class$edu$udo$cs$miningmart$m4$core$Value);
        String valueName = parameterName + "_" + loopNr;
        valueObj.setName(valueName);
        valueObj.setType(valCondDT);
        valueObj.setValue(value);
        this.createParameterForNewStep(loopNr, parNr, parameterName, true, valueObj);
    }

    private void updateLoopNr() throws M4Exception {
        this.myStep.setLoopCount(this.numOfLoops);
    }

    private void commit() throws M4Exception {
        this.myDB.updateDatabase();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

