/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.compiler;

import edu.udo.cs.miningmart.compiler.CompilerAccessLogic;
import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;

public class CreateCompiler {
    private final String dbConfig;
    private CompilerAccessLogic c;
    private Level verbosity = Level.ALL;

    public static void main(String[] args) throws Exception {
        block5: {
            CreateCompiler c;
            block7: {
                String command;
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block8: {
                                                    block6: {
                                                        if (args.length <= 2) break block5;
                                                        c = new CreateCompiler(args[0]);
                                                        command = args[1];
                                                        int numArgs = args.length;
                                                        String[] tmp = new String[numArgs - 2];
                                                        for (int i = 0; i < tmp.length; ++i) {
                                                            tmp[i] = args[i + 2];
                                                        }
                                                        args = tmp;
                                                        if (!command.equals("step")) break block6;
                                                        c.compileStep(args);
                                                        break block7;
                                                    }
                                                    if (!command.equalsIgnoreCase("stepFrom")) break block8;
                                                    c.compileStepFrom(args);
                                                    break block7;
                                                }
                                                if (!command.equalsIgnoreCase("case")) break block9;
                                                c.compileCase(args);
                                                break block7;
                                            }
                                            if (!command.equalsIgnoreCase("status")) break block10;
                                            c.printStatus(args);
                                            break block7;
                                        }
                                        if (!command.equalsIgnoreCase("stat-con")) break block11;
                                        c.updateConceptStatistics(args);
                                        break block7;
                                    }
                                    if (!command.equalsIgnoreCase("stat-cs")) break block12;
                                    c.updateColumnsetStatistics(args);
                                    break block7;
                                }
                                if (!command.equalsIgnoreCase("stat-col")) break block13;
                                c.updateColumnStatistics(args);
                                break block7;
                            }
                            if (!command.equalsIgnoreCase("gc-step")) break block14;
                            c.garbageCollectionForStep(args);
                            break block7;
                        }
                        if (!command.equalsIgnoreCase("gc-case")) break block15;
                        c.garbageCollectionForCase(args);
                        break block7;
                    }
                    if (!command.equalsIgnoreCase("ready")) break block16;
                    c.checkStepReady(args);
                    break block7;
                }
                if (!command.equalsIgnoreCase("restOf")) break block5;
                c.compileRestOfCase(args);
            }
            DB db = c.getCompilerAccess().getM4db();
            if (db != null) {
                db.updateDatabase();
            }
            System.exit(0);
        }
        System.err.println("Usage: java miningmart.compiler.CreateCompiler <db.config file>\n          status   <caseId> [ numberOfLines ]\n        | case     <caseId> [<lazy> [<verbosity>]]\n        | step     <stepId> [<lazy> [<verbosity>]]\n        | stepFrom <stepId> [<lazy> [<verbosity>]]\n        | restOf   <caseId> [<lazy> [<verbosity>]]\n         | stat-con <conceptId>\n        | stat-cs  <columnsetId>\n        | stat-col <columnId>\n        | gc-step  <stepId>\n        | gc-case  <caseId>\n        | ready    <stepId>\n");
        System.exit(-1);
    }

    private CreateCompiler(String dbConfig) {
        this.dbConfig = dbConfig;
    }

    private CompilerAccessLogic getCompilerAccess() throws IOException, SQLException {
        if (this.c == null) {
            this.c = this.verbosity.intValue() < 0 ? new CompilerAccessLogic(this.dbConfig) : new CompilerAccessLogic(this.dbConfig, this.verbosity);
        }
        return this.c;
    }

    private void setVerbosity(Level verbosity) {
        if (this.verbosity.intValue() < 0) {
            this.verbosity = verbosity;
        }
    }

    private void printStatus(String[] args) throws Exception {
        int numberOfLines = 30;
        try {
            if (args.length > 1) {
                numberOfLines = Integer.parseInt(args[1]);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        System.out.println("---------------------------------- Status ----------------------------------\n");
        String msg = this.getCompilerAccess().getStatusMessage(CreateCompiler.getObjId(args[0]), numberOfLines);
        if (msg == null) {
            msg = "<null>";
        }
        System.out.println(msg);
        System.out.println("\n----------------------------------------------------------------------------");
        System.exit(0);
    }

    private void compileCase(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        boolean lazyMode = args.length > 1 ? CreateCompiler.getLazyMode(args[1]) : false;
        System.out.println("Trying to compile case " + objId);
        String v = "";
        if (args.length > 2) {
            v = ", " + args[2];
            this.setVerbosity(CreateCompiler.getVerbosity(v));
        }
        this.getCompilerAccess().compileAll(objId, lazyMode);
        System.out.println("Returned from compileAll(" + objId + ", " + (lazyMode ? "lazy" : "eager") + v + ");");
    }

    private void compileStep(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        boolean lazyMode = args.length > 1 ? CreateCompiler.getLazyMode(args[1]) : false;
        System.out.println("Trying to compile step " + objId + ".");
        String v = "";
        if (args.length > 2) {
            v = ", " + args[2];
            this.setVerbosity(CreateCompiler.getVerbosity(v));
        }
        this.getCompilerAccess().compileStep(objId, lazyMode);
        System.out.println("Returned from compileStep(" + objId + ", " + (lazyMode ? "lazy" : "eager") + v + ");");
    }

    private void compileStepFrom(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        boolean lazyMode = args.length > 1 ? CreateCompiler.getLazyMode(args[1]) : false;
        System.out.println("Trying to compile all steps dependent on step " + objId + ".");
        String v = "";
        if (args.length > 2) {
            v = ", " + args[2];
            this.setVerbosity(CreateCompiler.getVerbosity(v));
        }
        this.getCompilerAccess().compileStepFrom(objId, lazyMode);
        System.out.println("Returned from compileStepFrom(" + objId + ", " + (lazyMode ? "lazy" : "eager") + v + ");");
    }

    private void updateConceptStatistics(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        System.out.println("Updating Concept statistics for Concept " + objId + ".");
        this.getCompilerAccess().updateStatisticsForConcept(objId);
        System.out.println("Statistics updated for object with id: " + objId + " !");
    }

    private void updateColumnsetStatistics(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        System.out.println("Updating Columnset statistics for Columnset " + objId + ".");
        this.getCompilerAccess().updateColumnsetStatistics(objId);
        System.out.println("Statistics updated for object with id: " + objId + " !");
    }

    private void updateColumnStatistics(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        System.out.println("Updating Column statistics for Column " + objId + ".");
        this.getCompilerAccess().updateColumnStatistics(objId);
        System.out.println("Statistics updated for object with id: " + objId + " !");
    }

    private void garbageCollectionForStep(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        System.out.println("Running Garbage Collection for Step " + objId + ".");
        this.getCompilerAccess().deleteTrashForStep(objId);
        System.out.println("Garbage for Step with id " + objId + " collected!");
    }

    private void garbageCollectionForCase(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        System.out.println("Running Garbage Collection for Case " + objId + ".");
        this.getCompilerAccess().deleteTrashForCase(objId);
        System.out.println("Garbage for Case with id " + objId + " collected!");
    }

    private void checkStepReady(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        System.out.println("Checking if Step " + objId + " is ready for compilation.");
        boolean ready = this.getCompilerAccess().isReadyForCompilation(objId);
        System.out.println("Step with id " + objId + " is" + (ready ? "" : " not") + " ready for compilation!");
        System.exit(0);
    }

    private void compileRestOfCase(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        boolean lazyMode = args.length > 1 ? CreateCompiler.getLazyMode(args[1]) : false;
        System.out.println("Trying to compile rest of case " + objId);
        String v = "";
        if (args.length > 2) {
            v = ", " + args[2];
            this.setVerbosity(CreateCompiler.getVerbosity(v));
        }
        this.getCompilerAccess().compileRestOfCase(objId, lazyMode);
        System.out.println("Returned from compileAll(" + objId + ", " + (lazyMode ? "lazy" : "eager") + v + ");");
    }

    private static long getObjId(String s) {
        try {
            return Long.parseLong(s.trim());
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static boolean getLazyMode(String s) {
        String lazyString = s.trim().toLowerCase();
        return lazyString.startsWith("l") || lazyString.startsWith("y");
    }

    private static Level getVerbosity(String s) {
        return Print.getVerbosityLevelForName(s);
    }
}

