/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math;

import edu.udo.cs.yale.operator.ResultObjectAdapter;
import edu.udo.cs.yale.tools.math.Averagable;
import edu.udo.cs.yale.tools.math.AverageVector;
import java.util.ArrayList;
import java.util.ListIterator;

public class RunVector
extends ResultObjectAdapter {
    private ArrayList vectorList = new ArrayList();

    public void addVector(AverageVector av) {
        this.vectorList.add(av);
    }

    public AverageVector getVector(int index) {
        return (AverageVector)this.vectorList.get(index);
    }

    public ArrayList getVectorList() {
        return this.vectorList;
    }

    public int size() {
        return this.vectorList.size();
    }

    public AverageVector average() {
        AverageVector output = (AverageVector)this.getVector(0).clone();
        for (int i = 1; i < this.size(); ++i) {
            AverageVector av = this.getVector(i);
            for (int j = 0; j < av.size(); ++j) {
                output.getAveragable(j).buildAverage(av.getAveragable(j));
            }
        }
        return output;
    }

    public String toString() {
        String result = "RunVector: \n";
        ListIterator i = this.vectorList.listIterator();
        while (i.hasNext()) {
            result = result + (AverageVector)i.next() + "\n";
        }
        return result;
    }

    public String toResultString() {
        String result = "";
        AverageVector averageVector = this.average();
        for (int averagableIndex = 0; averagableIndex < averageVector.size(); ++averagableIndex) {
            result = result + "Time series of averagable '" + this.getVector(0).getAveragable(averagableIndex).getName() + "':";
            for (int timeIndex = 0; timeIndex < this.size(); ++timeIndex) {
                AverageVector currentAveragables = this.getVector(timeIndex);
                Averagable averagable = currentAveragables.getAveragable(averagableIndex);
                result = result + "  " + averagable.getValue();
            }
            result = result + "\n";
        }
        for (int i = 0; i < averageVector.size(); ++i) {
            Averagable averagable = averageVector.getAveragable(i);
            result = result + "  Average of averagable '" + averagable.getName() + "':  " + averagable.getValue();
            if (averagable.getVariance() >= 0.0) {
                result = result + "  (" + averagable.getVariance() + ")";
            }
            result = result + "\n";
        }
        result = result + "\n";
        return result;
    }
}

