/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import java.io.OutputStream;
import java.io.PrintStream;

public class FormattedPrintStream
extends PrintStream {
    private static final char[] SEPARATORS = new char[]{'.', ',', '-', '!', '?', ' '};
    private static final String F = "\b";
    private static final String FORMAT_TAG = "$";
    private static final String FORMAT_END = "^";
    private boolean ignore;
    private boolean indented;
    private int indent;
    private int linewidth;

    public FormattedPrintStream(OutputStream o) {
        this(o, false, 0, -1);
    }

    public FormattedPrintStream(OutputStream o, boolean format, int indent, int linewidth) {
        super(o, true);
        this.ignore = !format;
        this.indent = indent;
        this.linewidth = linewidth;
    }

    public void print(String string) {
        this.printIndented(this.format(string));
    }

    public void print(Object o) {
        this.printIndented(this.format(o.toString()));
    }

    public void print(char[] string) {
        this.print(new String(string));
    }

    public final String format(String formatMe) {
        if (formatMe == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        try {
            int tag = 0;
            int endtag = 0;
            while ((tag = formatMe.indexOf(FORMAT_TAG, endtag)) != -1) {
                result.append(formatMe.substring(endtag, tag));
                char format = formatMe.charAt(tag + 1);
                endtag = formatMe.indexOf(FORMAT_END + format, tag);
                if (endtag != -1) {
                    String substr = this.format(formatMe.substring(tag + 2, endtag));
                    if (!this.ignore) {
                        switch (format) {
                            case 'b': {
                                result.append(FormattedPrintStream.fett(substr));
                                break;
                            }
                            case 's': {
                                result.append(FormattedPrintStream.sperren(substr));
                                break;
                            }
                            case 'u': {
                                result.append(FormattedPrintStream.uppercase(substr));
                                break;
                            }
                            default: {
                                result.append(substr);
                                break;
                            }
                        }
                    } else {
                        result.append(substr);
                    }
                } else {
                    result.append(formatMe.substring(tag));
                    return result.toString();
                }
                endtag += FORMAT_END.length() + 1;
            }
            result.append(formatMe.substring(endtag));
        }
        catch (Exception e) {
            e.printStackTrace();
            return formatMe;
        }
        return result.toString();
    }

    public static final String fett(String string) {
        char[] c = string.toCharArray();
        String result = "";
        for (int i = 0; i < c.length; ++i) {
            result = result + c[i];
            if (c[i] <= ' ') continue;
            result = result + F;
            result = result + c[i];
        }
        return result;
    }

    public static final String sperren(String string) {
        char[] c = string.toCharArray();
        String result = "";
        for (int i = 0; i < c.length; ++i) {
            result = result + c[i] + (i < c.length - 1 ? " " : "");
        }
        return result;
    }

    public static final String uppercase(String string) {
        return string.toUpperCase();
    }

    private void printIndented(String str) {
        boolean first = !this.indented;
        int nl = -1;
        int s = 0;
        while ((nl = str.indexOf("\n", s)) >= 0) {
            if (!first) {
                super.print(FormattedPrintStream.indent(this.indent));
            }
            super.print(str.substring(s, nl));
            super.println();
            s = nl + 1;
            first = false;
        }
        if (!first) {
            super.print(FormattedPrintStream.indent(this.indent));
        }
        super.print(str.substring(s));
    }

    public static String indent(int indent) {
        String s = "";
        while (s.length() < indent) {
            s = s + " ";
        }
        return s;
    }

    public void setIndented(boolean indented) {
        this.indented = indented;
    }
}

