/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation.significance;

import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.operator.validation.significance.FDistribution;
import edu.udo.cs.yale.operator.validation.significance.SignificanceTestOperator;
import edu.udo.cs.yale.operator.validation.significance.SignificanceTestResult;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class AnovaSignificanceTestOperator
extends SignificanceTestOperator {
    public AnovaSignificanceTestOperator(OperatorDescription description) {
        super(description);
    }

    public SignificanceTestResult performSignificanceTest(PerformanceVector[] allVectors, double alpha) {
        double meanOfMeans = 0.0;
        for (int i = 0; i < allVectors.length; ++i) {
            meanOfMeans += allVectors[i].getMainCriterion().getValue();
        }
        meanOfMeans /= (double)allVectors.length;
        double sumSquaresBetween = 0.0;
        for (int i = 0; i < allVectors.length; ++i) {
            PerformanceCriterion pc = allVectors[i].getMainCriterion();
            double diff = pc.getValue() - meanOfMeans;
            sumSquaresBetween += (double)pc.getExampleCount() * (diff * diff);
        }
        double sumSquaresResiduals = 0.0;
        int counterSum = 0;
        for (int i = 0; i < allVectors.length; ++i) {
            PerformanceCriterion pc = allVectors[i].getMainCriterion();
            sumSquaresResiduals += (double)(pc.getExampleCount() - 1) * pc.getVariance();
            counterSum += pc.getExampleCount();
        }
        return new AnovaSignificanceTestResult(sumSquaresBetween, sumSquaresResiduals, allVectors.length - 1, counterSum - allVectors.length, alpha);
    }

    public int getMinSize() {
        return 2;
    }

    public int getMaxSize() {
        return Integer.MAX_VALUE;
    }

    public class AnovaSignificanceTestResult
    extends SignificanceTestResult {
        private double sumSquaresBetween = 0.0;
        private double sumSquaresResiduals = 0.0;
        private double meanSquaresBetween = 0.0;
        private double meanSquaresResiduals = 0.0;
        private int df1 = 0;
        private int df2 = 0;
        private double fValue = 0.0;
        private double prob = 0.0;
        private double alpha = 0.05;

        public AnovaSignificanceTestResult(double sumSquaresBetween, double sumSquaresResiduals, int df1, int df2, double alpha) {
            this.sumSquaresBetween = sumSquaresBetween;
            this.sumSquaresResiduals = sumSquaresResiduals;
            this.df1 = df1;
            this.df2 = df2;
            this.alpha = alpha;
            this.meanSquaresBetween = sumSquaresBetween / (double)df1;
            this.meanSquaresResiduals = sumSquaresResiduals / (double)df2;
            this.fValue = this.meanSquaresBetween / this.meanSquaresResiduals;
            FDistribution fDist = new FDistribution(df1, df2);
            this.prob = fDist.getProbabilityForValue(this.fValue);
            this.prob = this.prob < 0.0 ? 1.0 : 1.0 - this.prob;
        }

        public String getName() {
            return "Anova Test";
        }

        public String toString() {
            return "ANOVA result (f=" + Tools.formatNumber(this.fValue) + ", prob=" + Tools.formatNumber(this.prob) + ", alpha=" + Tools.formatNumber(this.alpha) + ")";
        }

        public Component getVisualisationComponent() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<table bgcolor=\"#E3D8C3\" border=\"1\">");
            buffer.append("<tr bgcolor=\"#ccccff\"><th>Source</th><th>Square Sums</th><th>DF</th><th>Mean Squares</th><th>F</th><th>Prob</th></tr>");
            buffer.append("<tr><td>Between</td><td>" + Tools.formatNumber(this.sumSquaresBetween) + "</td><td>" + this.df1 + "</td><td>" + Tools.formatNumber(this.meanSquaresBetween) + "</td><td>" + Tools.formatNumber(this.fValue) + "</td><td>" + Tools.formatNumber(this.prob) + "</td></tr>");
            buffer.append("<tr><td>Residuals</td><td>" + Tools.formatNumber(this.sumSquaresResiduals) + "</td><td>" + this.df2 + "</td><td>" + Tools.formatNumber(this.meanSquaresResiduals) + "</td><td></td><td></td></tr>");
            buffer.append("<tr><td>Total</td><td>" + Tools.formatNumber(this.sumSquaresBetween + this.sumSquaresResiduals) + "</td><td>" + (this.df1 + this.df2) + "</td><td></td><td></td><td></td></tr>");
            buffer.append("</table>");
            buffer.append("Probability for random values with the same result: " + Tools.formatNumber(this.prob) + "<br>");
            if (this.prob < this.alpha) {
                buffer.append("Difference between actual mean values is probably significant, since " + Tools.formatNumber(this.prob) + " &lt; alpha = " + Tools.formatNumber(this.alpha) + "!");
            } else {
                buffer.append("Difference between actual mean values is probably not significant, since " + Tools.formatNumber(this.prob) + " &gt; alpha = " + Tools.formatNumber(this.alpha) + "!");
            }
            JLabel label = new JLabel("<html><h1>" + this.getName() + "</h1>" + buffer.toString() + "</html>");
            label.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
            label.setFont(label.getFont().deriveFont(0));
            return label;
        }
    }
}

