/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.operator.validation.WrapperValidationChain;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.List;

public class WrapperXValidation
extends WrapperValidationChain {
    private int number;
    private int iteration;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$AttributeWeights;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceVector;

    public WrapperXValidation(OperatorDescription description) {
        super(description);
        this.addValue(new Value("iteration", "The number of the current iteration."){

            public double getValue() {
                return WrapperXValidation.this.iteration;
            }
        });
    }

    public int getNumberOfValidationSteps() {
        return this.number;
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet eSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = WrapperXValidation.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        this.number = this.getParameterAsBoolean("leave_one_out") ? eSet.getSize() : this.getParameterAsInt("number_of_validations");
        int samplingType = this.getParameterAsInt("sampling_type");
        SplittedExampleSet inputSet = new SplittedExampleSet(eSet, this.number, samplingType);
        LogService.logMessage(this.getName() + ": Starting " + this.number + "-fold method cross validation", 2);
        PerformanceVector performanceVector = null;
        AttributeWeights globalWeights = new AttributeWeights();
        for (int i = 0; i < eSet.getNumberOfAttributes(); ++i) {
            String current = eSet.getAttribute(i).getName();
            globalWeights.setWeight(current, 0.0);
        }
        this.iteration = 0;
        while (this.iteration < this.number) {
            inputSet.selectAllSubsetsBut(this.iteration);
            AttributeWeights weights = (AttributeWeights)this.useMethod(inputSet).remove(class$edu$udo$cs$yale$example$AttributeWeights == null ? WrapperXValidation.class$("edu.udo.cs.yale.example.AttributeWeights") : class$edu$udo$cs$yale$example$AttributeWeights);
            SplittedExampleSet newInputSet = (SplittedExampleSet)inputSet.clone();
            this.learn(new AttributeWeightedExampleSet(newInputSet, weights, 0.0).createCleanExampleSet());
            newInputSet.selectSingleSubset(this.iteration);
            IOContainer evalOutput = this.evaluate(new AttributeWeightedExampleSet(newInputSet, weights, 0.0).createCleanExampleSet());
            PerformanceVector iterationPerformance = (PerformanceVector)evalOutput.remove(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? WrapperXValidation.class$("edu.udo.cs.yale.operator.performance.PerformanceVector") : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
            if (performanceVector == null) {
                performanceVector = iterationPerformance;
            } else {
                for (int i = 0; i < performanceVector.size(); ++i) {
                    performanceVector.getCriterion(i).buildAverage(iterationPerformance.getCriterion(i));
                }
            }
            this.handleWeights(globalWeights, weights);
            this.setResult(iterationPerformance.getMainCriterion());
            this.inApplyLoop();
            ++this.iteration;
        }
        Iterator i = globalWeights.getAttributeNames().iterator();
        while (i.hasNext()) {
            String currentName = (String)i.next();
            globalWeights.setWeight(currentName, globalWeights.getWeight(currentName) / (double)this.number);
        }
        IOObject[] outputArray = new IOObject[2];
        this.setResult(performanceVector.getMainCriterion());
        return new IOObject[]{performanceVector, globalWeights};
    }

    private void handleWeights(AttributeWeights globalWeights, AttributeWeights currentWeights) {
        Iterator i = currentWeights.getAttributeNames().iterator();
        while (i.hasNext()) {
            String currentName = (String)i.next();
            double globalWeight = globalWeights.getWeight(currentName);
            double currentWeight = currentWeights.getWeight(currentName);
            if (Double.isNaN(globalWeight)) {
                globalWeights.setWeight(currentName, currentWeight);
                continue;
            }
            globalWeights.setWeight(currentName, globalWeight + currentWeight);
        }
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = WrapperXValidation.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector, class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = WrapperXValidation.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("number_of_validations", "Number of subsets for the crossvalidation.", 2, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("leave_one_out", "Set the number of validations to the number of examples. If set to true, number_of_validations is ignored.", false));
        types.add(new ParameterTypeCategory("sampling_type", "Defines the sampling type of the cross validation.", SplittedExampleSet.SAMPLING_NAMES, 2));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

