/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IODescription;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.math.AverageVector;
import java.util.Iterator;
import java.util.List;

public abstract class ValidationChain
extends OperatorChain {
    private static final Class[] INPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ValidationChain.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = ValidationChain.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector};
    private PerformanceCriterion lastPerformance;
    private IOContainer learnResult;
    private boolean methodEvaluation;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceVector;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$learner$Model;

    public ValidationChain(OperatorDescription description) {
        super(description);
        this.addValue(new Value("performance", "The last performance average (main criterion)."){

            public double getValue() {
                if (ValidationChain.this.lastPerformance != null) {
                    return ValidationChain.this.lastPerformance.getValue();
                }
                return Double.NaN;
            }
        });
        this.addValue(new Value("variance", "The variance of the last performance (main criterion)."){

            public double getValue() {
                if (ValidationChain.this.lastPerformance != null) {
                    return ValidationChain.this.lastPerformance.getVariance();
                }
                return Double.NaN;
            }
        });
    }

    public abstract int getNumberOfValidationSteps();

    public abstract IOObject[] estimatePerformance(ExampleSet var1) throws OperatorException;

    public int getMaxNumberOfInnerOperators() {
        return 2;
    }

    public int getMinNumberOfInnerOperators() {
        return 2;
    }

    public InputDescription getInputDescription(Class cls) {
        if ((class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ValidationChain.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet).isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        Operator learner = this.getLearner();
        Operator evaluator = this.getEvaluator();
        if (!IODescription.containsClass(class$edu$udo$cs$yale$operator$learner$Model == null ? (class$edu$udo$cs$yale$operator$learner$Model = ValidationChain.class$("edu.udo.cs.yale.operator.learner.Model")) : class$edu$udo$cs$yale$operator$learner$Model, input = learner.checkIO(input))) {
            throw new IllegalInputException(this, learner, class$edu$udo$cs$yale$operator$learner$Model == null ? (class$edu$udo$cs$yale$operator$learner$Model = ValidationChain.class$("edu.udo.cs.yale.operator.learner.Model")) : class$edu$udo$cs$yale$operator$learner$Model);
        }
        Class[] newInput = new Class[input.length + 1];
        for (int i = 0; i < input.length; ++i) {
            newInput[i] = input[i];
        }
        newInput[newInput.length - 1] = class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ValidationChain.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet;
        if (!IODescription.containsClass(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = ValidationChain.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector, input = evaluator.checkIO(newInput))) {
            throw new IllegalInputException(this, evaluator, class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = ValidationChain.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
        }
        return this.getDeliveredOutputClasses();
    }

    private Operator getLearner() {
        return this.getOperator(0);
    }

    private Operator getEvaluator() {
        return this.getOperator(1);
    }

    protected void setResult(PerformanceCriterion pc) {
        this.lastPerformance = pc;
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet eSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ValidationChain.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        IOObject[] estimation = this.estimatePerformance(eSet);
        return estimation;
    }

    protected IOContainer learn(ExampleSet trainingSet) throws OperatorException {
        this.learnResult = this.getLearner().apply(new IOContainer(new IOObject[]{trainingSet}));
        return this.learnResult;
    }

    protected IOContainer evaluate(ExampleSet testSet) throws OperatorException {
        if (this.learnResult == null) {
            throw new RuntimeException("Wrong use of ValidationChain.evaluate(ExampleSet): No preceding invocation of learn(ExampleSet)!");
        }
        Attribute predictedBefore = testSet.getPredictedLabel();
        IOContainer evalInput = this.learnResult.append(new IOObject[]{testSet});
        IOContainer result = this.getEvaluator().apply(evalInput);
        Attribute predictedAfter = testSet.getPredictedLabel();
        if (predictedAfter != null && (predictedBefore == null || predictedBefore.getTableIndex() != predictedAfter.getTableIndex())) {
            if (predictedAfter.isNominal()) {
                Iterator i = predictedAfter.getValues().iterator();
                while (i.hasNext()) {
                    String value = (String)i.next();
                    Attribute currentConfidenceAttribute = testSet.getAttribute("confidence(" + value + ")");
                    if (currentConfidenceAttribute == null) continue;
                    testSet.removeAttribute(currentConfidenceAttribute);
                    testSet.getExampleTable().removeAttribute(currentConfidenceAttribute);
                }
            }
            testSet.clearPredictedLabel();
            testSet.getExampleTable().removeAttribute(predictedAfter);
        }
        this.learnResult = null;
        return result;
    }

    protected PerformanceVector getPerformanceVector(List averageVectors) {
        Iterator i = averageVectors.iterator();
        while (i.hasNext()) {
            AverageVector currentAverage = (AverageVector)i.next();
            if (!(currentAverage instanceof PerformanceVector)) continue;
            return (PerformanceVector)currentAverage;
        }
        return null;
    }

    public int getNumberOfSteps() {
        return this.getNumberOfValidationSteps() * super.getNumberOfChildrensSteps() + 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

