/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.preprocessing.Discretization;
import java.util.List;

public class SimpleBinDiscretization
extends Discretization {
    public SimpleBinDiscretization(OperatorDescription description) {
        super(description);
    }

    public double[][] getRanges(ExampleSet exampleSet) {
        int numberOfBins = this.getParameterAsInt("number_of_bins");
        double[][] ranges = new double[exampleSet.getNumberOfAttributes()][numberOfBins];
        for (int a = 0; a < exampleSet.getNumberOfAttributes(); ++a) {
            Attribute attribute = exampleSet.getAttribute(a);
            if (!attribute.isNumerical()) continue;
            double min = attribute.getMinimum();
            double max = attribute.getMaximum();
            for (int b = 0; b < numberOfBins; ++b) {
                ranges[a][b] = min + (double)(b + 1) / (double)numberOfBins * (max - min);
            }
        }
        return ranges;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("number_of_bins", "Defines the number of bins which should be used for each attribute.", 2, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

