/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeNumber;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NoiseOperator
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = NoiseOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = NoiseOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public NoiseOperator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = NoiseOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        exampleSet.recalculateAllAttributeStatistics();
        HashMap<String, Double> noiseMap = new HashMap<String, Double>();
        List noises = this.getParameterList("noise");
        Iterator i = noises.iterator();
        while (i.hasNext()) {
            Object[] pair = (Object[])i.next();
            noiseMap.put((String)pair[0], (Double)pair[1]);
        }
        double defaultAttributeNoise = this.getParameterAsDouble("default_attribute_noise");
        double labelNoise = this.getParameterAsDouble("label_noise");
        ExampleReader reader = exampleSet.getExampleReader();
        Attribute label = exampleSet.getLabel();
        while (reader.hasNext()) {
            int oldValue;
            Example example = reader.next();
            for (int j = 0; j < exampleSet.getNumberOfAttributes(); ++j) {
                Attribute attribute = exampleSet.getAttribute(j);
                if (!attribute.isNumerical()) continue;
                Double noiseObject = (Double)noiseMap.get(attribute.getName());
                double noise = noiseObject == null ? defaultAttributeNoise : noiseObject;
                double noiseValue = RandomGenerator.getGlobalRandomGenerator().nextGaussian() * noise;
                example.setValue(attribute, example.getValue(attribute) + noiseValue);
            }
            if (label == null) continue;
            if (label.isNumerical()) {
                double noiseValue = RandomGenerator.getGlobalRandomGenerator().nextGaussian() * labelNoise * Math.abs(label.getMaximum() - label.getMinimum());
                example.setValue(label, example.getValue(label) + noiseValue);
                continue;
            }
            if (!label.isNominal() || label.getNumberOfValues() < 2 || !(RandomGenerator.getGlobalRandomGenerator().nextDouble() < labelNoise)) continue;
            int newValue = oldValue = (int)example.getValue(label);
            while (newValue == oldValue) {
                newValue = RandomGenerator.getGlobalRandomGenerator().nextInt(label.getNumberOfValues()) + 0;
            }
            example.setValue(label, newValue);
        }
        int numberOfNewAttributes = this.getParameterAsInt("random_attributes");
        LinkedList<Attribute> newAttributes = new LinkedList<Attribute>();
        for (int j = 0; j < numberOfNewAttributes; ++j) {
            newAttributes.add(AttributeFactory.createAttribute(AttributeFactory.createName("random"), 4));
        }
        exampleSet.getExampleTable().addAttributes(newAttributes);
        exampleSet.addAllAttributes(newAttributes);
        reader = exampleSet.getExampleReader();
        while (reader.hasNext()) {
            Example example = reader.next();
            i = newAttributes.iterator();
            while (i.hasNext()) {
                example.setValue((Attribute)i.next(), RandomGenerator.getGlobalRandomGenerator().nextDouble());
            }
        }
        return new IOObject[]{exampleSet};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt("random_attributes", "Adds this number of random attributes.", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("label_noise", "Add this percentage of a numerical label range as a normal distributed noise or probability for a nominal label change.", 0.0, Double.POSITIVE_INFINITY, 0.05);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("default_attribute_noise", "The standard deviation of the default attribute noise.", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeList("noise", "List of noises for each attributes.", new ParameterTypeDouble("noise", "Names of attributes and noises to use.", 0.0, Double.POSITIVE_INFINITY, 0.05)));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

