/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.List;

public class MergeNominalValues
extends Operator {
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public MergeNominalValues(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = MergeNominalValues.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        String name = this.getParameterAsString("attribute_name");
        Attribute attribute = null;
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            Attribute current = exampleSet.getAttribute(i);
            if (!current.getName().equals(name)) continue;
            if (!current.isNominal()) {
                throw new UserError((Operator)this, 119, new Object[]{name, this.getName()});
            }
            attribute = current;
            break;
        }
        if (attribute == null) {
            throw new UserError((Operator)this, 111, name);
        }
        String firstValue = this.getParameterAsString("first_value");
        String secondValue = this.getParameterAsString("second_value");
        this.mergeValues(exampleSet, attribute, firstValue, secondValue);
        return new IOObject[]{exampleSet};
    }

    private void mergeValues(ExampleSet exampleSet, Attribute attribute, String firstValue, String secondValue) {
        Attribute newAttribute = AttributeFactory.createAttribute(attribute, "merged");
        newAttribute.clearMaps();
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.addAttribute(newAttribute);
        double first = attribute.mapString(firstValue);
        double second = attribute.mapString(secondValue);
        String firstPlusSecondString = firstValue + "_" + secondValue;
        ExampleReader reader = exampleSet.getExampleReader();
        while (reader.hasNext()) {
            Example example = reader.next();
            double value = example.getValue(attribute);
            if (Double.isNaN(value)) {
                example.setValue(newAttribute, Double.NaN);
                continue;
            }
            if (value == first || value == second) {
                example.setValue(newAttribute, newAttribute.mapString(firstPlusSecondString));
                continue;
            }
            example.setValue(newAttribute, newAttribute.mapString(attribute.mapIndex((int)value)));
        }
        exampleSet.removeAttribute(attribute);
        newAttribute.setName(attribute.getName());
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = MergeNominalValues.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = MergeNominalValues.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeString("attribute_name", "The name of the nominal attribute which values should be merged.", false));
        types.add(new ParameterTypeString("first_value", "The first value which should be merged.", false));
        types.add(new ParameterTypeString("second_value", "The second value which should be merged.", false));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

