/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.preprocessing.FeatureFilter;
import edu.udo.cs.yale.tools.Ontology;
import java.util.List;

public class FeatureValueTypeFilter
extends FeatureFilter {
    public FeatureValueTypeFilter(OperatorDescription description) {
        super(description);
    }

    public boolean switchOffFeature(Attribute feature) throws OperatorException {
        int type = this.getParameterAsInt("skip_features_of_type") + 1;
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(feature.getValueType(), type);
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        String[] valueTypes = new String[Ontology.VALUE_TYPE_NAMES.length - 1];
        for (int i = 0; i < valueTypes.length; ++i) {
            valueTypes[i] = Ontology.VALUE_TYPE_NAMES[i + 1];
        }
        ParameterTypeCategory type = new ParameterTypeCategory("skip_features_of_type", "All features of this type will be deselected off.", valueTypes, 0);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

