/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeParser;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class FeatureGenerationOperator
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = FeatureGenerationOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = FeatureGenerationOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public FeatureGenerationOperator(OperatorDescription description) {
        super(description);
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)((ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = FeatureGenerationOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet)).clone();
        boolean keepAll = this.getParameterAsBoolean("keep_all");
        String filename = this.getParameterAsString("filename");
        try {
            AttributeParser parser = new AttributeParser(exampleSet.getExampleTable());
            if (filename != null) {
                parser.parseAll(new FileReader(this.getExperiment().resolveFileName(filename)));
            }
            Iterator j = this.getParameterList("functions").iterator();
            while (j.hasNext()) {
                Object[] nameFunctionPair = (Object[])j.next();
                Attribute attribute = parser.parse((String)nameFunctionPair[1]);
                attribute.setName((String)nameFunctionPair[0]);
            }
            if (!keepAll) {
                exampleSet.removeAllAttributes();
            }
            parser.generateAll(exampleSet);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{filename, e.getMessage()});
        }
        return new IOObject[]{exampleSet};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterType type = new ParameterTypeFile("filename", "Create the attributes listed in this file (written by an AttributeSetWriter).", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeList("functions", "List of functions to generate.", new ParameterTypeString("function", "Function and arguments to use for generation."));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("keep_all", "If set to true, all the original attributes are kept, otherwise they are removed from the example set.", false));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

