/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Condition;
import edu.udo.cs.yale.example.ConditionCreationException;
import edu.udo.cs.yale.example.ConditionExampleReader;
import edu.udo.cs.yale.example.ConditionedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;

public class ExampleFilter
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ExampleFilter.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ExampleFilter.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    private int dataRowType;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public ExampleFilter(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet inputSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ExampleFilter.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        LogService.logMessage(this.getName() + ": input set has " + inputSet.getSize() + " examples.", 2);
        String className = this.getParameterAsString("condition_class");
        String parameter = this.getParameterAsString("parameter_string");
        this.logMessage("Creating condition '" + className + "' with parameter '" + parameter + "'", 0);
        Condition condition = null;
        try {
            condition = ConditionExampleReader.createCondition(className, inputSet, parameter);
        }
        catch (ConditionCreationException e) {
            throw new UserError((Operator)this, 904, className, (Object)e.getMessage());
        }
        ConditionedExampleSet result = new ConditionedExampleSet(inputSet, condition);
        return new IOObject[]{result};
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeStringCategory("condition_class", "Implementation of the condition.", ConditionExampleReader.KNOWN_CONDITION_NAMES, ConditionExampleReader.KNOWN_CONDITION_NAMES[0]);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString("parameter_string", "Parameter string for the condition, e.g. 'attribute=value' for the AttributeValueFilter.", true);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

