/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.SparseArrayDataRow;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.Ontology;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Attribute2RealValueMapping
extends Operator {
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public Attribute2RealValueMapping(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet eSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = Attribute2RealValueMapping.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        ExampleSet result = null;
        LinkedList<String> nomAtts = new LinkedList<String>();
        if (this.getParameterAsBoolean("dichotomization")) {
            Attribute attribute;
            LinkedList<Attribute> attributes = new LinkedList<Attribute>();
            if (this.getParameterAsBoolean("all_nominal_attributes")) {
                for (int i = 0; i < eSet.getNumberOfAttributes(); ++i) {
                    Attribute attribute2 = eSet.getAttribute(i);
                    if (attribute2.isNominal()) {
                        this.handleNominalAttribute(attribute2, attributes);
                        nomAtts.add(attribute2.getName());
                        continue;
                    }
                    Attribute newAttribute = AttributeFactory.createAttribute(attribute2.getName(), 4);
                    attributes.add(newAttribute);
                }
            } else {
                String nominal_attributes = this.getParameterAsString("nominal_attributes");
                if (nominal_attributes == null) {
                    nominal_attributes = new String("");
                }
                StringTokenizer st = new StringTokenizer(nominal_attributes, ",");
                while (st.hasMoreTokens()) {
                    nomAtts.add(st.nextToken());
                }
                for (int i = 0; i < eSet.getNumberOfAttributes(); ++i) {
                    attribute = eSet.getAttribute(i);
                    if (attribute.isNominal() && nomAtts.contains(attribute.getName())) {
                        this.handleNominalAttribute(attribute, attributes);
                        continue;
                    }
                    attributes.add(attribute);
                }
            }
            HashMap<String, Attribute> specialMap = new HashMap<String, Attribute>();
            Iterator i = eSet.getSpecialAttributeNames().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                attribute = (Attribute)eSet.getAttribute(name).clone();
                attributes.add(attribute);
                specialMap.put(name, attribute);
            }
            MemoryExampleTable exampleTable = new MemoryExampleTable(attributes);
            LinkedList<DataRow> dataRows = new LinkedList<DataRow>();
            ExampleReader exampleReader = eSet.getExampleReader();
            while (exampleReader.hasNext()) {
                Example example = exampleReader.next();
                dataRows.add(this.createDataRow(example, eSet, specialMap, attributes.size(), attributes, nomAtts));
            }
            ListDataRowReader reader = new ListDataRowReader(dataRows.iterator());
            exampleTable.readExamples(reader);
            result = exampleTable.createCompleteExampleSet(specialMap);
        } else {
            if (this.getParameterAsBoolean("all_nominal_attributes")) {
                for (int i = 0; i < eSet.getNumberOfAttributes(); ++i) {
                    Attribute attribute = eSet.getAttribute(i);
                    eSet.replaceAttribute(attribute, AttributeFactory.changeValueType(attribute, 4));
                }
            } else {
                String nominal_attributes = this.getParameterAsString("nominal_attributes");
                if (nominal_attributes == null) {
                    nominal_attributes = new String("");
                }
                StringTokenizer st = new StringTokenizer(nominal_attributes, ",");
                while (st.hasMoreTokens()) {
                    nomAtts.add(st.nextToken());
                }
                for (int i = 0; i < eSet.getNumberOfAttributes(); ++i) {
                    Attribute attribute = eSet.getAttribute(i);
                    if (attribute.isNominal() && nomAtts.contains(attribute.getName())) {
                        eSet.replaceAttribute(attribute, AttributeFactory.changeValueType(attribute, 4));
                        continue;
                    }
                    if (attribute.isNominal()) continue;
                    eSet.replaceAttribute(attribute, AttributeFactory.changeValueType(attribute, 4));
                }
            }
            result = eSet;
        }
        return new IOObject[]{result};
    }

    private void handleNominalAttribute(Attribute attribute, List attributes) {
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 7) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 8)) {
            Attribute newAttribute = AttributeFactory.createAttribute(attribute.getName(), 4);
            attributes.add(newAttribute);
        } else {
            Iterator i = attribute.getValues().iterator();
            while (i.hasNext()) {
                Attribute newAttribute = AttributeFactory.createAttribute(attribute.getName() + "_" + (String)i.next(), 4);
                attributes.add(newAttribute);
            }
        }
    }

    private DataRow createDataRow(Example example, ExampleSet eSet, Map specialAttributes, int size, List allAttributes, List nomAtts) {
        Attribute newAttribute;
        Attribute oldAttribute;
        SparseArrayDataRow result = new SparseArrayDataRow();
        int currentResultIndex = 0;
        for (int i = 0; i < eSet.getNumberOfAttributes(); ++i) {
            oldAttribute = eSet.getAttribute(i);
            if (oldAttribute.isNominal() && nomAtts.contains(oldAttribute.getName())) {
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(oldAttribute.getValueType(), 7) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(oldAttribute.getValueType(), 8)) {
                    newAttribute = (Attribute)allAttributes.get(currentResultIndex++);
                    result.set(newAttribute, example.getValue(oldAttribute));
                    continue;
                }
                int index = (int)example.getValue(oldAttribute) - 0;
                Attribute newAttribute2 = (Attribute)allAttributes.get(currentResultIndex + index);
                result.set(newAttribute2, 1.0);
                currentResultIndex += oldAttribute.getValues().size();
                continue;
            }
            newAttribute = (Attribute)allAttributes.get(currentResultIndex++);
            result.set(newAttribute, example.getValue(oldAttribute));
        }
        Iterator i = specialAttributes.keySet().iterator();
        while (i.hasNext()) {
            oldAttribute = eSet.getAttribute((String)i.next());
            newAttribute = (Attribute)allAttributes.get(currentResultIndex++);
            result.set(newAttribute, example.getValue(oldAttribute));
        }
        return result;
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = Attribute2RealValueMapping.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = Attribute2RealValueMapping.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeBoolean("all_nominal_attributes", "If checked the values of all nominal attributes are mapped to numerical attributes.", true);
        types.add(type);
        type = new ParameterTypeString("nominal_attributes", "Comma-separated list of nominal attributes for mapping.");
        types.add(type);
        type = new ParameterTypeBoolean("dichotomization", "Uses one new attribute for each possible value of nominal attributes (new example table increasing used memory)", false);
        types.add(type);
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

