/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.tools.math.Averagable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class SimpleCriterion
extends MeasuredPerformance {
    private double sum = 0.0;
    private double squaresSum = 0.0;
    private int exampleCount = 0;

    public void writeCriterionData(PrintWriter out) throws IOException {
        out.println("sum: " + this.sum);
        out.println("squares_sum: " + this.squaresSum);
        out.println("example_count: " + this.exampleCount);
    }

    public void readCriterionData(BufferedReader in) throws IOException {
        String line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.sum = Double.parseDouble(line);
        line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.squaresSum = Double.parseDouble(line);
        line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.exampleCount = Integer.parseInt(line);
    }

    public int getExampleCount() {
        return this.exampleCount;
    }

    public void countExample(Example example) {
        double deviation;
        double plabel = example.getValue(example.getAttribute("prediction"));
        double label = example.getValue(example.getAttribute("label"));
        if (Double.isNaN(plabel)) {
            plabel = 0.0;
        }
        if (!Double.isNaN(deviation = this.countExample(label, plabel))) {
            this.countExample(deviation);
        }
    }

    protected abstract double countExample(double var1, double var3);

    protected double transform(double value) {
        return value;
    }

    protected void countExample(double deviation) {
        if (!Double.isNaN(deviation)) {
            this.sum += deviation;
            this.squaresSum += deviation * deviation;
            ++this.exampleCount;
        }
    }

    public double getValue() {
        return this.transform(this.sum) / (double)this.exampleCount;
    }

    public double getVariance() {
        double mean = this.getValue();
        double meanSquares = this.transform(this.squaresSum) / (double)this.exampleCount;
        return meanSquares - mean * mean;
    }

    public void startCounting(ExampleSet eset) throws OperatorException {
        super.startCounting(eset);
        this.exampleCount = 0;
        this.squaresSum = 0.0;
        this.sum = 0.0;
    }

    public double getFitness() {
        if (this.getValue() == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return 1.0 / this.getValue();
    }

    protected void cloneAveragable(Averagable newAvg) {
        SimpleCriterion sc = (SimpleCriterion)newAvg;
        this.sum = sc.sum;
        this.squaresSum = sc.squaresSum;
        this.exampleCount = sc.exampleCount;
    }

    public void buildSingleAverage(Averagable performance) {
        SimpleCriterion other = (SimpleCriterion)performance;
        this.sum += other.sum;
        this.squaresSum += other.squaresSum;
        this.exampleCount += other.exampleCount;
    }
}

